<?php

/**
 * Подключаемый файл счётчиков непрочитанных для использования за пределами модуля
 */

declare(strict_types=1);

use Johncms\System\Users\User;

defined('_IN_JOHNCMS') || die('Error: restricted access');

/** @var PDO $db */
$db = di(PDO::class);
/** @var User $user */
$user = di(User::class);
$time = time();

// Автоочистка раз в час
$cacheFile = CACHE_PATH . 'qa-cleanup.cache';
if (!file_exists($cacheFile) || filemtime($cacheFile) < ($time - 60 * 60)) {
    $sql = "DELETE FROM `qa_read`
            WHERE `read_at` < DATE_SUB(FROM_UNIXTIME($time), INTERVAL 7 DAY)";
    $db->exec($sql);
    $sql = "DELETE FROM `qa_answers_read`
            WHERE `read_at` < DATE_SUB(FROM_UNIXTIME($time), INTERVAL 7 DAY)
              AND `answer_id` != '0'" ;
    $db->exec($sql);
    file_put_contents($cacheFile, $time);
}

$total = $db->query(
        'SELECT COUNT(*) FROM `qa_questions`'
        )->fetchColumn();
$newQuestions = 0;
$newAnswers = 0;
if ($user->isValid()) {
    $userId = $user->id;
    $sql = "SELECT COUNT(*) FROM `qa_questions`
            LEFT JOIN `qa_read` ON `qa_questions`.`id` = `qa_read`.`question_id`
                  AND `qa_read`.`user_id` = $userId
            WHERE (`qa_read`.`question_id` IS NULL OR `qa_questions`.`created_at` > `qa_read`.`read_at`)
              AND `qa_questions`.`created_at` > DATE_SUB(FROM_UNIXTIME($time), INTERVAL 7 DAY)";
    $newQuestions = $db->query($sql)->fetchColumn();

    $sql = "SELECT COUNT(*) FROM `qa_answers`
            LEFT JOIN `qa_answers_read` ON `qa_answers`.`id` = `qa_answers_read`.`answer_id`
                  AND `qa_answers_read`.`user_id` = $userId
            WHERE `qa_answers_read`.`user_id` IS NULL
              AND `qa_answers`.`created_at` > DATE_SUB(FROM_UNIXTIME($time), INTERVAL 7 DAY);";
    $newAnswers = $db->query($sql)->fetchColumn();
}
return [
    'total' => $total,
    'new' => $newQuestions + $newAnswers,
    'new_questions' => $newQuestions,
    'new_answers' => $newAnswers,
];
