<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class FindAnswer extends Show
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Просмотр ответа';
    }

    public function invoke() : void
    {
        $id = intval($this->context->routeParam() ?: 0);
        if ($id <= 0) {
            $this->resultNotFound();
        }

        $answer = $this->context->answersEntity()->getById($id);
        if (empty($answer['id'])) {
            $this->resultNotFound();
        }
        $this->showQuestion($answer['question_id'], $id);
    }
}
