<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class DeleteComment extends Comment
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Удаление комментария';
    }

    public function invoke() : void
    {
        $id = intval($this->context->routeParam() ?: 0);
        if ($id <= 0) {
            $this->resultNotFound();
        }

        $commentsEntity = $this->context->commentsEntity();
        $comment = $commentsEntity->getById($id);
        if (empty($comment['id'])) {
            $this->resultNotFound();
        }
        $this->backUrl = $this->getBacklink(
                $comment['parent_id'], $comment['parent_type']);

        if (!$commentsEntity->canDelete($comment)) {
            $this->resultForbidden();
        }

        if (isset($_GET['confirm'])) {
            $commentsEntity->delete($comment);
            $_SESSION['alert'] = [
                'type' => 'alert-warning',
                'content' => 'Комментарий удалён'
            ];
            header('Location: ' . $this->backUrl);
            return;
        }

        $this->render('qa::delete', [
            'page_title' => $this->title,
            'caption_html' => 'комментарий',
            'data' => [
                'delete_url' => "/qa/delcomment/$id?confirm",
                'back_url' => $this->backUrl,
            ],
        ]);
    }
}
