<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class Show extends AbstractAction
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Просмотр вопроса';
    }

    public function invoke() : void
    {
        $id = intval($this->context->routeParam() ?: 0);
        $this->showQuestion($id);
    }

    protected function showQuestion(int $id, int $specificAnswer = 0)
    {
        global $start;
        if ($id <= 0) {
            return $this->resultNotFound();
        }

        $questionsEntity = $this->context->questionsEntity();
        $question = $questionsEntity->getById($id);
        if (empty($question['id'])) {
            return $this->resultNotFound();
        }

        $user = $this->context->user();
        $question['sameUser'] = ($user->id == $question['author_id']);
        // Увеличиваем просмотры
        if (!$question['sameUser'] && !$specificAnswer && ($start == 0)) {
            $question['views'] = intval($question['views']) + 1;
            $questionsEntity->table()->where('id', $id)->increment('views');
        }
        // Статус-сообщения
        $alert = [];
        if (isset($_SESSION['alert'])) {
            $alert = $_SESSION['alert'];
            unset($_SESSION['alert']);
        }

        $answersEntity = $this->context->answersEntity();
        $commentsEntity = $this->context->commentsEntity();

        [$question['commentsCount'], $question['comments']] = $commentsEntity->getFor($id, 'q');
        [$answersCount, $answers, $newestTime] = $answersEntity->getForQuestion(
            $question, $specificAnswer, $start, $user->config->kmess);

        // Пометка прочитанным
        if ($user->isValid() && !$specificAnswer) {
            $questionsEntity->markAsRead($id, $newestTime);
            $answersEntity->markAsRead($id);
        }

        $this->title = $question['title'];
        return $this->render('qa::show', [
            'start' => $start,
            'question' => $question,
            'specificAnswer' => $specificAnswer,
            'answersCount' => $answersCount,
            'answers' => $answers,
            'alert' => $alert,
            'can' => [
                'answer' => $answersEntity->canAnswer(),
                'comment' => $commentsEntity->canComment(),
            ]
        ]);
    }
}
