<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class EditQuestion extends Ask
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Редактирование вопроса';
    }

    public function invoke() : void
    {
        $id = intval($this->context->routeParam() ?: 0);
        if ($id <= 0) {
            $this->resultNotFound();
        }

        $questionsEntity = $this->context->questionsEntity();
        $question = $questionsEntity->getById($id);
        if (empty($question['id'])) {
            $this->resultNotFound();
        }
        $this->backUrl = "/qa/show/$id";

        if (!$questionsEntity->canEdit($question)) {
            $this->resultForbidden();
        }

        $errors = [];
        if (isset($_GET['delete_file']) && !empty($question['attachment'])) {
            if (file_exists($question['attachment']['path'])) {
                unlink($question['attachment']['path']);
            }
            $question['attachment'] = false;
            $question['attachment_name'] = '';
            $questionsEntity->update($question);
        }
        if (isset($_POST['submit'])) {
            $this->processPostData($question);
            $errors = $this->validateQuestion($question);
            if (empty($errors)) {
                $questionsEntity->update($question);
                if ($question['attachment_name'] && $this->hasFile()) {
                    $this->finishUploadFile($id);
                }
                $_SESSION['alert'] = [
                    'type' => 'alert-success',
                    'content' => 'Вопрос изменён'
                ];
                header('Location: ' . $this->backUrl);
                return;
            }
        }

        $this->render('qa::edit_question', [
            'question' => $question,
            'errors' => $errors
        ]);
    }
}
