<?php
declare(strict_types=1);

namespace Qa\Actions;

use Qa\Context;

class DeleteAnswer extends AbstractAction
{
    public function __construct(Context $context)
    {
        parent::__construct($context);
        $this->title = 'Удаление ответа';
    }

    public function invoke() : void
    {
        $id = intval($this->context->routeParam() ?: 0);
        if ($id <= 0) {
            $this->resultNotFound();
        }

        $answersEntity = $this->context->answersEntity();
        $answer = $answersEntity->getById($id);
        if (empty($answer['id'])) {
            $this->resultNotFound();
        }
        $this->backUrl = '/qa/show/' . $answer['question_id'];

        if (!$answersEntity->canDelete($answer)) {
            $this->resultForbidden();
        }

        if (isset($_GET['confirm'])) {
            // Удаляем файлы
            if (!empty($answer['attachment']) && file_exists($answer['attachment']['path'])) {
                unlink($answer['attachment']['path']);
            }
            $answersEntity->delete($answer);
            $_SESSION['alert'] = [
                'type' => 'alert-warning',
                'content' => 'Ответ удалён'
            ];
            header('Location: ' . $this->backUrl);
            return;
        }

        $this->render('qa::delete', [
            'page_title' => $this->title,
            'caption_html' => 'ответ',
            'data' => [
                'delete_url' => "/qa/delanswer/$id?confirm",
                'back_url' => $this->backUrl,
            ],
        ]);
    }
}
