<?php

declare(strict_types=1);

use Documentation\DocArticles;
use Documentation\DocSections;

$title = __('Изменить статью');

$view->addData(
    [
        'title'      => $title,
        'page_title' => $title,
    ],
    ['system::layout/default']
);

$id = $route['id'] ?? 0;

if (empty($id)) {
    pageNotFound();
}

$article = DocArticles::find($id);
if (! $article) {
    pageNotFound();
}

$data = [
    'page_title'  => $title,
    'errors'      => [],
    'messages'    => [],
    'form_action' => '/documentation/edit_article/' . $id,
    'back_url'    => $article->detail_page_url,
];

$data['sections'] = DocSections::all();

$data['fields'] = [
    'name'       => $request->getPost('name', $article->name, FILTER_SANITIZE_STRING),
    'code'       => $request->getPost('code', $article->code, FILTER_SANITIZE_STRING),
    'page_title' => $request->getPost('page_title', $article->page_title, FILTER_SANITIZE_STRING),
    'version'    => $request->getPost('version', $article->version, FILTER_SANITIZE_STRING),
    'section_id' => $request->getPost('section_id', $article->section_id, FILTER_VALIDATE_INT),
    'text'       => $request->getPost('text', $article->text),
    'updated_by' => $user->id,
];

if ($request->getMethod() === 'POST') {
    $article->update($data['fields']);
    $data['messages'][] = 'Статья успешно изменена';
}

echo $view->render('documentation::add_article', ['data' => $data]);
