<?php

declare(strict_types=1);

use Documentation\DocSections;

$view->addData(
    [
        'title'      => __('Добавить раздел'),
        'page_title' => __('Добавить раздел'),
    ],
    ['system::layout/default']
);

$data = [
    'errors'   => [],
    'messages' => [],
];

$data['fields'] = [
    'name' => $request->getPost('name', '', FILTER_SANITIZE_STRING),
    'code' => $request->getPost('code', '', FILTER_SANITIZE_STRING),
];

if ($request->getMethod() === 'POST') {
    $check = DocSections::where('code', '=', $data['fields']['code'])->first();
    if (! $check) {
        DocSections::create($data['fields']);
        $data['messages'][] = 'Раздел успешно добавлен';
        $data['fields'] = [
            'name' => '',
            'code' => '',
        ];
    } else {
        $data['errors'][] = 'Такая запись уже есть';
    }
}

echo $view->render('documentation::add_section', ['data' => $data]);
