<?php

/**
 * This file is part of JohnCMS Content Management System.
 *
 * @copyright JohnCMS Community
 * @license   https://opensource.org/licenses/GPL-3.0 GPL-3.0
 * @link      https://johncms.com JohnCMS Project
 */

declare(strict_types=1);

use Documentation\DocArticles;
use Documentation\DocSections;
use Johncms\System\Http\Request;
use Johncms\System\Legacy\Tools;
use Johncms\System\Users\User;
use Johncms\System\View\Render;
use Johncms\NavChain;

defined('_IN_JOHNCMS') || die('Error: restricted access');

/**
 * @var Render $view
 * @var NavChain $nav_chain
 * @var Tools $tools
 * @var User $user
 */

$view = di(Render::class);
$tools = di(Tools::class);
$nav_chain = di(NavChain::class);
$route = di('route');
$user = di(User::class);
/** @var Request $request */
$request = di(Request::class);

$action = $route['action'] ?? 'index';

// Register Namespace for module templates
$view->addFolder('documentation', __DIR__ . '/templates/');

$loader = new Aura\Autoload\Loader();
$loader->register();
$loader->addPrefix('Documentation', __DIR__ . '/classes');

if ($action === 'i' && $user->rights >= 9 && is_file(__DIR__ . '/install.php')) {
    require 'install.php';
    exit;
}

$data = [
    'title' => 'Документация',
];
$nav_chain->add('Документация', '/documentation/');

$pages = [
    'add_section'    => 'add_section.php',
    'edit_section'   => 'edit_section.php',
    'delete_section' => 'delete_section.php',
    'add_article'    => 'add_article.php',
    'edit_article'   => 'edit_article.php',
    'delete_article' => 'delete_article.php',
];

if (array_key_exists($action, $pages) && $user->rights >= 9) {
    require __DIR__ . '/includes/' . $pages[$action];
} elseif ($action === 'index') {
    $data['sections'] = (new DocSections())->with('articles')->get();
    $view->addData(
        [
            'title'      => $data['title'],
            'page_title' => $data['title'],
        ],
        ['system::layout/default']
    );
    echo $view->render('documentation::index', ['data' => $data]);
} else {
    // Получаем запрошенную статью
    $article = (new DocArticles)->where('code', '=', $action)->first();
    if ($article) {
        // Фиксируем количество просмотров
        if (empty($_SESSION['viewed_docs']) || ! in_array($article->id, $_SESSION['viewed_docs'])) {
            ++$article->view_count;
            $article->save();
            $_SESSION['viewed_docs'][] = $article->id;
        }

        $nav_chain->add($article->name, $article->detail_page_url);

        // Устанавливаем заголовки страницы
        $view->addData(
            [
                'title'      => $article->page_title,
                'page_title' => $article->name,
            ],
            ['system::layout/default']
        );
        $data['article'] = $article;
        echo $view->render('documentation::detail_page', ['data' => $data]);
    } else {
        pageNotFound();
    }
}
