<?php

/**
 * This file is part of JohnCMS Content Management System.
 *
 * @copyright JohnCMS Community
 * @license   https://opensource.org/licenses/GPL-3.0 GPL-3.0
 * @link      https://johncms.com JohnCMS Project
 */

declare(strict_types=1);

defined('_IN_JOHNCMS') || die('Error: restricted access');

$title = __('Sent messages');
$nav_chain->add($title);
/** @var Johncms\System\Legacy\Bbcode $bbcode */
$bbcode = di(Johncms\System\Legacy\Bbcode::class);

$total = $db->query(
    "
  SELECT COUNT(DISTINCT `cms_mail`.`from_id`)
  FROM `cms_mail`
  LEFT JOIN `cms_contact` ON `cms_mail`.`from_id`=`cms_contact`.`from_id`
  AND `cms_contact`.`user_id`='" . $user->id . "'
  WHERE `cms_mail`.`user_id`='" . $user->id . "'
  AND `cms_mail`.`delete`!='" . $user->id . "'
  AND `cms_mail`.`sys`='0'
  AND `cms_contact`.`ban`!='1'
"
)->fetchColumn();

if ($total) {
    $req = $db->query(
        "SELECT `users`.*, MAX(`cms_mail`.`time`) AS `time`
        FROM `cms_mail`
	    LEFT JOIN `users` ON `cms_mail`.`from_id`=`users`.`id`
		LEFT JOIN `cms_contact` ON `cms_mail`.`from_id`=`cms_contact`.`from_id` AND `cms_contact`.`user_id`='" . $user->id . "'
		WHERE `cms_mail`.`user_id`='" . $user->id . "'
		AND `cms_mail`.`delete`!='" . $user->id . "'
		AND `cms_mail`.`sys`='0'
		AND `cms_contact`.`ban`!='1'
		GROUP BY `cms_mail`.`from_id`
		ORDER BY MAX(`cms_mail`.`time`) DESC
		LIMIT " . $start . ',' . $user->config->kmess
    );

    for ($i = 0; $row = $req->fetch(); ++$i) {
        $count_message = $db->query(
            "SELECT COUNT(*) FROM `cms_mail`
            WHERE `user_id`='" . $user->id . "'
            AND `from_id`='{$row['id']}'
            AND `delete`!='" . $user->id . "'
            AND `sys`!='1'
        "
        )->fetchColumn();

        $last_msg = $db->query(
            "SELECT *
            FROM `cms_mail`
            WHERE `from_id`='{$row['id']}'
            AND `user_id` = '" . $user->id . "'
            AND `delete` != '" . $user->id . "'
            ORDER BY `id` DESC
            LIMIT 1"
        )->fetch();
        if (mb_strlen($last_msg['text']) > 500) {
            $text = mb_substr($last_msg['text'], 0, 500);
            $text = $tools->checkout($text, 1, 1);
            $text = $tools->smilies($text, $row['rights'] ? 1 : 0);
            $text = $bbcode->notags($text);
            $text .= '...<a href="?act=write&amp;id=' . $row['id'] . '">' . __('Continue') . ' &gt;&gt;</a>';
        } else {
            // Или, обрабатываем тэги и выводим весь текст
            $text = $tools->checkout($last_msg['text'], 1, 1);
            $text = $tools->smilies($text, $row['rights'] ? 1 : 0);
        }

        $row['count_message'] = $count_message;
        $row['display_date'] = $tools->displayDate($last_msg['time']);
        $row['preview_text'] = $text;
        $row['unread'] = ! $last_msg['read'];
        $row['user_is_online'] = time() <= $row['lastdate'] + 300;

        $row['buttons'] = [
            [
                'url'  => '?act=write&amp;id=' . $row['id'],
                'name' => __('Correspondence'),
            ],
            [
                'url'  => '?act=ignor&amp;id=' . $row['id'] . '&amp;add',
                'name' => __('Block User'),
            ],
            [
                'url'  => '?act=deluser&amp;id=' . $row['id'],
                'name' => __('Delete'),
            ],
        ];

        $items[] = $row;
    }
}

$data['back_url'] = '../profile/?act=office';
$data['total'] = $total;
$data['pagination'] = $tools->displayPagination('?act=output&amp;', $start, $total, $user->config->kmess);
$data['items'] = $items ?? [];

echo $view->render(
    'mail::conversations',
    [
        'title'      => $title,
        'page_title' => $title,
        'data'       => $data,
    ]
);
