<?php
class widgets extends core
{
    public static function modal($body, $params=array(), $footer=false)
    {
	$out  = '<div class="modal fade" id="' . $params['id'] . '" tabindex="-1" role="dialog" aria-labelledby="' . $params['id'] . 'Label" aria-hidden="true">'.
		'<div class="modal-dialog">' .
		'<div class="modal-content">' .
		'<div class="modal-header">' .
		'<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>' .
		'<h4 class="modal-title" id="' . $params['id'] . 'Label"><strong>' . (isset($params['title']) ? $params['title'] : '') . '</strong></h4>' .
		'</div>' .
		'<div class="modal-body">' . $body . '</div>';
	if($footer) {
	    $out .= '<div class="modal-footer">' .
		    '<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>' .
		    '</div>';
	}
	$out .= '</div>' .
		'</div>' .
		'</div>';
	
	return $out;
    }
    
    /**
     * Breadcrumbs
     */
    public static function breadcrumbs($labels=array())
    {
        global $set, $lng;
        
        $out = '<ol class="breadcrumb">'.
                    '<li><a href="' . self::$system_set['homeurl'] . '/">' . $lng['homepage'] . '</a></li>';
        foreach ($labels as $label)
        {
            if(isset($label['url']))
                $out .= '<li><a href="' . self::$system_set['homeurl'] . (substr($label['url'],0,1) == '/' ? '' : '/') . $label['url'] . '">' . $label['label'] . '</a></li>';
            else
                $out .= '<li class="active">' . $label['label'] . '</li>';
        }
        $out .= '</ol>';
        return $out;
    }
    
}