<?php 
add_action( 'after_setup_theme', 'tie_setupss' );
function tie_setupss() {
    register_nav_menus( array(
	    'footer-left'	=> __( 'Footer Left (M)' ),
		'footer-right'	=> __( 'Footer Right (M)' )
	) );
	
	$pagedash = get_page_by_title( 'Mobile Dashboard' );
	if($pagedash==""){
		$my_post1 = array(
		'post_title'    => 'Mobile Dashboard',
		'page_template'  => 'template-mobile-dashboard.php',
		'post_type'     => 'page',
		'post_status'   => 'publish',
		'post_author'   => 1,
		'post_category' => '',
		'comment_status' => 'closed',
		'ping_status'    => 'closed'
		);
		
		// Insert the post into the database
		$pagedash = wp_insert_post( $my_post1 );
	}
	$permalink1 = get_permalink( $pagedash);	$update_val = array( 'plink_dash' => $permalink1);
	update_option('ln_options1', $update_val);
}

function PostCount($user_id, $status){
	global $wpdb;
	$tableName =  $wpdb->prefix . 'posts';
	$query = "SELECT COUNT(*) FROM $tableName WHERE post_status = '$status' AND post_author = '$user_id' AND post_type='post'";
	$post_count = $wpdb->get_var($query);
	return $post_count;
}

function get_image_id($image_url) {
	global $wpdb;
       	$attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE guid='%s';", $image_url )); 
    return $attachment[0]; 
}


function post_exist_check($post_id){
	global $wpdb;
       	$post_id = $wpdb->get_col("SELECT `ID` FROM $wpdb->posts WHERE `ID` = '$post_id' AND `post_type` = 'post' AND `post_status` != 'trash'"); 
    return $post_id[0]; 
}

function remove_unnecessary_slug($str){	
	$str = preg_replace('/[^a-zA-Z0-9]/i',' ', $str);
	$str = trim($str);
	$str = preg_replace('/\s+/', ' ', $str);
	$str = preg_replace('/\s+/', ' ', $str);
	$str = ucfirst(strtolower($str));
	return $str;
}

function get_icon_for_attachment($post_id){
  $base = get_template_directory_uri() . "/images/media/";
  $type = get_post_mime_type($post_id);
  switch ($type) {
    case 'image/jpg':
    case 'image/jpeg':
    case 'image/png':
    case 'image/gif':
        return $base . "interactive.png"; break;
    case 'video/mpeg':
    case 'video/mp4': 
    case 'video/quicktime':
        return $base . "video.png"; break;
	case 'audio/mpeg':
    case 'audio/mp4': 
    case 'audio/quicktime':
        return $base . "audio.png"; break;
    case 'text/csv':
    case 'text/plain': 
    case 'text/xml':
        return $base . "text.png"; break; 
	case 'application/zip':
    case 'application/rar':  
        return $base . "archive.png"; break;
	case 'application/msword': 
        return $base . "document.png"; break;
    default:
        return $base . "default.png";
  }
}

function remove_footer_admin () {
	echo 'Fueled by <a href="http://www.wordpress.org" target="_blank">WordPress</a> | Designed by <a href="http://facebook.com/dearmanbinrahman" target="_blank">Arman</a></p>';
}
add_filter('admin_footer_text', 'remove_footer_admin');

if ( current_user_can('administrator') ){
	add_theme_support( 'post-formats', array(
		'aside', 
	) );
	
	function rename_formats_aside($safe_text){
	if ($safe_text == 'Aside')
		return 'Featured Post';
	return $safe_text;
	}add_filter('esc_html','rename_formats_aside');
}

add_filter( 'wp_nav_menu_items', 'wti_loginout_menu_link', 10, 2 );
function wti_loginout_menu_link( $items, $args ) {
    global $current_user; get_currentuserinfo();
    if ($args->theme_location == 'footer-right') {
      if (is_user_logged_in()) {
    $items .= '
	    	<li><a href="'. wp_logout_url() .'">Log Out ('.$current_user->user_login.')</a></li>';
      } else {
         $items .= '';
      }
   }
   return $items;
}

// disable auto add class
remove_filter( 'the_content', 'wpautop' );
remove_filter( 'the_excerpt', 'wpautop' );

function azc_bbcodccve_code($atts, $content = null){
	$orig = $content;
	$final = htmlentities($orig);
	return "<textarea rows='4' id='content' readonly='readonly' class='pre_codes' style='width:100%;height: 100px;background:#fff;'>".$final."</textarea>";
}
add_shortcode( 'code', 'azc_bbcodccve_code' );
add_shortcode( 'Code', 'azc_bbcodccve_code' );
add_shortcode( 'CODE', 'azc_bbcodccve_code' );

function azc_bbcode_bold($atts, $content = null) {
	return "<span class='azc_bbc_bold'>".do_shortcode($content)."</span>";
}
add_shortcode( 'b', 'azc_bbcode_bold' );
add_shortcode( 'B', 'azc_bbcode_bold' );

function azc_bbcode_line_break($atts, $content = null) {
	return "<br>".do_shortcode($content)."</>";
}
add_shortcode( 'br', 'azc_bbcode_line_break' );
add_shortcode( 'Br', 'azc_bbcode_line_break' );

function azc_bbcode_left($atts, $content = null) {
	return "<left>".do_shortcode($content)."</left>";
}
add_shortcode( 'left', 'azc_bbcode_left' );
add_shortcode( 'left', 'azc_bbcode_left' );

function azc_bbcode_right($atts, $content = null) {
	return "<right>".do_shortcode($content)."</right>";
}
add_shortcode( 'right', 'azc_bbcode_right' );
add_shortcode( 'Right', 'azc_bbcode_right' );

function azc_bbcode_italic($atts, $content = null) {
	return "<span class='azc_bbc_italic'>".do_shortcode($content)."</span>";
}
add_shortcode( 'i', 'azc_bbcode_italic' );
add_shortcode( 'I', 'azc_bbcode_italic' );

function azc_bbcode_sub($atts, $content = null) {
	return "<sub>".do_shortcode($content)."</sub>";
}
add_shortcode( 'sub', 'azc_bbcode_sub' );
add_shortcode( 'Sub', 'azc_bbcode_sub' );

function azc_bbcode_p($atts, $content = null) {
	return "<p class='custom_para'>".do_shortcode($content)."</p>";
}
add_shortcode( 'p', 'azc_bbcode_p' );
add_shortcode( 'P', 'azc_bbcode_p' );

function excerpt_text ($str, $length) {
    if (strlen($str) > $length) {
        $str = substr($str, 0, $length+1);
        $pos = strrpos($str, ' ');
        $str = substr($str, 0, ($pos > 0)? $pos : $length)."&#x0085;";
    }
    return $str;
}

function author_details($post_ID){
$auth = get_post($post_ID); // gets author from post
$authid = $auth->post_author; // gets author id for the post
return $authid;
}

function the_user_id( $display_name ) {
    global $wpdb;
	if ( ! $user = $wpdb->get_row( $wpdb->prepare(
        "SELECT `ID` FROM $wpdb->users WHERE `display_name` = %s", $display_name
    ) ) )
    return false;
	return $user->ID;
}

function azc_bbcode_h1($atts, $content = null) {
	return "<h1 class='custom_para_h1'>".do_shortcode($content)."</h1>";
}
add_shortcode( 'h1', 'azc_bbcode_h1' );
add_shortcode( 'H1', 'azc_bbcode_h1' );

function azc_bbcode_h2($atts, $content = null) {
	return "<h2 class='custom_para_h2'>".do_shortcode($content)."</h2>";
}
add_shortcode( 'h2', 'azc_bbcode_h2' );
add_shortcode( 'H2', 'azc_bbcode_h2' );

function azc_bbcode_h3($atts, $content = null) {
	return "<h3 class='custom_para_h3'>".do_shortcode($content)."</h3>";
}
add_shortcode( 'h3', 'azc_bbcode_h3' );
add_shortcode( 'H3', 'azc_bbcode_h3' );

function azc_bbcode_h4($atts, $content = null) {
	return "<h4 class='custom_para_h4'>".do_shortcode($content)."</h4>";
}
add_shortcode( 'h4', 'azc_bbcode_h4' );
add_shortcode( 'H4', 'azc_bbcode_h4' );

function azc_bbcode_h5($atts, $content = null) {
	return "<h5 class='custom_para_h5'>".do_shortcode($content)."</h5>";
}
add_shortcode( 'h5', 'azc_bbcode_h5' );
add_shortcode( 'H5', 'azc_bbcode_h5' );

function azc_bbcode_h6($atts, $content = null) {
	return "<h6 class='custom_para_h6'>".do_shortcode($content)."</h6>";
}
add_shortcode( 'h6', 'azc_bbcode_h6' );
add_shortcode( 'H6', 'azc_bbcode_h6' );

function azc_bbcode_underline($atts, $content = null) {
	return "<span class='azc_bbc_underline'>".do_shortcode($content)."</span>";
}
add_shortcode( 'u', 'azc_bbcode_underline' );
add_shortcode( 'U', 'azc_bbcode_underline' );

function azc_bbcode_ol($atts, $content = null) {
	return "<ol class='azc_bbc_ol'>".do_shortcode($content)."</ol>";
}
add_shortcode( 'ol', 'azc_bbcode_ol' );
add_shortcode( 'OL', 'azc_bbcode_ol' );

function azc_bbcode_select($atts, $content = null) {
	return "<select name='Options'>".do_shortcode($content)."</select>";
}
add_shortcode( 'select', 'azc_bbcode_select' );
add_shortcode( 'Select', 'azc_bbcode_select' );

function azc_bbcode_option($atts, $content = null) {
	return "<option value=''>".do_shortcode($content)."</option  >";
}
add_shortcode( 'option', 'azc_bbcode_option' );
add_shortcode( 'option', 'azc_bbcode_option' );

function azc_bbcode_ul($atts, $content = null) {
	return "<ul class='azc_bbc_ul'>".do_shortcode($content)."</ul>";
}
add_shortcode( 'ul', 'azc_bbcode_ul' );
add_shortcode( 'UL', 'azc_bbcode_ul' );

function azc_bbcode_li($atts, $content = null) {
	return "<li class='azc_bbc_li'>".do_shortcode($content)."</li>";
}
add_shortcode( 'li', 'azc_bbcode_li' );
add_shortcode( 'LI', 'azc_bbcode_li' );

function azc_bbcode_table($atts, $content = null) {
	return "<table class='azc_bbc_table'>".do_shortcode($content)."</table>";
}
add_shortcode( 'table', 'azc_bbcode_table' );
add_shortcode( 'TABLE', 'azc_bbcode_table' );

function azc_bbcode_tr($atts, $content = null) {
	return "<tr class='azc_bbc_tr'>".do_shortcode($content)."</tr>";
}
add_shortcode( 'tr', 'azc_bbcode_tr' );
add_shortcode( 'TR', 'azc_bbcode_tr' );

function azc_bbcode_th($atts, $content = null) {
	return "<th class='azc_bbc_th'>".do_shortcode($content)."</th>";
}
add_shortcode( 'th', 'azc_bbcode_th' );
add_shortcode( 'TH', 'azc_bbcode_th' );

function azc_bbcode_td($atts, $content = null) {
	return "<td class='azc_bbc_td'>".do_shortcode($content)."</td>";
}
add_shortcode( 'td', 'azc_bbcode_td' );
add_shortcode( 'TD', 'azc_bbcode_td' );

function azc_bbcode_strike($atts, $content = null) {
	return "<span class='azc_bbc_strike'>".do_shortcode($content)."</span>";
}
add_shortcode( 'strike', 'azc_bbcode_strike' );
add_shortcode( 'STRIKE', 'azc_bbcode_strike' );
add_shortcode( 's', 'azc_bbcode_strike' );
add_shortcode( 'S', 'azc_bbcode_strike' );

function azc_bbcode_start($atts, $content = null) {
	global $current_user; 
	get_currentuserinfo();
	$url = home_url();
	if( $content ){
		$texts = $content;
	}else{
		$texts = 'প্রিয় ' . $current_user->display_name.'  ভাই প্রথমে আমার সালাম নেবেন । আশা করি ভালো আছেন । কারণ <a href='.$url .'>'.get_bloginfo('name').'</a> এর সাথে থাকলে সবাই ভালো থাকে । আর আপনাদের দোয়ায় আমি ও ভালো আছি । তাই আজ নিয়ে এলাম আপনাদের জন্য আরেক টা নতুন টিপস । আর কথা বাড়াবো না কাজের কথায় আসি ।';
	}
	return "<p>".do_shortcode($texts)."</p>";
}
add_shortcode( 'start', 'azc_bbcode_start' );
add_shortcode( 'Start', 'azc_bbcode_start' );
add_shortcode( 'START', 'azc_bbcode_start' );

function azc_bbcode_end($atts, $content = null) {
	global $current_user; 
	get_currentuserinfo();
	$url = home_url();
	if( $content ){
		$texts = $content;
	}else{
		$texts = 'তাহলে  ' . $current_user->display_name.'  ভাই ভালো থাকুন সুস্থ থাকুন  <a href='.$url .'>'.get_bloginfo('name').'</a> এর সাথে থাকুন । আর এই সাইট যদি ভালো লাগে আপনার বন্ধুদের জানাবেন । ধন্যবাদ ।';
	}
	return "<p>".do_shortcode($texts)."</p>";
}
add_shortcode( 'end', 'azc_bbcode_end' );
add_shortcode( 'End', 'azc_bbcode_end' );
add_shortcode( 'END', 'azc_bbcode_end' );


function rainbow($text){
    $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8');
    $return = '';

    $colors = new InfiniteIterator(
        new ArrayIterator(
		['5C1FFD', '6619FB', '7113F8', '8709F0', '9106EA', 'A601DD', 'B001D6', 'BA01CD', 'CC04BB', 'D506B2', 'DC0AA8', 'E30F9D', 'EF1A88', 'F4217D', 'F82872', 'FD395D', 'FE4353', 'FE4C49', 'FC6136', 'FA6B2E', 'F77626', 'F2811F', 'E89612', 'E1A10D', 'DAAB09', 'D2B505', 'CABE03', 'C1C801', 'B7D001', 'ADD801', '99E604', '8EEC07', '78F60F', '6EF915', '63FC1B', '59FE22', '45FE32', '3BFD3A', '2AF94D', '23F557', '1CF062', '10E577', '0BDE82', '07D78D', '02C6A2', '01BCAC', '01A9BF', '039EC9', '0594D1', '0889D9', '0D7EE0', '1769ED', '1E5EF2', '2554F6', '2D4AFA', '3541FC', '3E37FE', '482FFE', '5227FE']
        )
    );
    $colors->rewind();

    // Match any codepoint along with any combining marks.
    preg_match_all('/.\pM*+/su', $text, $matches);
    foreach ( $matches[0] as $char){
        if (preg_match('/^\pZ$/u', $char)) {
            // No need to color whitespace or invisible separators.
            $return .= $char;
        }else{
			$return .= "<font color='#".$colors->current()."'>".$char."</font>";
			$colors->next();
        }
    }
    $texts = '<p class="rainbow">'.$return.'</p>';
    return $texts;
}

function azc_bbcode_rainbow($atts, $content = null) {
	$text = rainbow($content);
	return do_shortcode($text);
}
add_shortcode( 'rainbow', 'azc_bbcode_rainbow' );
add_shortcode( 'Rainbow', 'azc_bbcode_rainbow' );
add_shortcode( 'RAINBOW', 'azc_bbcode_rainbow' );

function azc_bbcode_url($atts, $content = null) {
	if (empty($atts)){
		$return = "<a class='azc_bbc_url' href='$content'>".$content."</a>";
	}else{
		$attribs = implode('',$atts);
		$url = substr ( $attribs, 1);
		$url = str_replace("'", '', str_replace('"', '', $url));
		
		$return = "<a href='$url' class='azc_bbc_url'>".$content."</a>";
	}
	return $return;
}
add_shortcode( 'url', 'azc_bbcode_url' );
add_shortcode( 'URL', 'azc_bbcode_url' );
add_shortcode( 'link', 'azc_bbcode_url' );
add_shortcode( 'LINK', 'azc_bbcode_url' );
add_shortcode( 'a', 'azc_bbcode_url' );


function azc_bbcode_video($atts, $content = null) {
	if (empty($atts)){
		$return = "<a class='azc_bbc_url' href='$content'>".$content."</a>";
	}else{
		$attribs = implode('',$atts);
		$url = substr ( $attribs, 1);
		$url = str_replace("'", '', str_replace('"', '', $url));
		preg_match("/^(?:http(?:s)?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com\/(?:(?:watch)?\?(?:.*&)?v(?:i)?=|(?:embed|v|vi|user)\/))([^\?&\"'>]+)/", $url, $matches);
		$id = $matches[1]; 
		
		$return = '<iframe width="100%" height="300px" src="https://www.youtube.com/embed/'.$id.'"></iframe>';
	}
	return $return;
}
add_shortcode( 'youtube', 'azc_bbcode_video' );
add_shortcode( 'Youtube', 'azc_bbcode_video' );
add_shortcode( 'YOUTUBE', 'azc_bbcode_video' );


function azc_bbcode_color($atts, $content = null) {
	if (empty($atts)){
		$color = 'black';
	}else{
		$attribs = implode('',$atts);
		$color = str_replace("'", '', str_replace('"', '', substr ( $attribs, 1)));
		if(ctype_xdigit($color)) {
			$color = '#'.$color;
		}
	}
	return "<span style='color: $color; '>".do_shortcode($content)."</span>";
}
add_shortcode( 'color', 'azc_bbcode_color' );
add_shortcode( 'COLOR', 'azc_bbcode_color' );
add_shortcode( 'colour', 'azc_bbcode_color' );
add_shortcode( 'COLOUR', 'azc_bbcode_color' );

function azc_bbcode_bg_color($atts, $content = null) {
	if (empty($atts)){
		$bg = 'black';
	}else{
		$attribs = implode('',$atts);
		$bg = str_replace("'", '', str_replace('"', '', substr ( $attribs, 1)));
		if(ctype_xdigit($bg)) {
			$bg = '#'.$bg;
		}
	}
	return "<span style='padding:0px 4px;background-color:$bg; '>".do_shortcode($content)."</span>";
}
add_shortcode( 'bg', 'azc_bbcode_bg_color' );
add_shortcode( 'Bg', 'azc_bbcode_bg_color' );
add_shortcode( 'BG', 'azc_bbcode_bg_color' );
add_shortcode( 'bG', 'azc_bbcode_bg_color' );


function tie_login_logo(){
	$download = get_template_directory_uri()."img/logo.png";
    echo '<style  type="text/css"> .login h1 a {  background-image:url('.get_template_directory_uri()."/img/piyar.png".')  !important; background-size: 274px 63px; width: 326px; height: 67px; } </style>';  
}  
add_action('login_head',  'tie_login_logo'); 


/* Remove category */
if ( current_user_can('administrator')) {
	
}else{
	function category_reomve(){
	echo ('<style>#taxonomy-category li#category-2{display:none;}</style>');
}
add_action( 'admin_enqueue_scripts', 'category_reomve' );
}
require_once ( get_template_directory() . '/info/loader.php'    );
class PostThumbnailExtras {
	public function __construct(){
		$this->load_requires();
	}

	private $requires = array( 'ntc/php/shortcode.php', 'ntc/php/options.php' );

	private function load_requires(){
		$path =  get_template_directory() . '/'; 
		foreach ( $this->requires as $require ){
			require( $path . $require );
		}
	}
}
$ptx = new PostThumbnailExtras();

/* Remove Admin Bar */
add_filter('show_admin_bar', '__return_false');

/* Thumbnail Support */
add_theme_support( 'post-thumbnails', array( 'post' ) ); 
set_post_thumbnail_size( 310, 210, true );
add_image_size( 'featured', 60, 60, true );
add_image_size( 'tie_thumb'		,110,  100, true );
add_image_size( 'figcaption'    ,310,  165, true );

/* Registered Sidebar */
register_sidebar(array(
    'name' => 'Index Sidebar',
	'id' => 'index_sidebar',
	'description' => 'The index widget area',
	'before_widget' => '<div class="block_posts">',
	'after_widget' => '</ul></div>',
	'before_title' => '<h2>',
	'after_title' => '</h2><ul class="rpul">' )); 


/* View Count */
function getPostViews( $postID ){
	$count_key = 'post_views_count' ;
	$count = get_post_meta ( $postID , $count_key , true );
	if ($count ==''){
		delete_post_meta ( $postID , $count_key );
		add_post_meta ($postID , $count_key, '0' );
		return "0 View" ;
	}
	return $count .' Views' ;
}

function setPostViews ( $postID ) {
	$count_key = 'post_views_count' ;
	$count = get_post_meta ( $postID , $count_key , true );
if ($count ==''){
	$count = 0 ;
	delete_post_meta ( $postID , $count_key );
	add_post_meta ($postID , $count_key, '0' );
} else{
	$count ++;
	update_post_meta ($postID , $count_key , $count );
} } 

/* Round */
function round_num($num, $to_nearest) {
   return floor($num/$to_nearest)*$to_nearest;
}

/* Pagination */ 
function pagenavi($before = '', $after = '') {  
    global $wpdb, $wp_query;
    $pagenavi_options = array();
    $pagenavi_options['pages_text'] = ('Page %CURRENT_PAGE% of %TOTAL_PAGES%');
    $pagenavi_options['current_text'] = '%PAGE_NUMBER%';
    $pagenavi_options['page_text'] = '%PAGE_NUMBER%';
    $pagenavi_options['first_text'] = ('First');
    $pagenavi_options['last_text'] = ('Last');
    $pagenavi_options['next_text'] = '&raquo;';
    $pagenavi_options['prev_text'] = '&laquo;';
    $pagenavi_options['dotright_text'] = '...';
    $pagenavi_options['dotleft_text'] = '...';
    $pagenavi_options['num_pages'] = 5; 
    $pagenavi_options['always_show'] = 0;
    $pagenavi_options['num_larger_page_numbers'] = 0;
    $pagenavi_options['larger_page_numbers_multiple'] = 5;    
    
	if (!is_single()) {
        $request = $wp_query->request;
        $posts_per_page = intval(get_query_var('posts_per_page'));
		$paged = intval(get_query_var('paged'));
        $numposts = $wp_query->found_posts;
        $max_page = $wp_query->max_num_pages;
       
	    if(empty($paged) || $paged == 0) {
            $paged = 1;
        }
        $pages_to_show = intval($pagenavi_options['num_pages']);
        $larger_page_to_show = intval($pagenavi_options['num_larger_page_numbers']);
        $larger_page_multiple = intval($pagenavi_options['larger_page_numbers_multiple']);
        $pages_to_show_minus_1 = $pages_to_show - 1;
        $half_page_start = floor($pages_to_show_minus_1/2);
		$half_page_end = ceil($pages_to_show_minus_1/2);
        $start_page = $paged - $half_page_start;
        if($start_page <= 0) {
            $start_page = 1;
        }
        $end_page = $paged + $half_page_end;
        if(($end_page - $start_page) != $pages_to_show_minus_1) {
            $end_page = $start_page + $pages_to_show_minus_1;
        }
        if($end_page > $max_page) {
            $start_page = $max_page - $pages_to_show_minus_1;
            $end_page = $max_page;
        }
        if($start_page <= 0) {
            $start_page = 1;
        }
        $larger_per_page = $larger_page_to_show*$larger_page_multiple;
        $larger_start_page_start = (round_num($start_page, 10) + $larger_page_multiple) - $larger_per_page;
        $larger_start_page_end = round_num($start_page, 10) + $larger_page_multiple;
        $larger_end_page_start = round_num($end_page, 10) + $larger_page_multiple;
        $larger_end_page_end = round_num($end_page, 10) + ($larger_per_page);
        if($larger_start_page_end - $larger_page_multiple == $start_page) {
            $larger_start_page_start = $larger_start_page_start - $larger_page_multiple;
            $larger_start_page_end = $larger_start_page_end - $larger_page_multiple;
        }   
        if($larger_start_page_start <= 0) {
            $larger_start_page_start = $larger_page_multiple;
        }
        if($larger_start_page_end > $max_page) {
            $larger_start_page_end = $max_page;
        }
        if($larger_end_page_end > $max_page) {
            $larger_end_page_end = $max_page;
        }
        if($max_page > 1 || intval($pagenavi_options['always_show']) == 1) {
            $pages_text = str_replace("%CURRENT_PAGE%", number_format_i18n($paged), $pagenavi_options['pages_text']);
            $pages_text = str_replace("%TOTAL_PAGES%", number_format_i18n($max_page), $pages_text);
            echo $before.'<div id="pagination-links">'."\n";
            if(!empty($pages_text)) {
                echo '<span class="pages">'.$pages_text.'</span>';
            }
			previous_posts_link($pagenavi_options['prev_text']);
             
            if ($start_page >= 2 && $pages_to_show < $max_page) {
                $first_page_text = str_replace("%TOTAL_PAGES%", number_format_i18n($max_page), $pagenavi_options['first_text']);
                echo '<a href="'.esc_url(get_pagenum_link()).'" class="first" title="'.$first_page_text.'">1</a>';
                if(!empty($pagenavi_options['dotleft_text'])) {
                    echo '<span class="expand">'.$pagenavi_options['dotleft_text'].'</span>';
                }
            }
            if($larger_page_to_show > 0 && $larger_start_page_start > 0 && $larger_start_page_end <= $max_page) {
                for($i = $larger_start_page_start; $i < $larger_start_page_end; $i+=$larger_page_multiple) {
                    $page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
                    echo '<a href="'.esc_url(get_pagenum_link($i)).'" class="single_page" title="'.$page_text.'">'.$page_text.'</a>';
                }
            }
            for($i = $start_page; $i  <= $end_page; $i++) {                      
                if($i == $paged) {
                    $current_page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['current_text']);
                    echo '<span class="current">'.$current_page_text.'</span>';
                } else {
                    $page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
                    echo '<a href="'.esc_url(get_pagenum_link($i)).'" class="single_page" title="'.$page_text.'">'.$page_text.'</a>';
                }
            }
            if ($end_page < $max_page) {
                if(!empty($pagenavi_options['dotright_text'])) {
                    echo '<span class="expand">'.$pagenavi_options['dotright_text'].'</span>';
                }
                $last_page_text = str_replace("%TOTAL_PAGES%", number_format_i18n($max_page), $pagenavi_options['last_text']);
                echo '<a href="'.esc_url(get_pagenum_link($max_page)).'" class="last" title="'.$last_page_text.'">'.$max_page.'</a>';
            }
            next_posts_link($pagenavi_options['next_text'], $max_page);
            if($larger_page_to_show > 0 && $larger_end_page_start < $max_page) {
                for($i = $larger_end_page_start; $i <= $larger_end_page_end; $i+=$larger_page_multiple) {
                    $page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
                    echo '<a href="'.esc_url(get_pagenum_link($i)).'" class="single_page" title="'.$page_text.'">'.$page_text.'</a>';
                }
            }
            echo '</div>'.$after."\n";
        }
    }
}

/* Roles */
function user_role($author_id) { 
   $u=new WP_User($author_id);
   return array_shift($u->roles);
}

/* Profile Photo */ 
add_action( 'wp_enqueue_scripts', 'cupp_enqueue_scripts_styles' );
add_action( 'admin_enqueue_scripts', 'cupp_enqueue_scripts_styles' );
function cupp_enqueue_scripts_styles() {
    // Register
    wp_register_script( 'notificatiosn',     	get_template_directory_uri() . '/js/live_notification.js', array( 'jquery' ),	false, true );  
	
    // Enqueue
	wp_enqueue_script( 'notificatiosn' );
}




   // disable registration page and login page



add_action('init','custom_login'); function custom_login(){ global $pagenow; if( 'wp-login.php' == $pagenow && !is_user_logged_in()) { wp_redirect('/login'); exit(); } }

// disable wordpress dashboard
add_action( 'admin_init','wpse_253580_prevent_author_access');
function wpse_253580_prevent_author_access(){  if( current_user_can( 'author' ) && is_admin() )  { wp_redirect('/'); exit(); } }

// creating pages

if (isset($_GET['activated']) && is_admin()){
    add_action('init', 'create_initial_pages');
}

function create_initial_pages() {
    $pages = array(
        'About' => 'About Us',
        'Faq' => 'Faq',
        'Privacy' => 'Privacy',
        'Contact' => 'Contact',
        'Advertise' => 'Advertise Us',
        'Terms' => 'Terms',
        'Rights' => 'Rights',
        'Copyright' => 'Copyrights'
        
    );
    foreach($pages as $key => $value) {
        $id = get_page_by_title($value);
        $page = array(
            'post_type'   => 'page',
            'post_title'  => $value,
            'post_name'   => $key,
            'post_status' => 'publish',
            'post_author' => 1,
            'post_parent' => ''
        );
        if (!isset($id)) wp_insert_post($page);
    };
}

