<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

namespace Johncms\Forum;

class Voter
{
    private $post;

    private $user;

    private $plus = 0;

    private $minus = 0;

    private $hide = false;

    private $hideLimit = 10;

    private $reset;

    private $exists = false;

    private $table = 'cms_forum_like';

    public function __construct($post = 0, $reset = false)
    {
        $this->post = $post;
        $this->reset = $reset;
        //$this->user = \App::getContainer()->get(\Johncms\Api\UserInterface::class)->id;
        $this->db = \App::getContainer()->get(\PDO::class);
        $this->select();
    }

    public static function getUser()
    {
        return \App::getContainer()->get(\Johncms\Api\UserInterface::class)->id;
    }

    public function add($int)
    {
        if (!self::getUser()) {
            return false;
        }
        $type = $int ? 'plus' : 'minus';
        if (!$this->exists()) {
            $result = $this->db
                ->prepare("INSERT INTO `" . $this->table . "` (`post_id`, `user_id`, `type`) VALUES (?, ?, ?)")
                ->execute([$this->post, self::getUser(), $type]);
            return true;
        }
        return false;
    }

    public function delete()
    {
        $result = false;
        if ($this->exists()) {
            $result = $this->db
                ->exec("DELETE FROM `" . $this->table . "` WHERE `post_id` = " . $this->post . " AND `user_id` = " . self::getUser());
        }
        return $result;
    }

    private function select()
    {
        $exists = $this->db
            ->query("SELECT COUNT(*) FROM `" . $this->table . "` WHERE `post_id` = " . $this->post)->fetchColumn();
        if ($exists) {
            $result = $this->db
                ->query("SELECT * FROM `" . $this->table . "` WHERE `post_id` = " . $this->post)
                ->fetchAll();
            foreach ($result as $value) {
                if ($value['user_id'] == self::getUser()) {
                    $this->exists = true;
                }
                if ($value['type'] == 'plus') {
                    $this->plus++;
                } else {
                    $this->minus++;
                }
            }
            $this->hide = ($this->plus + $this->hideLimit - $this->minus > 0);
        }
    }

    private function exists()
    {
        return $this->exists;
    }

    public function view($id)
    {
        if (!$this->exists() && self::getUser()) {
            return '
            <div id="vote_' . $id . '" data-artid="' . $id . '" class="green">
                    ' . $this->plus . ' <a id="plus_' . $id . '" href="ajaxlike.php?post=' . $id . '&amp;type=1" onclick="like(' . $id . ', 1); return false;">&#8657;</a>
                    ' . $this->minus . ' <a id="minus_' . $id . '" href="ajaxlike.php?post=' . $id . '&amp;type=0" onclick="like(' . $id . ', 0); return false;">&#8659;</a>
            </div>';
        } else {
            return '
            <div class="gray">
                    ' . $this->plus . ' &#8657;
                    ' . $this->minus . ' &#8659;
            </div>';
        }
    }
    public function newVote($id)
    {
        $cnt = $this->db->query('select * from (
                                select count(*) plus from `' . $this->table . '` where `post_id`="' . $id . '" AND `type`="plus")q1, (
                                select count(*) minus from `' . $this->table . '` where `post_id`="' . $id . '" AND `type`="minus")q2')->fetch();
        if ($cnt) {
            return '
            <div class="gray">
                    ' . $cnt['plus'] . ' &#8657;
                    ' . $cnt['minus'] . ' &#8659;
            </div>';
        }
    }
}
