<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

define('_IN_JOHNCMS', 1);

require('system/bootstrap.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

$textl = _t('Page not found');
$headmod = 'error';
require('system/head.php');

echo '<div class="mainblok"><div class="phdr">Page Not Found</div>';
echo '<div class="rmenu">Sorry, the page you requested was not found, You may have clicked an expired link or mistyped the address, or this page has been deleted or moved and or you do not have permission to access this page <br>- Some web addresses are case sensitive.<br /><br />&lt; <a href="/">Return home</a><br/>&lt; <a href="javascript:history.go(-1)">Go back to the previous page</a></div></div>';
require('system/end.php');
?>