<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

/*
-----------------------------------------------------------------
Masterscliq Main left menu
-----------------------------------------------------------------
*/
if (!$systemUser->id && $headmod != "login" && $headmod != "password" && $headmod != "registration") {
echo '<div class="mainblok"><div class="phdr"><img src="../images/file.png" align="left" alt="file"/>&#160;&#160;<b>' . _t('Login Here') . '</b></div>';

    $error = [];
    $captcha = false;
    $display_form = 1;
    $user_login = isset($_POST['n']) ? $_POST['n'] : null;
    $user_pass = isset($_POST['p']) ? $_POST['p'] : null;
    $user_mem = isset($_POST['mem']) ? 1 : 0;
    $user_code = isset($_POST['code']) ? trim($_POST['code']) : null;

    if ($user_pass && !$user_login) {
        $error[] = _t('You have not entered login', 'system');
    }

    if ($user_login && !$user_pass) {
        $error[] = _t('You have not entered password', 'system');
    }

    if ($user_login && (mb_strlen($user_login) < 2 || mb_strlen($user_login) > 20)) {
        $error[] = _t('Nickname', 'system') . ': ' . _t('Invalid length', 'system');
    }

    if ($user_pass && (mb_strlen($user_pass) < 1)) {
        $error[] = _t('Password', 'system') . ': ' . _t('Invalid length', 'system');
    }

    if (!$error && $user_pass && $user_login) {
        // Запрос в базу на юзера
        $stmt = $db->prepare('SELECT * FROM `users` WHERE `name_lat` = ? LIMIT 1');
        $stmt->execute([$tools->rusLat($user_login)]);

        if ($stmt->rowCount()) {
            $systemUser = $stmt->fetch();

            if ($systemUser['failed_login'] > 2) {
                if ($user_code) {
                    if (mb_strlen($user_code) > 3 && $user_code == $_SESSION['code']) {
                        // Если введен правильный проверочный код
                        unset($_SESSION['code']);
                        $captcha = true;
                    } else {
                        // Если проверочный код указан неверно
                        unset($_SESSION['code']);
                        $error[] = _t('The security code is not correct', 'system');
                    }
                } else {
                    // Показываем CAPTCHA
                    $display_form = 0;
                    echo '<form action="' . ($id ? '?id=' . $id : '') . '" method="post">' .
                        '<div class="menu"><p><img src="captcha.php?r=' . rand(1000, 9999) . '" alt="' . _t('Verification code', 'system') . '"/><br />' .
                        _t('Enter verification code', 'system') . ':<br><input type="text" size="5" maxlength="5"  name="code"/>' .
                        '<input type="hidden" name="n" value="' . htmlspecialchars($user_login) . '"/>' .
                        '<input type="hidden" name="p" value="' . $user_pass . '"/>' .
                        '<input type="hidden" name="mem" value="' . $user_mem . '"/>' .
                        '<input type="submit" name="submit" value="' . _t('Continue', 'system') . '"/></p></div></form>';
                }
            }

            if ($systemUser['failed_login'] < 3 || $captcha) {
                if (md5(md5($user_pass)) == $systemUser['password']) {
                    // Если логин удачный
                    $display_form = 0;
                    $db->exec("UPDATE `users` SET `failed_login` = '0' WHERE `id` = " . $systemUser['id']);

                    if (!$systemUser['preg']) {
                        // Если регистрация не подтверждена
                        echo '<div class="rmenu"><p>' . _t('Sorry, but your request for registration is not considered yet. Please, be patient.', 'system') . '</p></div>';
                    } else {
                        // Если все проверки прошли удачно, подготавливаем вход на сайт
                        if (isset($_POST['mem'])) {
                            // Установка данных COOKIE
                            $cuid = base64_encode($systemUser['id']);
                            $cups = md5($user_pass);
                            setcookie("cuid", $cuid, time() + 3600 * 24 * 365);
                            setcookie("cups", $cups, time() + 3600 * 24 * 365);
                        }

                        // Установка данных сессии
                        $_SESSION['uid'] = $systemUser['id'];
                        $_SESSION['ups'] = md5(md5($user_pass));

                        $db->exec("UPDATE `users` SET `sestime` = '" . time() . "' WHERE `id` = " . $systemUser['id']);
                        $set_user = unserialize($systemUser['set_user']);

                        if ($systemUser['lastdate'] < (time() - 3600) && $set_user['digest']) {
                            header('Location: ' . $config->homeurl . '/index.php?act=digest&last=' . $systemUser['lastdate']);
                        } else {
                            header('Location: ' . $config->homeurl . '/index.php?act=digest&last=' . $systemUser['lastdate']);
                        }

                        echo '<div class="gmenu"><p><b><a href="index.php?act=digest">' . _t('Enter site', 'system') . '</a></b></p></div>';
                    }
                } else {
                    // Если логин неудачный
                    if ($systemUser['failed_login'] < 3) {
                        // Прибавляем к счетчику неудачных логинов
                        $db->exec("UPDATE `users` SET `failed_login` = '" . ($systemUser['failed_login'] + 1) . "' WHERE `id` = " . $systemUser['id']);
                    }

                    $error[] = _t('Authorization failed', 'system');
                }
            }
        } else {
            $error[] = _t('Authorization failed', 'system');
        }
    }

    if ($display_form) {
        if ($error) {
            echo $tools->displayError($error);
        }
echo '<div class="gmenu"><form action="'.$_SERVER['PHP_SELF'].'" method="post"><p>' . _t('Login name') . ':<br/>' .
'<input type="text" name="n" value="' . htmlentities($user_login, ENT_QUOTES, 'UTF-8') . '" maxlength="25"/>' .
'<br/>' . _t('Password') . ':<br/>' .
'<input type="password" name="p" maxlength="30"/></p>' .
'<p><input type="checkbox" name="mem" value="1" checked="checked"/>&#160;' . _t('Remember me') . '</p>' .
'<p><input type="submit" name="login" value="' . _t('Login') . '"/></p>' .
'</form></div>' .
'<div class="phdr"><a href="../users/skl.php?continue">' . _t('Forgotten password?') . '</a></div><div class="phdr"><a href="/help/index.php?act=forum">Rules</a> &bull; <a href="' . $config['homeurl'] . '/registration/index.php">Register</a></div>';
echo '</div>';

}
}
/*
-----------------------------------------------------------------
Masterscliq Welcome guest
-----------------------------------------------------------------
*/
if (!$systemUser->isValid() && $headmod != "login" && $headmod != "password" && $headmod != "registration") {
echo '<div class="orange"><b>Welcome to&nbsp;' . $config['copyright'] . '</b><div style="text-align:left">If this is your first visit, be sure to check out the <font color="red">Rules</font> by clicking the link above..<br>You may have to register before you can post.. click the <font color="red">Register</font> link above to proceed..</div></div>';
}
/*
-----------------------------------------------------------------
Masterscliq Navigation
-----------------------------------------------------------------
*/
if ($headmod != "mainpage" || ($headmod == 'mainpage' && $act))
if ($systemUser->getConfig()->quickGo) {
echo '<div class="mainblok"><div class="phdr"><img src="/images/home.png" width="14" height="14" class="left"/>&nbsp;<a href="' . $config['homeurl'] . '">' . _t('Homepage') . '</a><br/>';
echo '<form action="' . $config['homeurl'] . '/go.php" method="post">';
echo '<select name="adres" style="font-size:x-small">
<option selected="selected">' . _t('Quick Navigation') . '</option>
<option value="guest">' . _t('Guestbook') . '</option>
<option value="forum">' . _t('Forum') . '</option>
<option value="news">' . _t('News Archive') . '</option>
<option value="profile">' . _t('Profile') . '</option>
<option value="down">' . _t('Downloads') . '</option>
<option value="johncms">' . _t('Johncms') . '</option>
<option value="foxwap">Foxwap Social Community</option>
</select><input type="submit" value="Go" style="font-size:x-small"/>';
echo '</form></div></div>';
}
/*
-----------------------------------------------------------------
Masterscliq Forum Structure
-----------------------------------------------------------------
*/
if ($headmod != "online" && $headmod != "digest" &&
$headmod != "birth" &&
$headmod != "admlist" && $headmod != "guest" &&
$headmod != "load" &&
$headmod != "admin" &&
$headmod != "leave" &&
$headmod != "library" &&
$headmod != "gallery" &&
$headmod != "users" &&
$headmod != "friend" &&
$headmod != "reg_letter" && $headmod != "guestbook" && $headmod != "news" && $headmod != "userban" && $headmod != "userstop" && $headmod != "userlist" && $headmod != "blogs" &&
$headmod != "cpanel" &&
$headmod != "profile" &&
$headmod != "mail" &&
$headmod = "forum" &&
$headmod != "shoutbox" && $config['mod_cats'] != 0) {
if (!$systemUser->isValid()) {
echo '<div class="orange"><div style="text-align:left">To start viewing some threads, select the category that you want to visit from the forum structure below..</div></div>';
}
$dreq = $db->query("SELECT * FROM `forum` WHERE `type` = 'f' ORDER BY `realid` ASC");
$i = 0;
while ($fr1 = $dreq->fetch()) {
echo '<div class="mainblok"><div class="phdr"><img src="/images/subfldr.png" width="16" height="16" class="left"/>&nbsp;<b>' . $fr1['text'] . '</b></div>';
$pr = $db->query("SELECT `id`, `text`, `soft` FROM `forum` WHERE `type` = 'r' AND `refid` = '" . $fr1['id'] . "'");
$i = 0;
while ($pr1 = $pr->fetch()) {
$coltem = $db->query("SELECT COUNT(*) FROM `forum` WHERE `type` = 't' AND `refid` = '" . $pr1['id'] . "'")->fetchColumn();
echo '<div class="menu"><img src="/images/forum_cat.png" width="14" height="14" class="left"/>&nbsp;<a href="'.$config->homeurl.'/forum/' . $tools->rewriteUrl($res['text']) . '_'.$pr1['id'].'.html">' . $bbcode->threads($pr1['text']) . '</a>';
if ($coltem)
echo '&#160;[<span class="red">'.$coltem.'</span>]';
if (!empty($pr1['soft']))
echo '<div class="sub"><span class="gray">' . $pr1['soft'] . '</span></div>';
echo '</div>';
}
echo '</div>';
++$i;
}
}
/*
-----------------------------------------------------------------
Masterscliq Top user
-----------------------------------------------------------------
*/
if ($headmod != "mainpage" && $headmod = "forum") {
function getTop($order = 'postforum') {
$req = $db->query("SELECT * FROM `users` WHERE `$order` > 0 ORDER BY `$order` DESC LIMIT 6");
if ($req->rowCount()) {
$out = '';
$i = 0;
while ($res = $req->fetch()) {
$out .= $i % 2 ? '<div class="list2">' : '<div class="list1">';
$out .= $tools->displayUser($res, array ('header' => ('<b>' . $res[$order]) . '</b>')) . '</div>';
++$i;
}
return $out;
} else {
return '<div class="menu"><p>' . _t('List is empty') . '</p></div>';
}
}
$menu = array (
(!$mod ? '<b>' . _t('Forum') . '</b>' : '<a href="index.php?act=top">' . _t('Forum') . '</a>'),
($mod == 'guest' ? '<b>' . _t('Guestbook') . '</b>' : '<a href="index.php?act=top&amp;mod=guest">' . _t('Guestbook') . '</a>'),
($mod == 'comm' ? '<b>' . _t('Comments') . '</b>' : '<a href="index.php?act=top&amp;mod=comm">' . _t('Comments') . '</a>'),
($mod == 'balans' ? '<b>' . _t('Top Balance') . '</b>' : '<a href="index.php?act=top&amp;mod=balans">' . _t('Top Balance') . '</a>')
);
if ($set_karma['on'])
$menu[] = $mod == 'karma' ? '<b>' . _t('Karma') . '</b>' : '<a href="index.php?act=top&amp;mod=karma">' . _t('Karma') . '</a>';
switch ($mod) {

/* 
----------------------------------------------------------------- 
Hacklord Top User Guesbook Posts 
----------------------------------------------------------------- 
*/ 
case 'guest':
echo '<div class="mainblok"><div class="phdr"><img src="/images/subfldr.png" width="16" height="16" class="left"/>&nbsp;<b>Top users activity</b></div>';
echo '<div class="topmenu">' . $tools->displayMenu($menu) . '</div>';
echo getTop('postguest');
break;

/* 
----------------------------------------------------------------- 
Hacklord Top Community User
----------------------------------------------------------------- 
*/ 
case 'comm':
echo '<div class="mainblok"><div class="phdr"><img src="/images/subfldr.png" width="16" height="16" class="left"/>&nbsp;<b>Top users activity</b></div>';
echo '<div class="topmenu">' . $tools->displayMenu($menu) . '</div>';
echo getTop('komm');
break; 

/* 
----------------------------------------------------------------- 
Hacklord Top Balance 
----------------------------------------------------------------- 
*/ 
case 'balans': 
echo '<div class="mainblok"><div class="phdr"><a href="index.php"><b>' . $lng('Community') . '</b></a> | ' . _t('Balance') . '</div>'; 
echo '<div class="topmenu">' . $tools->displayMenu($menu) . '</div>'; 
echo getTop('balans'); 
echo '<div class="phdr"><a href="../index.php">' . _t('Homepage') . '</a></div>'; 
break;

/* 
----------------------------------------------------------------- 
Hacklord Top Karma Points 
----------------------------------------------------------------- 
*/
case 'karma':
if ($set_karma['on']) {
echo '<div class="mainblok"><div class="phdr"><img src="/images/subfldr.png" width="16" height="16" class="left"/>&nbsp;<b>Top users activity</b></div>';
echo '<div class="topmenu">' . $tools->displayMenu($menu) . '</div>';
$req = $db->query("SELECT *, (`karma_plus` - `karma_minus`) AS `karma` FROM `users` WHERE (`karma_plus` - `karma_minus`) > 0 ORDER BY `karma` DESC LIMIT 6");
if ($req->rowCount()) {
$i = 0;
while ($res = $req->fetch()) {
echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
echo $tools->displayUser($res, array ('header' => ('<b>' . $res['karma']) . '</b>')) . '</div>';
++$i;
}
} else {
echo '<div class="menu"><p>' . _t('List is empty') . '</p></div>';
}
}
break; 

/* 
----------------------------------------------------------------- 
HACKLORD DEFAULT DISPLAY
----------------------------------------------------------------- 
*/
default:
echo '<div class="mainblok"><div class="phdr"><img src="/images/subfldr.png" width="16" height="16" class="left"/>&nbsp;<b>Top users activity</b></div>';
echo '<div class="topmenu">' . $tools->displayMenu($menu) . '</div>';
echo getTop('postforum');
}
echo '</div>';
}
?>