-- --------------------------------------------------------
-- 
-- Table structure for table `apply_staff`
-- 

CREATE TABLE `apply_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `opis` text NOT NULL,
  `iduser` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  `type` int(2) NOT NULL,
  `vr` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `blogs`
-- 

CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `text` text NOT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `refid` (`refid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `blogs_cat`
-- 

CREATE TABLE `blogs_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `realid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `realid` (`realid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `blogs_comments`
-- 

CREATE TABLE `blogs_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(10) unsigned NOT NULL,
  `time` int(11) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `time` (`time`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `blogs_rating`
-- 

CREATE TABLE `blogs_rating` (
  `id_rate` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `news` int(11) NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `rateact` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id_rate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `bot`
-- 

CREATE TABLE `bot` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(50) NOT NULL,
  `key` varchar(100) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `txt1` varchar(500) NOT NULL,
  `txt2` varchar(500) NOT NULL,
  `txt3` varchar(500) NOT NULL,
  `txt4` varchar(500) NOT NULL,
  `txt5` varchar(500) NOT NULL,
  `time` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_ads`
-- 

CREATE TABLE `cms_ads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(2) NOT NULL,
  `view` int(2) NOT NULL,
  `layout` int(2) NOT NULL,
  `count` int(11) NOT NULL,
  `count_link` int(11) NOT NULL,
  `name` text NOT NULL,
  `link` text NOT NULL,
  `to` int(10) NOT NULL DEFAULT '0',
  `color` varchar(10) NOT NULL,
  `time` int(11) NOT NULL,
  `day` int(11) NOT NULL,
  `mesto` int(2) NOT NULL,
  `bold` tinyint(1) NOT NULL DEFAULT '0',
  `italic` tinyint(1) NOT NULL DEFAULT '0',
  `underline` tinyint(1) NOT NULL DEFAULT '0',
  `show` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_cat`
-- 

CREATE TABLE `cms_album_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0',
  `name` varchar(40) NOT NULL,
  `description` text NOT NULL,
  `password` varchar(20) NOT NULL,
  `access` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `access` (`access`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_comments`
-- 

CREATE TABLE `cms_album_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(10) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text NOT NULL,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_downloads`
-- 

CREATE TABLE `cms_album_downloads` (
  `user_id` int(10) unsigned NOT NULL,
  `file_id` int(10) unsigned NOT NULL,
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_files`
-- 

CREATE TABLE `cms_album_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `album_id` int(10) unsigned NOT NULL,
  `description` text NOT NULL,
  `img_name` varchar(100) NOT NULL,
  `tmb_name` varchar(100) NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  `comments` tinyint(1) NOT NULL DEFAULT '1',
  `comm_count` int(11) NOT NULL DEFAULT '0',
  `access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `vote_plus` int(11) NOT NULL,
  `vote_minus` int(11) NOT NULL,
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `downloads` int(10) unsigned NOT NULL DEFAULT '0',
  `unread_comments` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `album_id` (`album_id`),
  KEY `access` (`access`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_views`
-- 

CREATE TABLE `cms_album_views` (
  `user_id` int(10) unsigned NOT NULL,
  `file_id` int(10) unsigned NOT NULL,
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_album_votes`
-- 

CREATE TABLE `cms_album_votes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `file_id` int(10) unsigned NOT NULL,
  `vote` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `file_id` (`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_ban_ip`
-- 

CREATE TABLE `cms_ban_ip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip1` bigint(11) NOT NULL DEFAULT '0',
  `ip2` bigint(11) NOT NULL DEFAULT '0',
  `ban_type` tinyint(4) NOT NULL DEFAULT '0',
  `link` varchar(100) NOT NULL,
  `who` varchar(25) NOT NULL,
  `reason` text NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip1` (`ip1`),
  UNIQUE KEY `ip2` (`ip2`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;


-- --------------------------------------------------------
-- 
-- Table structure for table `cms_ban_users`
-- 

CREATE TABLE `cms_ban_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `ban_time` int(11) NOT NULL DEFAULT '0',
  `ban_while` int(11) NOT NULL DEFAULT '0',
  `ban_type` tinyint(4) NOT NULL DEFAULT '1',
  `ban_who` varchar(30) NOT NULL DEFAULT '',
  `ban_ref` int(11) NOT NULL DEFAULT '0',
  `ban_reason` text NOT NULL,
  `ban_raz` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `ban_time` (`ban_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_contact`
-- 

CREATE TABLE `cms_contact` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `friends` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ban` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `man` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_user` (`user_id`,`from_id`),
  KEY `time` (`time`),
  KEY `ban` (`ban`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_counters`
-- 

CREATE TABLE `cms_counters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sort` int(10) NOT NULL DEFAULT '1',
  `name` varchar(30) NOT NULL,
  `link1` text NOT NULL,
  `link2` text NOT NULL,
  `mode` tinyint(4) NOT NULL DEFAULT '1',
  `switch` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_forum_files`
-- 

CREATE TABLE `cms_forum_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat` int(10) NOT NULL,
  `subcat` int(10) NOT NULL,
  `topic` int(10) NOT NULL,
  `post` int(10) NOT NULL,
  `time` int(11) NOT NULL,
  `filename` text NOT NULL,
  `filetype` tinyint(4) NOT NULL,
  `dlcount` int(10) NOT NULL,
  `del` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cat` (`cat`),
  KEY `subcat` (`subcat`),
  KEY `topic` (`topic`),
  KEY `post` (`post`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_forum_rdm`
-- 

CREATE TABLE `cms_forum_rdm` (
  `topic_id` int(11) unsigned NOT NULL DEFAULT '0',
  `bookmark` int(1) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`topic_id`,`user_id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_forum_vote`
-- 

CREATE TABLE `cms_forum_vote` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(2) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `topic` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `topic` (`topic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_forum_vote_users`
-- 

CREATE TABLE `cms_forum_vote_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `topic` int(11) NOT NULL,
  `vote` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `topic` (`topic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_guests`
-- 

CREATE TABLE `cms_guests` (
  `session_id` char(32) NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `browser` tinytext NOT NULL,
  `lastdate` int(11) NOT NULL,
  `sestime` int(11) NOT NULL,
  `movings` int(11) NOT NULL DEFAULT '0',
  `place` varchar(30) NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `time` (`lastdate`),
  KEY `place` (`place`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_library_comments`
-- 

CREATE TABLE `cms_library_comments` (
  `id`         INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sub_id`     INT(11) UNSIGNED NOT NULL,
  `time`       INT(11)          NOT NULL,
  `user_id`    INT(11) UNSIGNED NOT NULL,
  `text`       TEXT             NOT NULL,
  `reply`      TEXT,
  `attributes` TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_library_rating`
-- 

CREATE TABLE IF NOT EXISTS `cms_library_rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `st_id` int(11) NOT NULL,
  `point` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`st_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;  

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_mail`
-- 

CREATE TABLE `cms_mail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  `read` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sys` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `spam_read` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `delete` int(10) unsigned NOT NULL DEFAULT '0',
  `file_name` varchar(100) NOT NULL DEFAULT '',
  `count` int(10) NOT NULL DEFAULT '0',
  `size` int(10) NOT NULL DEFAULT '0',
  `them` varchar(100) NOT NULL DEFAULT '',
  `spam` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `spam_mail` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `from_id` (`from_id`),
  KEY `time` (`time`),
  KEY `read` (`read`),
  KEY `sys` (`sys`),
  KEY `delete` (`delete`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_online`
-- 

CREATE TABLE `cms_online` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `total` int(11) NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_sessions`
-- 

CREATE TABLE `cms_sessions` (
  `session_id` char(32) NOT NULL DEFAULT '',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `browser` varchar(255) NOT NULL DEFAULT '',
  `lastdate` int(10) unsigned NOT NULL DEFAULT '0',
  `sestime` int(10) unsigned NOT NULL DEFAULT '0',
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `movings` smallint(5) unsigned NOT NULL DEFAULT '0',
  `place` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_shouts`
-- 

CREATE TABLE `cms_shouts` (
  `session_id` char(32) NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `browser` tinytext NOT NULL,
  `lastdate` int(11) NOT NULL,
  `sestime` int(11) NOT NULL,
  `movings` int(11) NOT NULL DEFAULT '0',
  `place` varchar(30) NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `time` (`lastdate`),
  KEY `place` (`place`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_users_data`
-- 

CREATE TABLE `cms_users_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(30) NOT NULL DEFAULT '',
  `val` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_users_guestbook`
-- 

CREATE TABLE `cms_users_guestbook` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(10) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text NOT NULL,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_users_iphistory`
-- 

CREATE TABLE `cms_users_iphistory` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `user_ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `cms_users_shoutbox`
-- 

CREATE TABLE `cms_users_shoutbox` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(10) unsigned NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` text NOT NULL,
  `reply` text NOT NULL,
  `attributes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

--
-- Структура таблицы `download__bookmark`
--
DROP TABLE IF EXISTS `download__bookmark`;
CREATE TABLE `download__bookmark` (
  `id`      INT(11) NOT NULL AUTO_INCREMENT,
  `user_id` INT(11) NOT NULL,
  `file_id` INT(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `file_id` (`file_id`),
  KEY `user_id` (`user_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8mb4;

--
-- Структура таблицы `download__category`
--
DROP TABLE IF EXISTS `download__category`;
CREATE TABLE `download__category` (
  `id`       INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `refid`    INT(11) UNSIGNED NOT NULL DEFAULT '0',
  `dir`      TEXT             NOT NULL,
  `sort`     INT(11)          NOT NULL DEFAULT '0',
  `name`     TEXT             NOT NULL,
  `total`    INT(11) UNSIGNED NOT NULL DEFAULT '0',
  `rus_name` TEXT             NOT NULL,
  `text`     TEXT             NOT NULL,
  `field`    INT(11)          NOT NULL DEFAULT '0',
  `desc`     TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `total` (`total`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8mb4;

--
-- Структура таблицы `download__comments`
--
DROP TABLE IF EXISTS `download__comments`;
CREATE TABLE `download__comments` (
  `id`         INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sub_id`     INT(10) UNSIGNED NOT NULL,
  `time`       INT(11)          NOT NULL,
  `user_id`    INT(10) UNSIGNED NOT NULL,
  `text`       TEXT             NOT NULL,
  `reply`      TEXT             NOT NULL,
  `attributes` TEXT             NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_id` (`sub_id`),
  KEY `user_id` (`user_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8mb4;

--
-- Структура таблицы `download__files`
--
DROP TABLE IF EXISTS `download__files`;
CREATE TABLE `download__files` (
  `id`         INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `refid`      INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `dir`        TEXT             NOT NULL,
  `time`       INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `name`       TEXT             NOT NULL,
  `type`       INT(2)  UNSIGNED NOT NULL DEFAULT '0',
  `user_id`    INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `rus_name`   TEXT             NOT NULL,
  `text`       TEXT             NOT NULL,
  `field`      INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `rate`       VARCHAR(30)      NOT NULL DEFAULT '0|0',
  `about`      TEXT             NOT NULL,
  `desc`       TEXT             NOT NULL,
  `comm_count` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `comm_count` (`comm_count`),
  KEY `type` (`type`),
  KEY `user_id` (`user_id`),
  KEY `time` (`time`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8mb4;

--
-- Структура таблицы `download__more`
--
DROP TABLE IF EXISTS `download__more`;
CREATE TABLE `download__more` (
  `id`       INT(11) NOT NULL AUTO_INCREMENT,
  `refid`    INT(11) NOT NULL,
  `time`     INT(11) NOT NULL,
  `name`     TEXT    NOT NULL,
  `rus_name` TEXT    NOT NULL,
  `size`     INT(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `time` (`time`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `forum`
-- 

CREATE TABLE `forum` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `refid` int(11) NOT NULL DEFAULT '0',
  `type` char(1) NOT NULL DEFAULT '',
  `time` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `from` varchar(25) NOT NULL DEFAULT '',
  `realid` int(3) NOT NULL DEFAULT '0',
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `soft` text NOT NULL,
  `text` text NOT NULL,
  `close` tinyint(1) NOT NULL DEFAULT '0',
  `close_who` varchar(25) NOT NULL,
  `vip` tinyint(1) NOT NULL DEFAULT '0',
  `edit` text NOT NULL,
  `tedit` int(11) NOT NULL DEFAULT '0',
  `kedit` int(2) NOT NULL DEFAULT '0',
  `curators` text NOT NULL,
  `nospam` int(11) NOT NULL DEFAULT '0',
  `min_post` int(11) NOT NULL DEFAULT '0',
  `min_post_nt` int(11) NOT NULL DEFAULT '0',
  `tiento` varchar(50) NOT NULL,
  `id_user` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `refid` (`refid`),
  KEY `type` (`type`),
  KEY `time` (`time`),
  KEY `close` (`close`),
  KEY `user_id` (`user_id`),
  FULLTEXT KEY `text` (`text`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `forum_thank`
-- 

CREATE TABLE `forum_thank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `topic` int(11) NOT NULL,
  `userthank` int(11) NOT NULL,
  `chude` int(11) NOT NULL,
  `time` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `friendssite`
-- 

CREATE TABLE `friendssite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `site` text NOT NULL,
  `name` text NOT NULL,
  `opis` text NOT NULL,
  `iduser` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  `type` int(2) NOT NULL,
  `vr` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `guest`
-- 

CREATE TABLE `guest` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adm` tinyint(1) NOT NULL DEFAULT '0',
  `time` int(15) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(25) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `browser` tinytext NOT NULL,
  `admin` varchar(25) NOT NULL DEFAULT '',
  `otvet` text NOT NULL,
  `otime` int(15) NOT NULL DEFAULT '0',
  `edit_who` varchar(20) NOT NULL DEFAULT '',
  `edit_time` int(11) NOT NULL DEFAULT '0',
  `edit_count` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `ip` (`ip`),
  KEY `adm` (`adm`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `guard`
-- 

CREATE TABLE `guard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(50) NOT NULL,
  `key` varchar(100) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `txt1` varchar(500) NOT NULL,
  `txt2` varchar(500) NOT NULL,
  `txt3` varchar(500) NOT NULL,
  `txt4` varchar(500) NOT NULL,
  `txt5` varchar(500) NOT NULL,
  `time` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `karma_users`
-- 

CREATE TABLE `karma_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `karma_user` int(11) NOT NULL,
  `points` int(2) NOT NULL,
  `type` int(1) NOT NULL,
  `time` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `karma_user` (`karma_user`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `library_cats`
-- 

CREATE TABLE `library_cats` (
  `id`          INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent`      INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `name`        VARCHAR(200)     NOT NULL DEFAULT '',
  `description` TEXT             NOT NULL,
  `dir`         TINYINT(1)       NOT NULL DEFAULT '0',
  `pos`         INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_add`    TINYINT(1)       NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `library_texts`
-- 

CREATE TABLE `library_texts` (
  `id`             INT(10) UNSIGNED  NOT NULL AUTO_INCREMENT,
  `cat_id`         INT(10)  UNSIGNED NOT NULL DEFAULT '0',
  `text`           MEDIUMTEXT        NOT NULL,
  `name`           VARCHAR(255)      NOT NULL DEFAULT '',
  `announce`       TEXT,
  `uploader`       VARCHAR(100)      NOT NULL DEFAULT '',
  `uploader_id`    INT(10)  UNSIGNED NOT NULL DEFAULT '0',
  `count_views`    INT(10) UNSIGNED  NOT NULL DEFAULT '0',
  `premod`         TINYINT(1)        NOT NULL DEFAULT '0',
  `comments`       TINYINT(1)        NOT NULL DEFAULT '0',
  `count_comments` INT(10)  UNSIGNED NOT NULL DEFAULT '0',
  `time`           INT(10) UNSIGNED  NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  FULLTEXT KEY `text` (`text`, `name`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `library_tags`
-- 

CREATE TABLE `library_tags` (
  `id`          INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `lib_text_id` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `tag_name`    VARCHAR(255)     NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `lib_text_id` (`lib_text_id`),
  KEY `tag_name` (`tag_name`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `my_guests`
-- 

CREATE TABLE `my_guests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `my_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `guest_id` int(11) NOT NULL,
  `type` set('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `news`
-- 

CREATE TABLE `news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL DEFAULT '0',
  `avt` varchar(25) NOT NULL DEFAULT '',
  `name` text NOT NULL,
  `text` text NOT NULL,
  `kom` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `pars_url`
-- 

CREATE TABLE `pars_url` (
  `id` int(11) NULL AUTO_INCREMENT,
  `url` varchar(255) NULL,
  `txt` TEXT NULL,
	PRIMARY KEY(`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `shout`
-- 

CREATE TABLE `shout` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adm` tinyint(1) NOT NULL DEFAULT '0',
  `time` int(15) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(25) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `browser` tinytext NOT NULL,
  `admin` varchar(25) NOT NULL DEFAULT '',
  `otvet` text NOT NULL,
  `otime` int(15) NOT NULL DEFAULT '0',
  `edit_who` varchar(20) NOT NULL DEFAULT '',
  `edit_time` int(11) NOT NULL DEFAULT '0',
  `edit_count` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `ip` (`ip`),
  KEY `adm` (`adm`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `slave`
-- 

CREATE TABLE `slave` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(50) NOT NULL,
  `key` varchar(100) NOT NULL DEFAULT '',
  `text` text NOT NULL,
  `txt1` varchar(500) NOT NULL,
  `txt2` varchar(500) NOT NULL,
  `txt3` varchar(500) NOT NULL,
  `txt4` varchar(500) NOT NULL,
  `txt5` varchar(500) NOT NULL,
  `time` int(15) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Table structure for table `users`
-- 

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL DEFAULT '',
  `name_lat` varchar(40) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `rights` int(1) NOT NULL DEFAULT '0',
  `failed_login` tinyint(4) NOT NULL DEFAULT '0',
  `imname` varchar(25) NOT NULL DEFAULT '',
  `sex` varchar(2) NOT NULL DEFAULT '',
  `komm` int(10) NOT NULL DEFAULT '0',
  `postforum` int(10) NOT NULL DEFAULT '0',
  `postguest` int(11) NOT NULL DEFAULT '0',
  `journal_forum` int(11) NOT NULL DEFAULT '0',
  `yearofbirth` int(4) NOT NULL DEFAULT '0',
  `datereg` int(11) NOT NULL DEFAULT '0',
  `lastdate` int(11) NOT NULL DEFAULT '0',
  `mail` varchar(50) NOT NULL DEFAULT '',
  `icq` int(9) NOT NULL DEFAULT '0',
  `skype` varchar(50) NOT NULL,
  `jabber` varchar(50) NOT NULL,
  `www` varchar(50) NOT NULL DEFAULT '',
  `about` text NOT NULL,
  `social` text NOT NULL,
  `social_token` varchar(32) NOT NULL,
  `del_id` INT(11) NOT NULL DEFAULT 0,
  `del_time` INT(11) NOT NULL DEFAULT 0,
  `del_txt` TEXT NOT NULL,
  `del_reason` TEXT NOT NULL,
  `del_setting` TEXT NOT NULL,
  `live` varchar(50) NOT NULL DEFAULT '',
  `mibile` varchar(50) NOT NULL DEFAULT '',
  `status` text NOT NULL,
  `ip` bigint(11) NOT NULL DEFAULT '0',
  `ip_via_proxy` bigint(11) NOT NULL DEFAULT '0',
  `browser` text NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  `preg` tinyint(1) NOT NULL DEFAULT '0',
  `regadm` varchar(25) NOT NULL DEFAULT '',
  `mailvis` tinyint(1) NOT NULL DEFAULT '0',
  `dayb` int(2) NOT NULL DEFAULT '0',
  `monthb` int(2) NOT NULL DEFAULT '0',
  `sestime` int(15) NOT NULL DEFAULT '0',
  `total_on_site` int(11) NOT NULL DEFAULT '0',
  `lastpost` int(11) NOT NULL,
  `rest_code` varchar(32) NOT NULL,
  `rest_time` int(11) NOT NULL,
  `movings` int(11) NOT NULL DEFAULT '0',
  `place` varchar(30) NOT NULL,
  `set_user` text NOT NULL,
  `set_forum` text NOT NULL,
  `set_mail` tinytext NOT NULL,
  `karma_plus` int(11) NOT NULL DEFAULT '0',
  `karma_minus` int(11) NOT NULL DEFAULT '0',
  `karma_time` int(11) NOT NULL DEFAULT '0',
  `karma_off` int(1) NOT NULL,
  `comm_count` int(10) unsigned NOT NULL,
  `comm_old` int(10) unsigned NOT NULL DEFAULT '0',
  `smileys` text NOT NULL,
  `prosm_ank` int(11) NOT NULL DEFAULT '0',
  `negara` varchar(40) NOT NULL,
  `postshout` int(11) NOT NULL DEFAULT '0',
  `podpis` varchar(500) NOT NULL,
  `forum_quotes` int(11) NOT NULL DEFAULT '0',
  `quiz` int(10) NOT NULL,
  `balans` int(11) NOT NULL DEFAULT '1000',
  `money_time` int(11) NOT NULL DEFAULT '0',
  `email_code` varchar(25) NOT NULL,
  `likes` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name_lat` (`name_lat`),
  KEY `lastdate` (`lastdate`),
  KEY `place` (`place`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- 
-- Updating some data for table `users`
-- 

UPDATE users SET del_reason = 'YToxMTp7aTowO3M6NTE6IkkgaGF2ZSBhbm90aGVyIGFjY291bnQhDQoiO2k6MTtzOjgyOiJUaGUgc2l0ZSBpcyB0b28gY29tcGxpY2F0ZWQsIEkgZG8gbm90IHVuZGVyc3RhbmQgYW55dGhpbmcgaGVyZSENCiI7aToyO3M6Mjk6IkknbSBib3JlZCBoZXJlIQ0KIjtpOjM7czo1NzoiVGhlIHJ1bGVzIGFyZSBqdXN0IHRvbyBzdHJpY3QhDQoiO2k6NDtzOjUyOiJNb2RlcmF0b3JzIEFyZSBVbmZhaXIhDQoiO2k6NTtzOjc2OiJJJ3ZlIGdvdCBmZXcgZnJpZW5kcywgbm8gb25lIHRvIHRhbGshIQ0KIjtpOjY7czo0MjoiU28gdGlyZWQhDQoiO2k6NztzOjU2OiJNeSByYXRpbmcgaXMgbm90IGluY3JlYXNpbmchDQoiO2k6ODtzOjUyOiJUaGlzIHRpbWUsIGkgbmVlZCBhIGJyZWFrLCBJJ2xsIGJlIGJhY2shDQoiO2k6OTtzOjQ3OiJUaXJlZCwgcmF0aW5nIGp1bXBzIQ0KIjtpOjEwO3M6NzI6Ikkgc3BlbmQgYSBsb3Qgb2YgdGltZSBoZXJlIHN1cmZpbmchDQoiO30=', del_setting = 'a:2:{s:6:"balans";i:10000;s:4:"days";i:10;}';