<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

define('_IN_JOHNCMS', 1);

$id = isset($_GET['id']) ? trim($_GET['id']) : '';
$act = isset($_GET['act']) ? trim($_GET['act']) : '';

require('../system/bootstrap.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\BbcodeInterface $bbcode */
$bbcode = $container->get(Johncms\Api\BbcodeInterface::class);


/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

$textl = _t('Bot Panel');
$headmod = 'botpanel';
require('../system/head.php');

if (!$systemUser->isValid()) {
    echo 'You are not logged in';
    require ('../system/end.php');
    exit;
}

if ($systemUser->isValid() && $systemUser->rights < 1) {
    header('Location: /?err');
    exit;
}
$from = $systemUser->id ? $systemUser->name : $db->quote($name);
switch($act) {
case 'say':
if (isset($_POST['submit'])) {
$key = filter_has_var(INPUT_POST, 'key')
    ? mb_substr(filter_var($_POST['key'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$text = filter_has_var(INPUT_POST, 'text')
    ? mb_substr(filter_var($_POST['text'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$txt1 = filter_has_var(INPUT_POST, 'txt1')
    ? mb_substr(filter_var($_POST['txt1'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$txt2 = filter_has_var(INPUT_POST, 'txt2')
    ? mb_substr(filter_var($_POST['txt2'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$txt3 = filter_has_var(INPUT_POST, 'txt3')
    ? mb_substr(filter_var($_POST['txt3'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$txt4 = filter_has_var(INPUT_POST, 'txt4')
    ? mb_substr(filter_var($_POST['txt4'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$txt5 = filter_has_var(INPUT_POST, 'txt5')
    ? mb_substr(filter_var($_POST['txt5'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$check = $db->query("SELECT COUNT(*) FROM `guard` WHERE `key`='$key';")->fetchColumn();

$error = [];
if (empty($key)) {
$error['key'][] = _t('Key field is empty');
}
if (empty($text)) {
$error['text'][] = _t('Text field is empty');
}
if (check > 0) {
$error[] = _t('Input histories already exists');
}

if (empty($error)) {
$db->prepare('
INSERT INTO `guard` SET
`time` = ?,
`user` = ?,
`text` = ?,
`txt1` = ?,
`txt2` = ?,
`txt3` = ?,
`txt4` = ?,
`txt5` = ?,
`key` = ?
')->execute([        
time(),
$from,
$text,
$txt1,
$txt2,
$txt3,
$txt4,
$txt5,
$key,
]);
echo '<div class="mainblok"><div class="phdr">Alert Message</div>';
echo '<div class="gmenu"><a href="guardpanel.php">Continue</a></div></div>';
header("Location: guardpanel.php");
} 
} 
echo '<div class="mainblok"><div class="phdr"><a href="' . $config['homeurl'] . '/guestbook/">GuestBook</a> | <b>Bot Message For Guestbook</b></div>';
echo '<form action="guardpanel.php?act=say" method="post"><div class="gmenu">' .
    '<p><h3>' . _t('Key') . '</h3>' .
    (isset($error['key']) ? '<span class="red"><small>' . implode('<br />',
            $error['key']) . '</small></span><br />' : '') .
    '<input type="text" name="key" value="' . htmlspecialchars($key) . '"' . (isset($error['key']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '</p>' .
    '<p><h3>' . _t('Text') . '</h3>' .
    (isset($error['text']) ? '<span class="red"><small>' . implode('<br />',
            $error['text']) . '</small></span><br />' : '') .
    '<input type="text" name="text" value="' . htmlspecialchars($text) . '"' . (isset($error['text']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '</p>' . 
    '<p><h3>' . _t('Text 1') . '</h3>' .
    '<input type="text" name="txt1" value="' . htmlspecialchars($txt1) . '" /><br />' .
    '</p>' .
    '<p><h3>' . _t('Text 2') . '</h3>' .
    '<input type="text" name="txt2" value="' . htmlspecialchars($txt2) . '" /><br />' .
    '</p>' .
    '<p><h3>' . _t('Text 3') . '</h3>' .
    '<input type="text" name="txt3" value="' . htmlspecialchars($txt3) . '" /><br />' .
    '</p>' .
    '<p><h3>' . _t('Text 4') . '</h3>' .
    '<input type="text" name="txt4" value="' . htmlspecialchars($txt4) . '" /><br />' .
    '</p>' .
    '<p><h3>' . _t('Text 5') . '</h3>' .
    '<input type="text" name="txt5" value="' . htmlspecialchars($txt5) . '" /><br />' .
    '</p>' . 
    '<p><input type="submit" name="submit" value="' . _t('Add') . '"/></p></div></form>' .
    '<div class="phdr"><a href="guardpanel.php">' . _t('Back') . '</a></div>' . 
    '<div class="phdr"><b>' . _t('Fix by Oluwaseun') . '</b></div></div>';

echo '<div class="mainblok"><div class="phdr">Info for bot</div><div class="gmenu"><span class="red">* Must filled</span>: <br><b>{user}</b> To nick user<br><b>{text}</b> Text<br><b>{reply}</b> Reply</div>';
echo '</div>';
break;

case 'del':
if ($id) {
$exist = $db->query("SELECT COUNT(*) FROM `guard` WHERE `id`='$id';")->fetchColumn();
$uexist = $db->query("SELECT COUNT(*) FROM `guard` WHERE `id`='$id' AND `user`='$from';")->fetchColumn();
$error = [];
if(!$exist) {
$error[] = 'Error! Not found on the server';
}
if(!$uexist && $systemUser->rights < 9) {
$error[] = 'You cant remove this';
}
if(!$error) {
$db->exec("DELETE FROM `guard` WHERE `id`='" . $id . "'");
echo '<div class="mainblok"><div class="phdr">Alert Box</div>';
echo '<div class="gmenu">Successfully Deleted <br /><a href="guardpanel.php">Continue</a></div></div>';
} 
} else {
echo $tools->displayError($error);
}
break;

case 'edit':
if ($id) {
$echeck = $db->query("SELECT COUNT(*) FROM `guard` WHERE `key`='$key';")->fetchColumn();
$edit = $db->query("SELECT * FROM `guard` WHERE `id`='$id' LIMIT 1")->fetch();
$euexist = $db->query("SELECT COUNT(*) FROM `guard` WHERE `id`='$id' AND `user`='$from';")->fetchColumn();
$eexist = $db->query("SELECT COUNT(*) FROM `guard` WHERE `id`='$id';")->fetchColumn();

if (isset($_POST['submit'])) {
$key = filter_has_var(INPUT_POST, 'key')
    ? mb_substr(filter_var($_POST['key'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$text = filter_has_var(INPUT_POST, 'text')
    ? mb_substr(filter_var($_POST['text'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$txt1 = filter_has_var(INPUT_POST, 'txt1')
    ? mb_substr(filter_var($_POST['txt1'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$txt2 = filter_has_var(INPUT_POST, 'txt2')
    ? mb_substr(filter_var($_POST['txt2'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$txt3 = filter_has_var(INPUT_POST, 'txt3')
    ? mb_substr(filter_var($_POST['txt3'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$txt4 = filter_has_var(INPUT_POST, 'txt4')
    ? mb_substr(filter_var($_POST['txt4'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$txt5 = filter_has_var(INPUT_POST, 'txt5')
    ? mb_substr(filter_var($_POST['txt5'], FILTER_SANITIZE_SPECIAL_CHARS, ['flag' => FILTER_FLAG_ENCODE_HIGH]), 0, 100)
    : '';
$error = [];
if (empty($key)) {
$error['key'][] = _t('Key cannot be empty');
}
if (empty($text)) {
$error['text'][] = _t('Text field cannot be empty');
}
if ($echeck > 0) { 
$error[] = 'Not Found'; 
}
if (!$error) {
$db->prepare('
UPDATE `guard` SET
`time` = ?,
`text` = ?,
`txt1` = ?,
`txt2` = ?,
`txt3` = ?,
`txt4` = ?,
`txt5` = ?,
`key` = ?
WHERE `id` = ?
')->execute([        
time(),
$text,
$txt1,
$txt2,
$txt3,
$txt4,
$txt5,
$key,
$id,
]);
echo '<div class="mainblok"><div class="gmenu"><a href="guardpanel.php">Continue</a></div></div>';
header("Location: guardpanel.php");
} 
} 
} 
echo '<div class="mainblok"><div class="phdr"><b>Set BOT</b></div>';
echo '<form action="guardpanel.php?act=edit&amp;id='.$id.'" method="post"><div class="gmenu">' .
    '<p><h3>' . _t('Key') . '</h3>' .
    (isset($error['key']) ? '<span class="red"><small>' . implode('<br />',
            $error['key']) . '</small></span><br />' : '') .
    '<input type="text" name="key" value="' . htmlentities($edit['key'], ENT_QUOTES, 'UTF-8'). '"' . (isset($error['key']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '</p>' .
    '<p><h3>' . _t('Text') . '</h3>' .
    (isset($error['text']) ? '<span class="red"><small>' . implode('<br />',
            $error['text']) . '</small></span><br />' : '') .
    '<input type="text" name="text" value="' . htmlentities($edit['text'], ENT_QUOTES, 'UTF-8'). '"' . (isset($error['text']) ? ' style="background-color: #FFCCCC"' : '') . '/><br />' .
    '</p>' . 
    '<p><h3>' . _t('Text 1') . '</h3>' .
    '<input type="text" name="txt1" value="' . htmlentities($edit['txt1'], ENT_QUOTES, 'UTF-8'). '" /><br />' .
    '</p>' .
    '<p><h3>' . _t('Text 2') . '</h3>' .
    '<input type="text" name="txt2" value="' . htmlentities($edit['txt2'], ENT_QUOTES, 'UTF-8'). '" /><br />' .
    '</p>' .
    '<p><h3>' . _t('Text 3') . '</h3>' .
    '<input type="text" name="txt3" value="' . htmlentities($edit['txt3'], ENT_QUOTES, 'UTF-8'). '" /><br />' .
    '</p>' .
    '<p><h3>' . _t('Text 4') . '</h3>' .
    '<input type="text" name="txt4" value="' . htmlentities($edit['txt4'], ENT_QUOTES, 'UTF-8'). '" /><br />' .
    '</p>' .
    '<p><h3>' . _t('Text 5') . '</h3>' .
    '<input type="text" name="txt5" value="' . htmlentities($edit['txt5'], ENT_QUOTES, 'UTF-8'). '" /><br />' .
    '</p>' . 
    '<p><input type="submit" name="submit" value="' . _t('Edit') . '"/></p></div></form>' .
    '<div class="phdr"><a href="guardpanel.php">' . _t('Back') . '</a></div>' . 
    '<div class="phdr"><b>' . _t('Fix by Oluwaseun') . '</b></div></div>'; 
break;

default:
echo '<div class="mainblok"><div class="phdr"><b>Guestbook Bot Menu</b></div>';
echo '<div class="menu"><a href="guardpanel.php? act=say">New Response</a></div>'; 
echo '<div class="menu"><a href="' . $config['homeurl'] . '/admin/index.php?act=botsett">Bot Settings</a></div>';
echo '<div class="phdr"><a href="' . $config['homeurl'] . '/guestbook/">Guestbook</a></div>';
echo '<div class="phdr"><b>Fix by Oluwaseun</b></div></div>';
$total = $db->query("SELECT COUNT(*) FROM `guard`;")->fetchColumn();
if($total == 0) {
echo '<div class="mainblok"><div class="phdr">Alert</div>';
echo '<div class="rmenu">No messages..!!</div></div>';
} else {
echo '<div class="mainblok"><div class="phdr"><b>Existing bot</b></div>';
$req = $db->query("SELECT * FROM `guard` ORDER BY `time` DESC LIMIT $start, $kmess");
$i=0;
while ($bot = $req->fetch()) {
echo $i % 2 ? '<div class="gmenu">' : '<div class="gmenu">';
echo '<b>Key: </b> '.$bot['key'].'<br><b>Text: </b> '.$bot['text'].'<br>'.($bot['txt1'] ? '<b>Text 1:</b> '.$bot['txt1'].'<br>' : '').''.($bot['txt2'] ? '<b>Text 2:</b> '.$bot['txt2'].'<br>' : '').''.($bot['txt3'] ? '<b>Text 3:</b> '.$bot['txt3'].'<br>' : '').''.($bot['txt4'] ? '<b>Text 4:</b> '.$bot['txt4'].'<br>' : '').''.($bot['txt5'] ? '<b>Text 5:</b> '.$bot['txt5'].'<br>' : '').'<b>Added by:</b> '.$bot['user'].'<br><b>Time added:</b> '.$tools->displayDate($bot['time']).'';
if($from = $bot['user'] || $systemUser->rights >= 7) {
echo '<br/><a href="?act=edit&id='.$bot['id'].'"><span class="red"><b>Edit</b></span></a> &bull; <a href="?act=del&id='.$bot['id'].'"><span class="red"><b>Delete</b></span></a>';
}
echo '</div>';
++$i;
}
echo '<div class="phdr">' . _t('Total') . ': ' . $total . '</div>';

if ($total > $kmess) {
echo '<div class="gmenu">' . $tools->displayPagination('guardpanel.php?', $start, $total, $kmess) . '<br/>';
echo '<form action="guardpanel.php" method="get"><input type="text" name="page" size="2"/><input type="submit" value="' . _t('Go to page') . ' &gt;&gt;"/></form></div>';
}
echo '</div>';
}
break;
} 
require('../system/end.php');
?>