<?php

define('_IN_JOHNCMS', 1);
$server = $_SERVER['DOCUMENT_ROOT'];
require($server . '/system/bootstrap.php');
/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\EnvironmentInterface $env */
$env = $container->get(Johncms\Api\EnvironmentInterface::class);

/** @var Johncms\Api\BbcodeInterface $bbcode */
$bbcode = $container->get(Johncms\Api\BbcodeInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

$headmod = 'ip_convert';
$textl = 'ip-convert';
require($server . '/system/head.php');
 
$act = isset($_GET['act']) ? trim($_GET['act']) : '';
if ($act != 'ip'){
$act = 'domain';
}

$domain = isset($_GET['domain']) ? trim($_GET['domain']) : '';
$ip = isset($_GET['ip']) ? trim($_GET['ip']) : '';

echo '<div class="mainblok">';
echo '<div class="phdr"><b>IP Converter</b></div>';
switch ($act)
{
case 'ip':
echo '<div class="gmenu"><b>Enter IP:</b><br/><form action="ipconvert.php" method="get"><input name="ip" type="text" title="IP" maxlength="50"/><br/><input type="hidden" name="url" value="'.$url.'"/><input type="hidden" name="act" value="ip"/><input type="submit" value="Convert"/></form></div>';
if(!$ip){
echo '<div class="rmenu">Convert IP</div>';
}
else{
if(!preg_match("/^\d{0,3}+\.\d{0,3}+\.\d{0,3}+\.\d{0,3}+$/i", $ip)){
echo '<div class="rmenu">Error!</div>';
}
else{
$domain = gethostbyaddr($ip);
echo '<div class="rmenu">'.$domain.'<br/></div>';
}
}

echo '<div class="menu"><a href="ipconvert.php?act=domain&amp;url='.$url.'">Host &#187; IP</a><br/></div>';
echo '<div class="menu"><a href="ipconvert.php?act=ip&amp;url='.$url.'">IP &#187; Host</a><br/></div>';
break;
case 'domain':
echo '<div class="gmenu"><b>Enter Host or IP (http://):</b><br/><form action="ipconvert.php" method="get"><input name="domain" type="text" title="Domain"/><br/><input type="hidden" name="url" value="'.$url.'"/><input type="hidden" name="act" value="domain"/><input type="submit" value="Convert"/></form></div>';
if(!$domain){
echo '<div class="rmenu">Converter Host</div>';
}
else
{
$domain = str_replace('http://','',$domain);
$domain = htmlspecialchars(trim($domain));
$ip = gethostbynamel($domain);

foreach ($ip as $index => $val){
echo '<div class="rmenu">'.$val.'<br/></div>';
}
}

echo '<div class="menu"><a href="ipconvert.php?act=ip&amp;url='.$url.'">IP &#187; Host</a><br/></div>';
echo '<div class="menu"><a href="ipconvert.php?act=domain&amp;url='.$url.'">Host &#187; IP</a><br/></div>';
break;
default:
echo '<div class="rmenu">Error!</div>';
break;
}

echo '<div class="phdrblack"><b><a href="javascript:history.back(2)">Back</a></b></div>';



echo '</div>';
require($server . '/system/end.php');
?>