<?php

namespace Johncms\Doc;

class NickNames
{
    const ADM = 1;
    const OFF = 1;
    
    private $id;
    private $day;
    private $time;
    private $close;
    private $db;
    
    public function __construct($id)
    {
        $this->id = $id;
        $this->db = \App::getContainer()->get(\PDO::class);
        $this->getSettings();
    }
    
    /**
    * Получаем настройки по умолчанию
    */
    private function getSettings()
    {
        $sql = '
            SELECT `days` AS `day`, `close`
            FROM `nicksettings` 
            WHERE `user_id` = '. $this->id;
        
        $row = $this->db->query($sql)->fetch();
        
        $this->day = $row['day'];
        $this->close = $row['close'];
        $this->time = $this->setUserTime();
    }
    
    /**
    * Установка значений по умолчанию
    */
    private function setSettings()
    {
        $sql = '
            SELECT `user_id` 
            FROM `nicksettings` 
            WHERE `user_id` = '. $this->id .'
            LIMIT 1
        ';
        
        if (!$this->db->query($sql)->fetch()) {
            $sql = '
                INSERT INTO `nicksettings` 
                SET `days` = 30, 
                    `close` = 0,
                    `user_id` = '. $this->id;
            
            return $this->db->exec($sql);
        }
    }
    
    /**
    * Время последней смены ника юзером
    */
    private function setUserTime()
    {
        $sql = '
            SELECT `time`
            FROM `nicknames`
            WHERE `user_id` = '. $this->id .'
            ORDER BY `time` DESC LIMIT 1
        ';
        
        return $this->db->query($sql)->fetch()['time'];
    }

    /**
    * Определение истечения времени для смены ника
    */
    public function getUserTime()
    {
        $systShift = \App::getContainer()->get('config')['johncms']['timeshift'];
        $userShift = \App::getContainer()->get(\Johncms\Api\UserInterface::class)->getConfig()->getArrayCopy()['timeshift'];
        
        $shift = time() + (($systShift + $userShift) * 3600);
        $usTime = $this->time + (3600 * 24 * $this->day);
        
        return ($usTime < $shift && $this->close != self::OFF);
    }
    
    /**
    * Получить текущий ник
    */
    public function userName()
    {
        $sql = 'SELECT `id`,`name` AS `nick` FROM `users` 
            WHERE `id` = '. $this->id;
        
        return $this->db->query($sql)->fetch();
    }
    
    /**
    * Поиск соответствий ников в таблице users
    */
    public function searchNick($name)
    {
        $sql = 'SELECT COUNT(*)
            FROM `users` 
            WHERE `name` = '. $this->db->quote($name) .'
            OR `name_lat` = '. $this->db->quote($name) .'
        ';
        
        return ($this->db->query($sql)->fetchColumn() ? true : false);
    }
    
    /**
    * Запись в историю нового логина
    */
    public function setListNames($nick, $id)
    {
        !$this->setSettings() ?: $nick = \App::getContainer()->get(\Johncms\Api\UserInterface::class)->name; 
        
        $sql = '
            INSERT INTO `nicknames` 
            SET `user_id` = '. (!$id ? $this->id : $id) .',
                `nick` = '. $this->db->quote($nick) .',
                `time` = '. time();
        
        return (bool)$this->db->exec($sql);
    }
    
    /**
    * Перезапись основного ника
    */
    public function setMyNick($nick)
    {
        $sql = '
            UPDATE `users` 
            SET `name` = '. $this->db->quote($nick) .' 
            WHERE `id` = '. $this->id;
        
        $setMyNick = $this->db->exec($sql);
        $setListNames = $this->setListNames($nick);
        
        return ($setMyNick && $setListNames);
    }
    
    /**
    * Системное уведомление админу о смене ника
    */
    public function sendSysMail($them, $text, $to = self::ADM)
    {
        $sql = '
            INSERT INTO `cms_mail` 
            SET `user_id` = 0,
                `from_id` = '. $to .',
                `text` = '. $this->db->quote($text) .',
                `time` = '. time() .',
                `sys` = 1,
                `them` = '. $this->db->quote($them) .'
        ';
        
        return (bool)$this->db->exec($sql);
    }
    
    /**
    * Cписок всех ников одного юзера
    */
    public function listUserNames($levl, $int, $adm = 0)
    {
        $i = 0;
        $out = false;
        $all = $this->db->query('
            SELECT COUNT(*) FROM `nicknames` WHERE `user_id` = '. $this->id
        )->fetchColumn();
        
        if ($all > $int) {
            $uri = '';
            $path = parse_url(strip_tags($_SERVER['REQUEST_URI']), PHP_URL_PATH);
            
            foreach ($_GET as $k => $v) {
                $k == 'page' ?: $uri .= $k . (!$v ? '&' : '='. $v .'&');
            }
            
            $url = $path .'?'. $uri;
            $page = '<div class="topmenu">'
                . \App::getContainer()->get(\Johncms\Api\ToolsInterface::class)->displayPagination($url, $levl, $all, $int)
                . '</div>';
        }
        
        $sql = '
            SELECT `id`, `nick`, `time` FROM `nicknames` 
            WHERE `user_id` = '. $this->id .' 
            ORDER BY `time` DESC LIMIT '. $levl .', '. $int;
        
        $res = $this->db->query($sql);
        
        while ($row = $res->fetch()) {
            $out .= '<div class="list'. (++$i & 1 ? 1 : 2) .'">'. 
                (!$adm ? $row['nick'] : '<a href="admin.php?user='. 
                $this->id .'&edit='. $row['id'] .'&name='. $row['nick'] .'">'. 
                $row['nick'] .'</a>') .' <small><i>'. 
                \App::getContainer()->get(\Johncms\Api\ToolsInterface::class)->displayDate($row['time']) .'</i></small></div>';
        }
        
        return (empty($page) ? $out : $page . $out . $page);
    }
    
    /**
    * Фиксирование отслеживаемого ника
    */
    public function setTrackedNick($nick)
    {
        $sql = '
            UPDATE `users` 
            SET `nick` = '. $this->db->quote($nick) .' 
            WHERE `id` = '. $this->id;
        
        return (bool)$this->db->exec($sql);
    }
    
    /**
    * Проверка на доступность отслеживаемого ника
    */
    public function getTrackedNick()
    {        
        $sql = '
            SELECT `nick` FROM `users` 
            WHERE `id` = '. $this->id .' LIMIT 1
        ';
        
        $us = $this->db->query($sql)->fetch();
        
        if (!empty($us['nick'])) {
            if (!$this->searchNick($us['nick'])) {
                $them = 'Уведомление о доступности ника';
                $text = 'Ник [b]'. $us['nick'] .'[/b] свободен!';
                
                $this->sendSysMail($them, $text, $this->id);
                $this->delTrackedNick();
                
                return false;
            } else {
                return $us['nick'];
            }
        }
    }
    
    /**
    * Снятие ника с отслеживания
    */
    public function delTrackedNick()
    {
        $sql = '
            UPDATE `users` 
            SET `nick` = "" 
            WHERE `id` = '. $this->id;
        
        return (bool)$this->db->exec($sql);
    }
    
    /**
    * Отображение системных уведомлений
    */
    public function showMessages($out = false)
    {
        if (!empty($_SESSION['messages'])) {
            $out = $_SESSION['messages'];
            unset($_SESSION['messages']);
        }
        
        return $out;
    }
}
