<?php

namespace Johncms\Doc;

class NickAdmin
{
    public static $ob;
    
    private static function db()
    {
        return \App::getContainer()->get(\PDO::class);    
    }
    
    /**
    * Инициализация юзера по его ID 
    */
    public static function creatNick($id)
    {
        return self::$ob = new NickNames($id);
    }
    
    /**
    * Запрет/доступ смены ника для юзера
    */
    public static function closeNick($i = 0)
    {
        $sql = '
            UPDATE `nicksettings` 
            SET `close` = '. $i .' 
            WHERE `user_id` = '. self::$ob->id;
            
        return (bool)self::db()->exec($sql);
    }
    
    /**
    * Перезапись ника в таблице истории ников
    */
    public static function updateNames($id, $nick)
    {        
        $sql = '
            UPDATE `nicknames`
            SET `nick` = '. self::db()->quote($nick) .' 
            WHERE `id` = '. $id;
        
        return (bool)self::db()->exec($sql);
    }
    
    /**
    * Установка числа дней для смены ника
    */
    public static function setNickDays($i = 30)
    {
        $sql = '
            UPDATE `nicksettings` 
            SET `days` = '. $i .' 
            WHERE `user_id` = '. self::$ob->id;
        
        return (bool)self::db()->exec($sql);
    }
    
    /**
    * Удаление одной записи из истории юзера
    */
    public static function delOneNick($id)
    {
        $sql = 'SELECT COUNT(*) FROM `nicknames` WHERE `id` = '. $id;
                
        if (!self::db()->query($sql)->fetchColumn()) {
            return false;
        } else {
            $sql = 'DELETE FROM `nicknames` WHERE `id` = '. $id;
        
            return self::db()->exec($sql);
        }
    }
    
    /**
    * Удаление всех записей из истории юзера
    */
    public static function delAllNicks()
    {
        $sql = 'SELECT COUNT(*) FROM `nicknames` 
            WHERE `user_id` = '. self::$ob->id;
        
        if (!self::db()->query($sql)->fetchColumn()) {
            return false;
        } else {
            $sql = '
                DELETE `nicknames`, `nicksettings` 
                FROM `nicknames`, `nicksettings` 
                WHERE `nicknames`.`user_id` = '. self::$ob->id .' 
                AND `nicksettings`.`user_id` = '. self::$ob->id;
        
            return self::db()->exec($sql);
        }
    }
}
