<?php

const _IN_JOHNCMS = 1;

$textl = 'История ников - админка';
require('../system/bootstrap.php');
require('../system/head.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

#-----------------------------#

$view = '';

if ($user_id && $rights > 7) {
    $idUser = empty($_GET['user']) ? $systemUser->id : (int)$_GET['user'];
    
    $adm = Johncms\Doc\NickAdmin::creatNick($idUser);
    $cnt = Johncms\Doc\NickUser::cnt($idUser);
    
    $listNames = !$cnt 
        ? '<h4 class="rmenu">Список пуст!</h4>'
        : $adm->listUserNames($start, $kmess, Johncms\Doc\NickNames::ADM);
    
    $uri = strip_tags($_SERVER['QUERY_STRING']);
    $listNames .= '<div class="phdr">'. $tools->image('stack.png', 
        ['width' => '15', 'height' => '12']) .
        '<a href="index.php?'. $uri .'">История ников</a></div>';
    
    $usName = $adm->userName();
    $view .= $adm->showMessages();
    $view .= '<div class="phdr">История <b>'. $usName['nick'] .'</b></div>';
    
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $id = (int)$_POST['id'];
        $day = (int)$_POST['day'];
        $nick = htmlspecialchars(mb_substr(trim($_POST['name']), 0, 25));
        
        if (isset($_POST['edit'])) {
            if (mb_strlen($nick) > 1 && Johncms\Doc\NickAdmin::updateNames($id, $nick)) {
                $_SESSION['messages'] = '<h4 class="gmenu">'.
                    'Запись успешно изменена!</h4>';
            } else {
                $_SESSION['messages'] = '<h4 class="rmenu">'.
                    'Не допустимая длина ника!</h4>';
            }
        }
        
        if (isset($_POST['del'])) {
            if (Johncms\Doc\NickAdmin::delOneNick($id)) {
                $_SESSION['messages'] = '<h4 class="gmenu">Запись удалена!</h4>';
                $del = true;
            } else {
                $_SESSION['messages'] = '<h4 class="rmenu">'.
                    'Такого ника в истории не найдено!</h4>';
            }
        }
        
        if (isset($_POST['drop'])) {
            if (Johncms\Doc\NickAdmin::delAllNicks()) {
                $_SESSION['messages'] = '<h4 class="gmenu">Записи удалены!</h4>';
                $del = true;
            } else {
                $_SESSION['messages'] = '<h4 class="rmenu">'.
                    'Записей не найдено!</h4>';
            }
        }
        
        if (isset($_POST['off'])) {
            Johncms\Doc\NickAdmin::closeNick(Johncms\Doc\NickNames::ADM);
            $_SESSION['messages'] = '<h4 class="gmenu">Возможность смены ника '.
                'для пользователя <i>'. $usName['nick'] .'</i> отключена!</h4>';
        }
        
        if (isset($_POST['on'])) {
            Johncms\Doc\NickAdmin::closeNick();
            $_SESSION['messages'] = '<h4 class="gmenu">Возможность смены ника '.
                'для пользователя <i>'. $usName['nick'] .'</i> включена!</h4>';
        }
        
        if (isset($_POST['set'])) {
            if (!empty($day)) {
                Johncms\Doc\NickAdmin::setNickDays($day);
                $_SESSION['messages'] = '<h4 class="gmenu">Смена ника для '.
                    'пользователя <i>'. $usName['nick'] .'</i> будет доступна '.
                    'через <i>'. $day .'</i> дней!</h4>';
            } else {
                $_SESSION['messages'] = '<h4 class="rmenu">'.
                    'Не допустимое количество дней!</h4>';
            }
        }
        
        header('Location: admin.php?'. ($del ? 'user='. $adm->id : $uri));
    }
    
    if (!empty($_GET['edit'])) {
        $id = (int)$_GET['edit'];
        $nick = htmlspecialchars(mb_substr(trim($_POST['name']), 0, 25));
        
        if ($adm->close != Johncms\Doc\NickNames::OFF) {
            $val1 = 'Вкл. &radic;';
            $val2 = 'Выкл.';
            $opt1 = 'disabled';
            $opt2 = '';
        } else {
            $val1 = 'Вкл.';
            $val2 = 'Выкл. &radic;';
            $opt1 = '';
            $opt2 = 'disabled';
        }
        
        $txt = 'text';
        $sub = 'submit';
        $val3 = Johncms\Doc\NickAdmin::$ob->day;
        $form = 'admin.php?'. $uri;
        !$cnt ?: $view .= include 'inc/nick_edit.php';
    }
    
    $view .= $listNames;
} else {
    $view = '<h4 class="rmenu">Доступ ограничен!</h4>';
}

include 'inc/html.php';    

#-----------------------------#
require '../incfiles/end.php';
