<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 * Blogs By Aan Gabriel
 */

define('_IN_JOHNCMS', 1);

$id = isset($_REQUEST['id']) ? abs(intval($_REQUEST['id'])) : 0;
$act = isset($_GET['act']) ? trim($_GET['act']) : '';
//$mod = isset($_GET['mod']) ? trim($_GET['mod']) : '';
//$do = isset($_REQUEST['do']) ? trim($_REQUEST['do']) : false;


require('../system/bootstrap.php');
/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

$headmod = 'blogs'; 

//function timer
function timer($var = '') {
	global $waktu;
	if($var <= 0)
		return;
	if(86400 > $var) {
		if(3600 > $var) {
			if(60 > $var) {
				$time = $var;
				return $time . ' sec.';
			} else if(60 <= $var && (60 * 2) > $var) {
				return $time . ' min.';
			}
			$hours = (60 - ceil((3600 - $var) / 60));
			return $hours . ' hour.';
		} else if(3600 <= $var && (3600 * 2) > $var) {
			return $waktu . 'one hour.';
		}
		$days = (24 - ceil((86400 - $var) / 3600));
		return $days . ' days.';
	} else if(86400 <= $var && (86400 * 2) > $var) {
		return $waktu . 'one days.';
	}
	$days = ceil($var / 86400);
	return $days . 'day left.';
}

$mods = [
      'view',
      'comments'
];
//includes file (array)
if ($act && ($key = array_search($act, $mods)) !== false && file_exists('includes/' . $mods[$key] . '.php')) {
    require('includes/' . $mods[$key] . '.php');
} else {
	if($id) {
		$query = $db->query("SELECT * FROM `blogs_cat` WHERE `id`='$id' LIMIT 1;");
		if ($query->rowCount()) {
			$req1 = $query->fetch();
			
			$textl =  'Blogs | ' . htmlentities($req1['name'], ENT_QUOTES, 'UTF-8');
			require('../system/head.php');
			echo '<div class="phdr"><h3><a href="./">Blogs</a> | ' . htmlentities($req1['name'], ENT_QUOTES, 'UTF-8') . '</h3></div>';
			
			$total = $db->query("SELECT COUNT(*) FROM `blogs` WHERE `refid`='$id'".($systemUser->rights < 7 ? " AND `time`<='" . time() . "'":""))->fetchColumn();
			if($total) {
				if ($total > $kmess) 
					echo '<div class="topmenu">' . $tools->displayPagination('index.php?id=' . $id . '&amp;', $start, $total, $kmess) . '</div>';
				$req = $db->query("SELECT `id`, `name`, `text`, `time` FROM `blogs` WHERE `refid`='$id'".($systemUser->rights < 7 ? " AND `time`<='" . time() . "'":"")."
				ORDER BY `time` DESC LIMIT "
							  . $start . "," . $kmess);
				$i = 1;
				while (($row = $req->fetch()) !== false) {
					echo $i % 2 ? '<div class="list1">' : '<div class="list2">';
					if(file_exists(ROOT_PATH . 'blogs/icon/small_news_' . $row['id'] . '.jpg') !== false) {
						echo '<table cellpadding="0" cellspacing="0" width="100%"><tr><td width="32">';
						echo '<img style="margin: 0 0 -3px 0;border: 0px;" src="icon/small_news_' . $row['id'] . '.jpg" alt="" width="32" height="32"/>&#160;';
     					echo '</td><td>';
						echo '<a href="'.$config['homeurl'].'/blogs/' . $tools->Rewrite($row['name']) . '_' . $row['id'] . '.html">' . htmlentities($row['name'], ENT_QUOTES, 'UTF-8') . '</a> <br />(' . date('d.m.o / H:i', $row['time'] + $sdvigclock * 3600) . ')<br />';
						echo '</td></tr></table>';
					} else {
						echo '<a href="'.$config['homeurl'].'/blogs/' . $tools->Rewrite($row['name']) . '_' . $row['id'] . '.html">' . htmlentities($row['name'], ENT_QUOTES, 'UTF-8') . '</a> (' . date('d.m.o / H:i', $row['time'] + $sdvigclock * 3600) . ')<br />';
					}
					echo '<div class="sub"></div>';
					$text = $row['text'];
					if(mb_strlen($text) > 100) {
						$str = mb_substr($text, 0, 100);
						$text = mb_substr($str, 0, mb_strrpos($str, ' ')) . '...';
					}
					echo $tools->checkout($text, 2, 1);
					if($row['time'] > time())
						echo '<div class="sub func">Time For Show: ' . timer($row['time'] - time()) . '</div>';
					echo '</div>';
					++$i;
				}
				echo '<div class="phdr">Total: ' . $total . '</div>';
				if ($total > $kmess) {
					echo '<div class="topmenu">' . $tools->displayPagination('index.php?id=' . $id . '&amp;', $start, $total, $kmess) . '</div>';
					echo '<p><form action="index.php" method="get">
					<input type="hidden" name="id" value="' . $id . '"/>
					<input type="text" name="page" size="2"/>
					<input type="submit" value="To page &gt;&gt;"/></form></p>';
				}
			} else {
				echo '<div class="rmenu">Empty blogs</div>';
			}
		} else {
			echo '<div class="rmenu">Category does not exist</div>';
		}
	} else {
		$textl = 'Blogs';
		require_once('../system/head.php');
		echo '<div class="phdr"><h3>Blogs</h3></div>';

		$total = $db->query("SELECT COUNT(*) FROM `blogs_cat`")->fetchColumn();
		if($total) {
			if ($total > $kmess) 
				echo '<div class="topmenu">' . $tools->displayPagination('index.php?', $start, $total, $kmess) . '</div>';
			$req = $db->query("SELECT `blogs_cat`.`name`, `blogs_cat`.`id`
			FROM `blogs_cat`
			ORDER BY `blogs_cat`.`realid` ASC LIMIT "  . $start . "," . $kmess);
			$i = 1;
			while (($row = $req->fetch()) !== false) {
				$count = $db->query("SELECT COUNT(*) FROM `blogs` WHERE ".($systemUser->rights < 7 ? "`time`<='" . time() . "' AND ":"")."`refid`='{$row['id']}'")->fetchColumn();
				echo $i % 2 ? '<div class="list1">' : '<div class="list2">';
				if(file_exists(ROOT_PATH . 'blogs/icon/ico_cat_' . $row['id'] . '.jpg') !== false)
					echo '<img style="margin: 0 0 -3px 0;border: 0px;" src="icon/ico_cat_' . $row['id'] . '.jpg" alt="" width="16" height="16"/>&#160;';
				echo '<a href="index.php?id=' . $row['id'] . '">' . htmlentities($row['name'], ENT_QUOTES, 'UTF-8') . '</a> (' . $count . ')';
				echo '</div>';
				++$i;
			}
			echo '<div class="phdr">Total: ' . $total . '</div>';
			if ($total > $kmess) {
				echo '<div class="topmenu">' . $tools->displayPagination('index.php?', $start, $total, $kmess) . '</div>';
				echo '<p><form action="index.php" method="get">
				<input type="text" name="page" size="2"/>
				<input type="submit" value="To Page &gt;&gt;"/></form></p>';
			}
		} else {
			echo '<div class="rmenu">Empty Category</div>';
		}
	}
	if ($systemUser->id)
   echo '<div class="gmenu"><div class="func"><a href="write.php">Add Blogs</a></div></div>';
   if ($systemUser->rights >= 7)
   echo '<div class="rmenu"><div class="func"><a href="manage.php">Manage Blogs</a></div></div>';

}
require_once('../system/end.php');