<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Johncms\Api\BbcodeInterface $bbcode */
$bbcode = $container->get(Johncms\Api\BbcodeInterface::class);

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

echo $bbcode->buttons('', '');
// Справка по BBcode
        echo '<div class="mainblok"><div class="phdr"><a href="?"><b>' . _t('Information FAQ') . '</b></a> | ' . _t('bbCode Tags') . '</div>' .
             '<div class="menu"><p>' .
             '<table border="0" cellpadding="0" cellspadding="5"><tbody>
<tr><td align="left"><table border="2" cellpadding="2" cellspacing="1"><tbody>
<tr><th align="left"><h3>Bbcodes</h3></th><th align="left"><h3>Example</h3></th></tr>' .
             '<tr><td align="left">[b]...[/b]</td><td>' . $bbcode->tags('[b]Bold Text[/b]') . '</td></tr>' .
             '<tr><td align="left">[s]...[/s]</td><td>' . $bbcode->tags('[s]Strike Text[/s]') . '</td></tr>' .
             '<tr><td align="left">[u]...[/u]</td><td>' . $bbcode->tags('[u]Underline Text[/u]') . '</td></tr>' .
             '<tr><td align="left">[i]...[/i]</td><td>' . $bbcode->tags('[i]Italic Text[/i]') . '</td></tr>' .
             '<tr><td align="left">[red]...[/red]</td><td>' . $bbcode->tags('[red]Red Text[/red]') . '</td></tr>' .
             '<tr><td align="left">[blue]...[/blue]</td><td>' . $bbcode->tags('[blue]Blue Text[/blue]') . '</td></tr>' .
             '<tr><td align="left">[green]...[/green]</td><td>' . $bbcode->tags('[green]Green Text[/green]') . '</td></tr>' .
             '<tr><td align="left">[marquee]...[/marquee]</td><td>' . $bbcode->tags('[marquee]Marquee Text[/marquee]') . '</td></tr>' .
             '<tr><td align="left">[marquee=up|down|left|right|alt]...[/marquee]</td><td>' . $bbcode->tags('[marquee=up]Marquee Text Up[/marquee]') . '</td></tr>' .
             '<tr><td align="left">[blink]...[/blink]</td><td>' . $bbcode->tags('[blink]Blinking Text[/blink]') . '</td></tr>' .
             '<tr><td align="left">[textarea]...[/textarea]</td><td>' . $bbcode->tags('[textarea]TextArea Code[/textarea]') . '</td></tr>' .
             '<tr><td align="left">[bd]...[/bd]</td><td>' . $bbcode->tags('[bd]Text Border[/bd]') . '</td></tr>' .
             '<tr><td align="left">[bg=]...[/bg]</td><td>' . $bbcode->tags('[bg=#000099]Background Color[/bg]') . '</td></tr>' .
             '<tr><td align="left">[font=arial|serif|veranda]...[/font]</td><td>' . $bbcode->tags('[font=Arial]Font Type[/font]') . '</td></tr>' .
             '<tr><td align="left">[code=php|css|xml|html|js|sql]...[/code]</td><td>' . $bbcode->tags('[code=php]PHP CODE[/code]') . '</td></tr>' .
             '<tr><td align="left">[align=left|right|center]...[/code]</td><td>' . $bbcode->tags('[align=right]Text Align[/align]') . '</td></tr>' .
             '<tr><td align="left">[img]Image link without <b>http://</b> included[/img]</td><td>' . $bbcode->tags('[img]www.johncms.com/images/logo.gif[/img]') . '</td></tr>' .
             '<tr><td align="left">[img=widthxheight]Image URL without <b>http://</b>[/img]</td><td>' . $bbcode->tags('[img=70x40]www.johncms.com/images/logo.gif[/img]') . '</td></tr>' .
             '<tr><td align="left">[gt]...[/gt]</td><td>' . $bbcode->tags('[gt]Rainbow Text[/gt]') . '</td></tr>' .
             '<tr><td align="left">[button]...[/button]</td><td>' . $bbcode->tags('[button]Button Div[/button]') . '</td></tr>' .
             '<tr><td align="left">[osh]...[/osh]</td><td>' . $bbcode->tags('[osh]Orange Shadow[/osh]') . '</td></tr>' .
             '<tr><td align="left">[rsh]...[/rsh]</td><td>' . $bbcode->tags('[rsh]Red Shadow[/rsh]') . '</td></tr>' .
             '<tr><td align="left">[random]...[/random]</td><td>' . $bbcode->tags('[random]Randomize Text Effect[/random]') . '</td></tr>' .
             '<tr><td align="left">[hide]...[/hide]</td><td>' . $bbcode->tags('[hide]Only Members Can View[/hide]') . '</td></tr>' .
             '<tr><td align="left">[big]...[/big]</td><td>' . $bbcode->tags('[big]Big Text[/big]') . '</td></tr>' .
             '<tr><td align="left">[small]...[/small]</td><td>' . $bbcode->tags('[small]Small Text[/small]') . '</td></tr>' .
             '<tr><td align="left">[color=#COLOR_CODE]...[/color]</td><td>' . $bbcode->tags('[color=#990099]Custom Colored Text[/color]') . '</td></tr>' .
             '<tr><td align="left">[sh]...[/sh]</td><td>' . $bbcode->tags('[sh]Shadow Text[/sh]') . '</td></tr>' .
             '<tr><td align="left">[user=ID]...[/user]</td><td>' . $bbcode->tags('[user=1]Link to User Profile[/user]') . '</td></tr>' .
             '<tr><td align="left">[forum=ID_Number]...[/forum]</td><td>' . $bbcode->tags('[forum=1]Forum Link[/forum]') . '</td></tr>' .
             '<tr><td align="left">[quote]...[/quote]</td><td>' . $bbcode->tags('[quote]Quote Text[/quote]') . '</td></tr>' .
             '<tr><td align="left">[spoiler]...[/spoiler]</td><td>' . $bbcode->tags('[spoiler=Click To See Full Text]Spoiler Text[/spoiler]') . '</td></tr>' .
             '<tr><td align="left">[sup]...[/sup]</td><td>' . $bbcode->tags('[sup]Superscript Text[/sup]') . '</td></tr>' .
             '<tr><td align="left">[url=http://site_url]...[/url]</td><td>' . $bbcode->tags('[url=http://johncms.com]Click to visit[/url]') . '</td></tr>' .
             '<tr><td align="left">[sub]...[/sub]</td><td>' . $bbcode->tags('[sub]Subscript Text[/sub]') . '</td></tr>' .
            '<tr><td align="left" valign="top">[*]...[/*]</td><td><span class="bblist">' . _t('Bullet List') . '</span></td></tr>' .
             '<tr><td align="left">[hr]...</td><td>' . $bbcode->tags('[hr]') . '</td></tr>' .
             '<tr><td align="left">[size=xx-small|x-small|small|medium|large|x-large|xx-large]...[/size]</td><td>' . $bbcode->tags('[size=medium]Text Size[/size]') . '</td></tr>' .
             '<tr><td align="left">[soundcloud]...[/soundcloud]</td><td>' . $bbcode->tags('[soundcloud]http://soundcloud.com[/soundcloud]') . '</td></tr>' .
             '<tr><td align="left">[youtube]Input YouTube Link[/youtube]</td><td>' . $bbcode->tags('[youtube]http://youtube.com[/youtube]') . '</td></tr>' .
             '<tr><td align="left">[img=...]</td><td>To insert an image to a post, you need to upload it to our server, to do this, use' .  ' <a href="'.$config['homeurl'].'/system/plugin/BbcodeIMG.php" class="green"><b>image uploader</b></a> ' .  'after uploading an image you will get an image code, which will be able to insert it into the post message..</td></tr></tbody></table></td></tr>
</tbody></table>';
echo '</p></div>';
echo '<div class="phdr"><a href="' . $_SESSION['ref'] . '">' . _t('Back') . '</a></div>';