<?php
# Mod JohnCMS — GeoIP Users
# © 2017 – by Sitego
# Site: http://playlist24.ru/

/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2017 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

############## Начало настроек ##############
/*
• Ключ API должен быть только один, в зависимости от того, какую карту вы решили использовать, второй ключ не заполняйте.
• Если заполнить оба ключа API или не заполнить ни один, то скрипт будет выводить только данные, без карты.
• Получение ключей здесь 
*/
$api_key_js		= ''; // Ключ API для ИНТЕРАКТИВНОЙ КАРТЫ с маркером
$api_key_img	= ''; // Ключ API для КАРТЫ КАРТИНКИ JPG с маркером

############# Конец настроек ################


############# Дальше ничего не трогать ######
defined('_IN_JOHNADM') or die('Error: restricted access');

$lng = array_merge($lng, core::load_lng('geoip'));
$ip = isset($_GET['ip']) ? trim($_GET['ip']) : false;

// в каком виде мы получим данные
$typeData = 'xml';

// для каких языков по умолчанию информация на русском
if (core::$user_set['lng'] == 'ru' || core::$user_set['lng'] == 'be' || core::$user_set['lng'] == 'uk')
	$ru = 'ru';

echo'<div class="phdr"><b>'.$lng['geoip_location'].'</b></div>';

// формируем URL для запроса
$url = 'http://ip-api.com/'.$typeData.'/'.$ip.'?fields=lat,lon,country,countryCode,regionName,city,timezone,isp,org,reverse,query&lang='.$ru;

// делаем запрос к API
$data = @file_get_contents($url);

// если данные получили
if($data){
    // декодируем их
    $dataDecode = new SimpleXMLElement($data);
     
    // выводим данные
	if($dataDecode->query != '')		echo '<div class="menu"><b>'.$lng['geoip_ip'].':</b> '.$dataDecode->query.'</div>';
	if($dataDecode->country != ''){		echo '<div class="menu"><b>'.$lng['geoip_country'].':</b> '.$dataDecode->country;
		
		if($dataDecode->countryCode){
			echo ' <img style="height:1em;position:relative;top:0.15em" src="/images/flags_country/'.$dataDecode->countryCode.'.png" alt="('.$dataDecode->countryCode.')"></div>';
		}else{
			echo ' <img style="height:1em;position:relative;top:0.15em" src="/images/flags_country/!unknown.png" alt="(нет иконки)"></div>';
		}
		
	}

	if($dataDecode->regionName != '')	echo '<div class="menu"><b>'.$lng['geoip_region'].':</b> '.$dataDecode->regionName.'</div>';
	if($dataDecode->city != '')			echo '<div class="menu"><b>'.$lng['geoip_city'].':</b> '.$dataDecode->city.'</div>';
	
	if($dataDecode->timezone != ''){
		date_default_timezone_set($dataDecode->timezone);
		echo '<div class="menu"><b>'.$lng['geoip_time'].':</b> '.date('H:i ч.').'</div>';
		echo '<div class="menu"><b>'.$lng['geoip_date'].':</b> '.date('d/m/Y г.').'</div>';
	}
	
	if($dataDecode->isp != '')			echo '<div class="menu"><b>'.$lng['geoip_isp'].':</b> '.$dataDecode->isp.'</div>';
	if($dataDecode->org != '')			echo '<div class="menu"><b>'.$lng['geoip_org'].':</b> '.$dataDecode->org.'</div>';
	if($dataDecode->reverse != '')		echo '<div class="menu"><b>'.$lng['geoip_reverse'].':</b> '.$dataDecode->reverse.'</div>';

	$lat = $dataDecode->lat;
	$lon = $dataDecode->lon;

if($api_key_img !== '' && $api_key_js == ''){
	echo'<div class="list2"><img style="max-width:100%;border:#ccc solid 2px" src="http://maps.googleapis.com/maps/api/staticmap?key='.$api_key_img.'&center='.$lat.','.$lon.'&zoom=10&format=jpg&size=560x600&language=ru&path=color:0x3af1ad30|weight:116|'.$lat.','.$lon.'|'.$lat.','.$lon.'1" alt="Нет карты"></div>';
}
elseif($api_key_img == '' && $api_key_js !== ''){
?>

<div class="list2">
    <div id="map" style="height:380px;max-weight:100%"></div>
		<script>
			function initMap() {
			var myLatlng = {lat: <?=$lat?>, lng: <?=$lon?>};
			
			var map = new google.maps.Map(document.getElementById('map'), {
				zoom: 7,
				center: myLatlng
			});
			
			var marker = new google.maps.Marker({
				position: myLatlng,
				map: map,
				title: 'Click to zoom'
			});
			
			map.addListener('center_changed', function() {
				window.setTimeout(function() {
				map.panTo(marker.getPosition());
				}, 3000);
			});
			
			marker.addListener('click', function() {
				map.setZoom(16);
				map.setCenter(marker.getPosition());
			});
			}
		</script>
    <script src="https://maps.googleapis.com/maps/api/js?key=<?=$api_key_js?>&signed_in=true&callback=initMap" async defer></script>
</div>

<?php
}
}else{
    echo '<div class="rmenu">Сервер определения местоположения временно не доступен!</div>';
}