<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

/** @var Interop\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var Johncms\User $systemUser */
$systemUser = $container->get(Johncms\User::class);

/** @var Johncms\Config $config */
$config = $container->get(Johncms\Config::class);

/** @var Johncms\Counters $counters */
$counters = $container->get('counters');

$mp = new Johncms\NewsWidget();

// Блок информации
echo '<div class="phdr"><b>' . _t('Notice Board', 'system') . '</b></div>';
echo $mp->news;
echo '<div class="menu"><a href="/news">' . _t('News archive', 'system') . '</a> (' . $mp->newscount . ')</div>' .
    '<div class="menu"><a href="help/">' . _t('Information, FAQ', 'system') . '</a></div>';

// Вывод 20 последних тем (для незарегистрированных)
    echo '<div class="phdr"><a href="index.php"><b>Latest Forum Updates</b></a></div>';
    $req = $db->query("SELECT * FROM `forum` WHERE `type` = 't' AND `close` != '1' ORDER BY `time` DESC LIMIT $start, $kmess");

    if ($req->rowCount()) {
        for ($i = 0; $res = $req->fetch(); ++$i) {
            $razd = $db->query("SELECT `id`, `refid`, `text` FROM `forum` WHERE type='r' AND id='" . $res['refid'] . "' LIMIT 1")->fetch();
            $frm = $db->query("SELECT `id`, `refid`, `text` FROM `forum` WHERE type='f' AND id='" . $razd['refid'] . "' LIMIT 1")->fetch();
            $nikuser = $db->query("SELECT `from`, `time` FROM `forum` WHERE `type` = 'm' AND `close` != '1' AND `refid` = '" . $res['id'] . "'ORDER BY `time` DESC");
            $colmes1 = $nikuser->rowCount();
            $cpg = ceil($colmes1 / $kmess);
            $nam = $nikuser->fetch();
            echo $i % 2 ? '<div class="list2">' : '<div class="list1">';

// Значки
                    
                    echo '<div name="h_post"><a href="/forum/index.php?id=' . $res['id'] . ($cpg > 1 && $set_forum['upfp'] && $set_forum['postclip'] ? '&amp;clip' : '') . ($set_forum['upfp'] && $cpg > 1 ? '&amp;page=' . $cpg : '') . '">' . (empty($res['text']) ? '-----' : $res['text']) .
                        '</a></div>&#160;[' . $colmes1 . ']';



            if ($cpg > 1) {
                echo '&#160;<a href="index.php?id=' . $res['id'] . '&amp;clip&amp;page=' . $cpg . '">&gt;&gt;</a>';
            }

            echo '<br><div class="sub"><a href="/forum/index.php?id=' . $razd['id'] . '">' . $frm['text'] . '&#160;/&#160;' . $razd['text'] . '</a><br />';
            echo $res['from'];

            if (!empty($nam['from'])) {
                echo '&#160;/&#160;' . $nam['from'];
            }

            echo ' <span class="gray">' . date("d.m.y / H:i", $nam['time']) . '</span>';
            echo '</div></div>';
        
}
            } else {
                echo '<div class="menu"><p>' . _t('The list is empty') . '</p></div>';
            }
 $total = $container->get('counters')->forumNew();
            echo '<div class="phdr">' . _t('Total') . ': ' . $total . '</div>';

            echo '<p><form action="index.php" method="get">' .
                    '<input type="hidden" name="act" value="new"/>' .
                    '<input type="text" name="page" size="2"/>' .
                    '<input type="submit" value="' . _t('Jump To Page') . ' &gt;&gt;"/>' .
                    '</form></p></div><script type="text/javascript" src="http://tipstunes.wapamp.com/javascript/th_update.js"></script>';
            
            
           


////////////////////////////////////////////////////////////
// Блок общения                                           //
////////////////////////////////////////////////////////////



echo '<div class="phdr"><b>MainMenu</b></div>';

// Ссылка на гостевую
if ($config->mod_guest || $systemUser->rights >= 7) {
    echo '<div class="menu"><a href="guestbook/index.php">' . _t('Guestbook', 'system') . '</a> (98' . $counters->guestbook() . ')</div>';
}

// Ссылка на Форум
if ($config->mod_forum || $systemUser->rights >= 7) {
    echo '<div class="menu"><a href="forum/">' . _t('Forum', 'system') . '</a> (3' . $counters->forum() . ')</div>';
}

////////////////////////////////////////////////////////////
// Блок полезного                                         //
////////////////////////////////////////////////////////////


// Ссылка на загрузки
if ($config->mod_down || $systemUser->rights >= 7) {
    echo '<div class="menu"><a href="downloads/">' . _t('Downloads', 'system') . '</a> (40' . $counters->downloads() . ')</div>';
}

////////////////////////////////////////////////////////////
// Блок Сообщества                                        //
////////////////////////////////////////////////////////////
if ($systemUser->isValid() || $config->active) {
    
      echo '<div class="menu"><a href="users/index.php">' . _t('Users', 'system') . '</a> (1' . $counters->users() . ')</div>' .
        '<div class="menu"><a href="album/index.php">' . _t('Photo Albums', 'system') . '</a> (67' . $counters->album() . ')</div>';
}



// latest users


$total = $db->query("SELECT COUNT(*) FROM `users` WHERE `preg` = 1")->fetchColumn();
echo '<div class="phdr"><b>New Users</b></div>';
$req = $db->query("SELECT `id`, `name`, `sex`, `lastdate`, `datereg`, `status`, `rights`, `ip`, `browser`, `rights` FROM `users` WHERE `preg` = 1 ORDER BY `datereg` DESC LIMIT 5");

for ($i = 0; ($res = $req->fetch()) !== false; $i++) {
    echo $i % 2 ? '<div class="list2">' : '<div class="list1">';
    echo $tools->displayUser($res) . '</div>';
}


echo '<div class="phdr"><a href="http://fb.com/dearmanbinrahman">Facebook</a></div>';