<?php
require_once(__DIR__ . '/core.php');

/**
 * @return mysqli Соединение с базой дайнных.
 */
function getDatabase(){
  static $database; // Кеш соединения

  $config = getConfig()['database'];

  if(is_null($database)){
    $database = mysqli_connect($config['host'], $config['user'], $config['password'], $config['dbname']);
    mysqli_set_charset($database, $config['charset']);
  }

  return $database;
}

function buildSelectSql($table, array $fields = ['*'], $where = null , array $order = [], $limit = null, $offset = null){
  $selectSql = 'SELECT ';
  $selectSql .= implode($fields);
  $selectSql .= ' FROM ' . (string) $table;
  if(!is_null($where)){
    $selectSql .= ' WHERE ' . (string) $where;
  }
  if(count($order)){
    $selectSql .= ' ORDER BY ' . implode(',', $order);
  }
  if(!is_null($limit)){
    $selectSql .= ' LIMIT ' . (int) $limit;
  }
  if(!is_null($offset)){
    $selectSql .= ' OFFSET ' . (int) $offset;
  }

  return $selectSql;
}
