<?php
require_once(__DIR__ . '/core.php');
require(__DIR__ . '/model.php');
require(__DIR__ . '/view.php');

/**
 * @param string $name Имя параметра.
 * @param mixed $default [optional] Значение, возвращаемое по умолчанию.
 *
 * @return mixed Значение параметра запроса.
 */
function getQueryParam($name, $default = null){
  return isset($_GET[$name])? $_GET[$name] : $default;
}

/**
 * @param int $limit Максимальное число записей на странице.
 *
 * @return int Количество записей, которые следует пропустить для текущей 
 * страницы.
 */
function getOffsetFromPage($limit){
  $page = (int) getQueryParam('page', 1);
  return ($page - 1) * $limit;
}
