<?php

class Kupload {
    
    private $dir;
    
    private $tmpdir;
    
    private $filestorage;
    
    public function __construct($dir) {
        $this->dir = $dir;
        $this->checkDir($dir);
        $res = $this->addtemp($this->checker());
        $this->filestorage = new KfileStorage($this->dir);
        $this->filestorage->add($res);
    }
    
    public function checkDir($dir) {
        if (!is_dir($dir)) {
            mkdir($dir . DIRECTORY_SEPARATOR . 'tmp', 0750, true);
        }
        $this->tmpdir = realpath($this->dir . DIRECTORY_SEPARATOR . 'tmp');
    }
    
    public function addtemp($array) {
        if (count($array) > 0) {
            $result = array();
            foreach($array as $name => $file) {
                $filename = $this->tmpdir . DIRECTORY_SEPARATOR . $this->uniqid() . $name;
                file_put_contents($filename, file_get_contents($file));
                $result[] = new Kfile($filename);
            }
            
            return $result;
        } else {
            return false;
        }
    }
    
    public function uniqid() {
        return substr(md5(uniqid(time())), 0, 8);
    }
    
    public function checker() {
        $result = array();
        if (count($_FILES) > 0) {
            foreach($_FILES as $key => $name) {
                if (is_array($name['tmp_name'])) {
                    foreach($name as $k => $file) {
                        foreach($file as $data) {
                            if (!empty($data)) {
                                $result[$k][] = $data;
                            }
                        }
                    }
                } else {
                    if (!empty($name['tmp_name'])) {
                        $result['name'][] = $name['name'];
                        $result['type'][] = $name['type'];
                        $result['tmp_name'][] = $name['tmp_name'];
                        $result['size'][] = $name['size'];
                    }
                }
            }
            
            return array_combine($result['name'], $result['tmp_name']);
        }
        
        return $result;
    }
}