<?php

class Kfile extends SplFileInfo {
    
    private $size;
    
    private $ext;
    
    private $md5;
    
    public function __construct($file) {
        parent::__construct($file);
        $this->ext = $this->getExtension();
        $this->size = $this->getSize();
        $this->md5 = $this->generatehash();
    }
    
    public function data() {
        return array('md5' => $this->md5, 'size' => $this->size, 'ext' => $this->ext, 'path' => $this->getRealPath());
    }
    
    public function generatehash() {
        return md5_file($this->getRealPath());
    }
}