<?php

const _IN_JOHNCMS = 1;
$dir = explode(DIRECTORY_SEPARATOR, __DIR__);
$headmod = end($dir); # автоопределение папки
$textl = 'Новые заявки - Банковский депозит';
require_once '../../incfiles/core.php';
require_once '../../incfiles/head.php';
functions::headmod(__FILE__, $headmod, $textl);
#-------------------------------------------#

if ($rights < 9) {
    $err[] = 'Не достаточно прав для выполнения операции!';
    echo functions::display_error($err, '<a href="'. $home .'">На главную</a>');
    require_once '../../incfiles/end.php';
    exit;
}

// Вывод уведомлений о действиях на странице
if (!empty($_SESSION['ok'])) {
    echo $_SESSION['ok'];
    unset($_SESSION['ok']);
}

// Массив уведомлений
$notice = Bank::notification();

if (!empty($notice)) {
    echo '<div class="phdr"><b>'. $textl .'</b></div>';
    
    !isset($_GET['list']) ?: $list = functions::checkin($_GET['list']);
    
    switch ($list) {
        case 'clients':
            echo '<div class="bmenu"><div class="topmenu">Перечень заявок</div>';
            foreach ($notice as $i => $entry) {
                echo ($i % 2 ? '<div class="list2">' : '<div class="list1">').
                    ++$i .'. Заявка от <a href="'. $home .'/users/profile.php?user='. 
                    $entry['id'] .'"><b>'. $entry['name'] .'</b></a> на депозит в размере <b>$ '.
                    $entry['bank_sum'] .'</b><br /><a style="text-decoration:none;" href="'.
                    '?list=open&investor='. $entry['id']. '"><span style="color:red; font-size:9px; '.
                    'padding:0 0 0 15px;">&laquo;Обработка&raquo;</span></a></div>';
            }
            echo '</div>';
            break;
            
        case 'open':
            if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                $id = abs(intval($_POST['id']));
                $sum = abs(intval($_POST['sum']));
                $pct = abs(intval($_POST['pct']));
                $time = time();
                $comm = functions::checkin($_POST['comm']);
                
                if (isset($_POST['subm_yes'])) {
                    if (empty($pct)) {
                        $ok = 'Необходимо установить процент!';
                        $_SESSION['ok'] = '<div class="alarm"><b>'. $ok .'</b></div>';
                        header('Location: '. $home .'/bank/inc/list.php?list=open&investor='. $id);
                        exit;                    
                    }
                    // Открываем депозит
                    $on = ' Ваша заявка принята!';
                    if (Bank::processing(2, $sum, $comm.$on, 2, $id, $time, $pct, 1)) {
                        // Разовый процент для админа, открывшего депозит
                        $balans = $pct * ($sum / 100);
                        Bank::percentAdmin($balans, $user_id);
                        $ok = 'Депозит успешно открыт!';
                    }
                }
                
                if (isset($_POST['subm_not'])) {
                    $no = ' Ваша заявка отклонена!';
                    !Bank::processing(0, 0, $comm.$no, 2, $id) ?: $ok = 'Заявка удалена!';
                }
                // Проверяем, есть ли ещё заявки
                if (Bank::cnt(1) > 0) {
                    $_SESSION['ok'] = '<div class="gmenu"><b>'. $ok .'</b></div>';
                    header('Location: '. $home .'/bank/inc/list.php?list=clients');
                    exit;
                } else {
                    $_SESSION['ok'] = '<div class="gmenu"><b>'. $ok .' Заявок нет!</b></div>';
                    header('Location: '. $home .'/bank/inc/admin.php');
                    exit;
                }            
            }
            
            if (!empty($_GET['investor'])) {
                $pct = 0;
                $investor = abs(intval($_GET['investor']));
                // Массив данных вкладчика
                $client = Bank::status($investor);
                $txt = 'Уважаемый '. $client['name'] .'! ';

                echo 
                    '<div class="bmenu">'.
                        '<form action="'. $home .'/bank/inc/list.php?list=open" method="post">'.
                            '<input type="hidden" name="id" value="'. $client['id'] .'" />'.
                            '<div class="menu">'.
                                'Сумма депозита $ '.
                                '<input style="margin-left:5px;" size="7" type="text" name="sum" value="'. 
                                    $client['bank_sum'] .'" />'.
                            '</div>'.
                            '<div class="menu">'.
                                'Ежемесячный % '.
                                '<input style="margin-left:14px;" size="7" type="text" name="pct" value="'. 
                                    $pct .'" />'.
                            '</div>'.
                            '<div class="menu">'.
                                'Текст уведомления:<br />'.
                                '<textarea style="width:370px; height:50px;" name="comm">'. 
                                    $txt .'</textarea>'.
                            '</div><hr />'.
                            '<div class="gmenu">'.
                                '<input type="submit" name="subm_yes" value="Открыть депозит" />'.
                                '<input type="submit" name="subm_not" value="Отказать" />'.
                            '</div>'.
                        '</form>'.
                    '</div>';
            }
            break;
    }
} else {
    header('Location: '. $home .'/bank/inc/admin.php');
}

#-------------------------------------------#
require_once '../../incfiles/end.php';
