<?php

const _IN_JOHNCMS = 1;
$dir = explode(DIRECTORY_SEPARATOR, __DIR__);
$headmod = end($dir); # автоопределение папки
$textl = 'Админка - Банковский депозит';
require_once '../../incfiles/core.php';
require_once '../../incfiles/head.php';
functions::headmod(__FILE__, $headmod, $textl);
#-------------------------------------------#

if ($rights < 9) {
    $err[] = 'Не достаточно прав для выполнения операции!';
    echo functions::display_error($err, '<a href="'. $home .'">На главную</a>');
    require_once '../../incfiles/end.php';
    exit;
}

// Вывод уведомлений о действиях на странице
if (!empty($_SESSION['ok'])) {
    echo $_SESSION['ok'];
    unset($_SESSION['ok']);
}

// Ежедневное увеличение депозита
if (Bank::percentIncrease($user_id)) {
    header('Location: '. $home .'/bank/inc/admin.php');
    exit;
}

echo '<div class="phdr"><b>'. $textl .'</b></div>';

!isset($_GET['ctrl']) ?: $ctrl = functions::checkin($_GET['ctrl']);

switch ($ctrl) {
    case 'out':
        // Перевод вклада с процентами на балланс
        empty($_GET['id']) ?: $id = abs(intval($_GET['id']));
        
        if (!empty($id)) {
            $client = Bank::status($id);
            if ($client['bank_sts'] >= 2 && !empty($client['bank_max']) &&
                $client['id'] == $id && Bank::processing(0, 0, '', 0, $id, 0, 0, 3))
            {
                $_SESSION['ok'] = '<div class="gmenu"><b>Перевод клиенту '. 
                    $client['name'] .' успешно выполнен!</b></div>';
            } else {
                $_SESSION['ok'] = '<div class="alarm">'.
                    '<b>При нулевом доходе вывод средств не возможен!</b></div>';
            }
        } else {
            $_SESSION['ok'] = '<div class="alarm"><b>Клиент не найден!</b></div>';
        }
        
        header('Location: '. $home .'/bank/inc/admin.php');
        exit;
        
    case 'del':
        // Зыкрываем депозит
        empty($_GET['id']) ?: $id = abs(intval($_GET['id']));

        if (!empty($id)) {
            $client = Bank::status($id);
            if ($client['bank_sts'] >= 2 && $client['id'] == $id && 
                Bank::processing(0, 0, '', 0, $id, 0, 0, 2))
            { 
                $_SESSION['ok'] = '<div class="gmenu"><b>Депозит закрыт!</b></div>';
            } else {
                $_SESSION['ok'] = '<div class="alarm"><b>Удаление не возможно!</b></div>';
            }
        }
        
        header('Location: '. $home .'/bank/inc/admin.php');
        exit;
    
    default:
        $clients = Bank::status();
        if (!empty($clients)) { ?>
            <div class="bmenu"><div class="topmenu">Список клиентов</div>
            <table style="width:100%; text-align:center;">
                <tr>
                    <th>№</th>
                    <th>Имя</th>
                    <th>Баланс</th>
                    <th>Вклад</th>
                    <th>%</th>
                    <th>Дата</th>
                    <th>К-во дней</th>
                    <th>Доход ($)</th>
                    <th>Операции</th>
                </tr>
                <? foreach ($clients as $i => $clt) { ?>
                    <?=($i % 2 ? '<tr class="list2">' : '<tr class="list1">') ?>
                    <td><?=++$i?></td>
                    <td><a href="<?=$home?>/users/profile.php?user=<?=$clt['id']?>"><?=$clt['name']?></a></td>
                    <td><?=$clt['balans']?></td>
                    <td><?=$clt['bank_sum']?></td>
                    <td><?=$clt['bank_pct']?></td>
                    <td><?=($clt['bank_time'] > 0 ? functions::display_date($clt['bank_time']) : '~')?></td>
                    <td>
                        <?php
                        // Ежедневное увеличение депозита
                        if (Bank::percentIncrease($clt['id'])) {
                            header('Location: '. $home .'/bank/inc/admin.php');
                            exit;
                        }
                        
                        if ($clt['bank_time'] > 0) {
                            $depTerm = date('t');
                            $days = intval((time() - $clt['bank_time']) / (3600 * 24));
                            $depEnd = $depTerm - $days;
                            // Автовывод средств, если истёк срок депозита
                            if ($depEnd < 1) {
                                header('Location: '. $home .'/bank/inc/admin.php?ctrl=out&id='. $clt['id']);
                                exit;
                            }
                            echo $depEnd;
                        } else {
                            echo '<a href="list.php?list=open&investor='. $clt['id'] .'">'.
                                '<span style="color:red"><b>New</b></span></a>';
                        } ?>
                    </td>
                    <td><?=$clt['bank_max']?></td>
                    <td>
                        <? if ($clt['bank_sts'] >= 2) { ?>
                            <a href="?ctrl=out&id=<?=$clt['id']?>"><span style="color:green">
                            <b>Out</b></span></a> | <a href="?ctrl=del&id=<?=$clt['id']?>">
                            <span style="color:red"><b>Del</b></span></a>
                        <? } else { ?>
                            <span style="color:grey"><b>Out</b></span> | <span style="color:grey">
                            <b>Del</b></span>
                        <? } ?>
                    </td>
                <? } ?>
                <?='</tr>'?>
            </table>
            </div>
            
            <?php
        
        } else {
            echo '<div class="menu">Список пуст!</div>';
        }
}

#-------------------------------------------#
require_once '../../incfiles/end.php';
