<?php

/**
* Db
* Класс эмуляции PDO для обычного mysql
* создан для дальнейшей совместимости, просто удалив файл и подключить к работе PDO , ничего не должно поломаться
* собраны основные методы (не все) , при желании можно дописать, при нужной необходимости
* @author Koenig <http://johncms.com/users/profile.php?user=6565>
* @version 1.0
*/

class Db {
    
    private $sql = false;
    
    private $result = false;
    
    protected static $instance = null;
    
    public final static function getInstance() {
        if (null === static::$instance) {
            static::$instance = new static();
        }
        
        return static::$instance;
    }
    
    protected function __construct(){}
    
    protected function __clone(){}

    protected function __wakeup(){}
    
    #private function isFetch() {
    #    return preg_match('/select/i', $this->sql) ? true : false;
    #}
    
    public function prepare($sql) {
        $this->sql = trim($sql);
        
        return $this;
    }
    
    public function query($sql) {
        $this->sql = trim($sql);
        $this->result = mysql_query($sql);
        
        return $this;
    }
    
    public function fetch() {
        return mysql_fetch_assoc($this->result);
    }
    
    public function fetchColumn($column_number = 0) {
        $res = $this->fetch();
        
        return $res[$column_number];
    }
    
    public function fetchObject($class = 'stdClass', $args = array()) {
        return mysql_fetch_object($this->result, $class, $args);
    }
    
    public function rowCount() {
        #echo '<pre>' . print_r($this, 1) . '</pre>';
        $res = mysql_fetch_row(mysql_query($this->sql));
        
        return $res[0];
    }
    
    public function fetchAll() {
        $array = array();
        while($res = $this->fetch()) {
            $array[] = $res;
        }
        
        return $array;
    }
    
    public function execute($args = array()) {
        if (sizeof($args)) {
            $args = $this->esc($args);
            $parts = preg_split('#(\?)#u', $this->sql, null, PREG_SPLIT_DELIM_CAPTURE);
            $cnt = sizeof($parts);
            $cntargs = sizeof($args);
            $cntparts = substr_count($this->sql, '?'); 
        
            if ($cntargs != $cntparts) {
                throw new InvalidArgumentException('Wrong number of arguments. Parts = ' . $cntparts . ', Args = ' . $cntargs);
            }
        
            $sql = '';
            for($i = 0; $i < $cnt; $i++) {
                $sql .= (($i % 2) == 0 ? $parts[$i] : str_replace('?', $args[($i/2)], $parts[$i]));
            }
            $sql .= ';';
            
            $this->sql = $sql;
            $res = mysql_query($sql);
        } else {
            $res = mysql_query($this->sql);
        }
        
        #$this->result = $this->isFetch() ? $res : false;
        $this->result = $res;
                
        return $this;
    }
    
    public function lastInsertId() {
        $id = $this->query('SELECT LAST_INSERT_ID()')->fetchColumn();
        
        return $id; 
    }
    
    private function esc($data) {
        if (!is_array($data)) {
            $data = is_int($data) ? $data : '"' . mysql_real_escape_string($data) . '"';
        } else {
            $data = array_map(array($this, 'esc'), $data);
        }
        
        return $data;
    }
    
    public function quote($str) {
        return $this->esc($str);
    }
    
    public function exec($sql) {
        $res = mysql_query($sql);
        
        return mysql_affected_rows($res);
    }
}