<?php


$_SESSION['lang'] = (isset($_REQUEST['lang']) && $_REQUEST['lang'] == 'en') ? 'en' : 'ru';


function lang($key)
{
    $ru = array(
        'hello' => 'Приветствуем!',
        'first_text' => 'Добро пожаловать в мастер установки JohnCMS mod by Simba <br>Пройдите все шаги установщика и получите полноценный сайт.',
        'checking' => 'Проверка',
        'downloading' => 'Загрузка',
        'unpacking' => 'Распаковка',
        'installing' => 'Установка',
        'ending' => 'Завершение',
        'back' => 'Назад',
        'next' => 'Вперед',
        'language' => 'Язык',
        'recheck' => 'Проверить ещё раз',
        'loaded' => 'Загружено',
        'enabled' => 'Включено',
        'disabled' => 'Выключено',
        'not_loaded' => 'Не загружено',
        'current_value' => 'Текущее значение',
        'req_value' => 'Требуется',
        'step1title' => 'Проверка параметров сервера',
        'php_version' => 'Версия PHP',
        'php_version_help' => 'Требуется версия php не ниже рекомендуемой',
        'mysqli' => 'Работа с БД MySQLi',
        'mysqli_help' => 'Для работы с БД требуется установленное расширение MySQLi',
        'gd' => 'Наличие бибилиотеки GD',
        'gd_help' => 'Бибилиотека GD используется для работы с изображениями и должна быть установлена на сервере',
        'zlib' => 'Наличие бибилиотеки zlib',
        'mbstring' => 'Наличие бибилиотеки mbstring',
        'mb_internal_encoding' => 'Кодировка по-умолчанию',
        'func_overload' => 'Механизм перезагрузки функций mbstring.func_overload',
        'func_overload_help' => 'Параметр <b>mbstring.func_overload</b> должен быть равен 0',
        'short_open_tag' => 'Параметр short_open_tag',
        'register_globals' => 'Параметр register_globals',
        'mail' => 'Поддержка функции mail',
        'mail_help' => 'Для отправки почты с помощью скриптов должна быть включена функция mail()',
        'gzcompress' => 'Поддержка сжатия',
        'gzcompress_help' => 'Для корректной работы CMS требуется поддержка функции gzcompress',
        'zip' => 'Наличие библиотеки Zip',
        'zip_help' => 'Для работы с архивами требуется расширение zip',
        'master' => 'Мастер установки JohnCMS mod by Simba',
        'step1' => 'Шаг 1 - Проверка сервера',
        'step2' => 'Шаг 2 - Загрузка архива',
        'step3' => 'Шаг 3 - Распаковка архива',
        'step4' => 'Шаг 4 - Установка CMS',
        'step5' => 'Шаг 5 - Завершение установки и очистка',
        'version' => 'Версия',
        'download_success' => 'Загрузка дистрибутива завершена, можно перейти к следующему щагу',
        'download_error' => 'Ошибка загрузки дистриутива',
        'step2_title' => 'Загрузка дистрибутива',
        'step3_title' => 'Распаковка дистрибутива',
        'step4_title' => 'Установка CMS',
        'step5_title' => 'Завершение установки',
        'unpack_completed' => 'Архив успешно распакован',
        'error_open_archive' => 'Не удалось открыть архив',
        'db_host' => 'Сервер',
        'db_user' => 'Пользователь',
        'db_pass' => 'Пароль',
        'db_name' => 'Имя базы данных',
        'db_params' => 'Параметры подключения к БД',
        'site_params' => 'Настройки сайта',
        'siteurl' => 'Адрес сайта',
        'sitemail' => 'E-mail сайта',
        'admin' => 'Логин администратора сайта',
        'password' => 'Пароль администратора сайта',
        'empty_fields' => 'Заполните все поля',
        'script_deleted' => 'Служебные скрипты удалены, теперь вы можете перйти на сайт!',
        'to_site' => 'Перейти на сайт',
        'install_completed' => 'Установка успешно завершена, осталось пройти завершающий этап!',

    );
    $en = array();

    if ($_SESSION['lang'] == 'en') {
        if (array_key_exists($key, $en)) {
            return $en[$key];
        } else {
            return $key;
        }
    } else {
        if (array_key_exists($key, $ru)) {
            return $ru[$key];
        } else {
            return $key;
        }
    }
}

class CMSSetup
{

    public function serverCheck()
    {
        $return = array(
            'php' => array(
                'name' => lang('php_version'),
                'req' => '5.4.0',
                'current' => '',
                'help' => lang('php_version_help'),
                'error' => false
            ),
            'mysqli' => array(
                'name' => lang('mysqli'),
                'req' => 'MySQLi',
                'current' => lang('loaded'),
                'help' => lang('mysqli_help'),
                'error' => false
            ),
            'gd' => array(
                'name' => lang('gd'),
                'req' => 'GD library',
                'current' => lang('loaded'),
                'help' => lang('gd_help'),
                'error' => false
            ),
            'zlib' => array(
                'name' => lang('zlib'),
                'req' => 'zlib',
                'current' => lang('loaded'),
                'help' => '',
                'error' => false
            ),
            'mbstring' => array(
                'name' => lang('mbstring'),
                'req' => 'mbstring',
                'current' => lang('loaded'),
                'help' => '',
                'error' => false
            ),
            'mb_internal_encoding' => array(
                'name' => lang('mb_internal_encoding'),
                'req' => 'UTF-8',
                'current' => '',
                'help' => '',
                'error' => false
            ),
            'func_overload' => array(
                'name' => lang('func_overload'),
                'req' => '0',
                'current' => '',
                'help' => lang('func_overload_help'),
                'error' => false
            ),
            'short_open_tag' => array(
                'name' => lang('short_open_tag'),
                'req' => '1',
                'current' => '',
                'help' => '',
                'error' => false
            ),
            'register_globals' => array(
                'name' => lang('register_globals'),
                'req' => '0',
                'current' => '',
                'help' => '',
                'error' => false
            ),
            'mail' => array(
                'name' => lang('mail'),
                'req' => 'mail',
                'current' => lang('loaded'),
                'help' => lang('mail_help'),
                'error' => false
            ),
            'gzcompress' => array(
                'name' => lang('gzcompress'),
                'req' => 'gzcompress',
                'current' => lang('loaded'),
                'help' => lang('gzcompress_help'),
                'error' => false
            ),
            'zip' => array(
                'name' => lang('zip'),
                'req' => 'Zip',
                'current' => lang('loaded'),
                'help' => lang('zip_help'),
                'error' => false
            )
        );

        // Check php version
        $return['php']['current'] = phpversion();
        if (version_compare(phpversion(), '5.4.0', '<')) {
            $return['php']['error'] = true;
        }

        // Check MySQLi
        if (!extension_loaded('mysqli')) {
            $return['mysqli']['current'] = lang('not_loaded');
            $return['mysqli']['error'] = true;
        }

        // Check GD lib
        if (!extension_loaded('gd')) {
            $return['gd']['current'] = lang('not_loaded');
            $return['gd']['error'] = true;
        }

        // Check zlib
        if (!extension_loaded('zlib')) {
            $return['zlib']['current'] = lang('not_loaded');
            $return['zlib']['error'] = true;
        }

        // Check mbstring
        if (!extension_loaded('mbstring')) {
            $return['mbstring']['current'] = lang('not_loaded');
            $return['mbstring']['error'] = true;
        }

        // Check encoding settings
        if (function_exists('mb_internal_encoding')) {
            $return['mb_internal_encoding']['current'] = mb_internal_encoding();
            if (mb_internal_encoding() != 'UTF-8') {
                $return['mb_internal_encoding']['current'] = mb_internal_encoding();
                $return['mb_internal_encoding']['error'] = true;
            }
            $return['func_overload']['current'] = ini_get("mbstring.func_overload");
            if (ini_get("mbstring.func_overload") != 0) {
                $return['func_overload']['current'] = ini_get("mbstring.func_overload");
                $return['func_overload']['error'] = true;
            }
        }

        // short_open_tag must be enabled
        $return['short_open_tag']['current'] = ini_get("short_open_tag");
        if (ini_get("short_open_tag") != 1) {
            $return['short_open_tag']['current'] = ini_get("short_open_tag");
            $return['short_open_tag']['error'] = true;
        }

        // register globals must be disabled
        $rg = ini_get("register_globals");
        $return['register_globals']['current'] = (empty($rg) ? '0' : $rg);
        if (ini_get("register_globals") == 1) {
            $return['register_globals']['current'] = ini_get("register_globals");
            $return['register_globals']['error'] = true;
        }

        // mail must be enabled
        if (!function_exists('mail')) {
            $return['mail']['current'] = lang('disabled');
            $return['mail']['error'] = true;
        }

        // gzcompress must be enabled
        if (!function_exists('gzcompress')) {
            $return['gzcompress']['current'] = lang('disabled');
            $return['gzcompress']['error'] = true;
        }

        // Check Zip
        if (!extension_loaded('zip')) {
            $return['zip']['current'] = lang('not_loaded');
            $return['zip']['error'] = true;
        }

        return $return;
    }

    public static function parse_sql($file = false)
    {
        global $connect;
        $errors = array();
        if ($file && file_exists($file)) {
            $query = fread(fopen($file, 'r'), filesize($file));
            $query = trim($query);
            $query = preg_replace("/\n\#[^\n]*/", '', "\n" . $query);
            $buffer = array();
            $ret = array();
            $in_string = false;
            for ($i = 0; $i < strlen($query) - 1; $i++) {
                if ($query[$i] == ";" && !$in_string) {
                    $ret[] = substr($query, 0, $i);
                    $query = substr($query, $i + 1);
                    $i = 0;
                }
                if ($in_string && ($query[$i] == $in_string) && $buffer[1] != "\\") {
                    $in_string = false;
                } elseif (!$in_string && ($query[$i] == '"' || $query[$i] == "'") && (!isset($buffer[0]) || $buffer[0] != "\\")) {
                    $in_string = $query[$i];
                }
                if (isset($buffer[1])) {
                    $buffer[0] = $buffer[1];
                }
                $buffer[1] = $query[$i];
            }
            if (!empty($query)) {
                $ret[] = $query;
            }

            //print_r($ret);

            for ($i = 0; $i < count($ret); $i++) {
                $ret[$i] = trim($ret[$i]);
                if (!empty($ret[$i]) && $ret[$i] != "#") {
                    if (!$connect->query($ret[$i])) {
                        $errors[] = $connect->error;
                    }
                }
            }
        } else {
            $errors[] = 'ERROR: SQL file';
        }

        return $errors;
    }
}

$j = new CMSSetup;


$step = (isset($_REQUEST['step']) ? intval($_REQUEST['step']) : '');

if ($step > 0 && $step <= 5) {
    $title = lang('step' . $step);
} else {
    $title = lang('master');
}

$have_error = false;
?>
<!DOCTYPE html>
<html lang="<?= ($_SESSION['lang'] == 'en' ? 'en' : 'ru') ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= $title ?></title>
    <style>
        body {
            background: #ffffff;
            color: #000;
            margin: 0;
            padding: 0;
            font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
        }

        h1 {
            padding: 0;
            margin: 0;
            font-size: 25px;
        }

        h4 {
            padding: 5px 0;
            margin: 0;
        }

        .container {
            background: #f5f5f5;
            max-width: 900px;
            margin: 0 auto;
        }

        .steps {
            width: 100%;
            display: block;
            background: #34495e;
        }

        .steps .step_item {
            display: block;
            float: left;
        }

        .steps .step_item a {
            padding: 10px;
            display: block;
            color: #bdc3c7;
            text-decoration: none;
        }

        .steps .step_item.active a {
            background: #2c3e50;
            color: #ffffff;
        }

        .content {
            min-height: 300px;
            padding: 15px;
        }

        .buttons {
            display: block;
            width: 100%;
            background: #2c3e50;
        }

        .buttons .back {
            float: left;
            display: block;
        }

        .buttons .next {
            float: right;
            display: block;
        }

        .buttons a, button {
            padding: 6px 12px;
            margin: 5px;
            display: block;
            color: #ffffff;
            border-radius: 4px;
            text-decoration: none;
            cursor: pointer;
            font-size: 15px;
        }

        .buttons .next a, button {
            background: #5cb85c;
            border: 1px solid #398439;
        }

        .buttons .next a:hover, button:hover {
            background: #398439;
        }

        .buttons .back a {
            background: #40596f;
            border: 1px solid #253d53;
        }

        .buttons .back a:hover {
            background: #354a61;
        }

        .error_recheck a {
            padding: 6px 12px;
            margin: 5px;
            color: #ffffff;
            border-radius: 4px;
            text-decoration: none;
            background: #5cb85c;
            border: 1px solid #398439;
        }

        .list {

        }

        .list .item {
            margin: 10px 0;
            border-bottom: 1px solid #e5e5e5;
            padding-bottom: 4px;
        }

        .list .item:last-child {
            border: none;
        }

        .list .item .item_name {
            font-weight: bold;
        }

        .list .item .item_cur {

        }

        .list .item .item_req {

        }

        .list .item .item_help {
            color: #6a6a6a;
            font-size: 13px;
        }

        .list .item .success {
            color: #398439;
            font-weight: bold;
        }

        .list .item .error {
            color: #ff0000;
            font-weight: bold;
        }

        input {
            background-color: #fff;
            border: 1px solid #ccc;
            border-radius: 4px;
            padding: 6px 12px;
            font-size: 14px;
            line-height: 1.428571429;
            color: #555;
            min-width: 35%;
        }

        label {
            margin: 0;
            display: block;
            padding: 4px 0;
            font-weight: bold;
            font-size: 14px;
        }

        .input_group {
            display: block;
            margin: 20px 0;
        }

        .error_text {
            color: #ff0000;
            padding: 15px 0;
        }
    </style>
    <script></script>
</head>
<body>
<div class="container">
    <div class="steps">
        <div class="step_item <?= ($step >= 1 ? 'active' : '') ?>">
            <a href="?step=1">1. <?= lang('checking') ?></a>
        </div>
        <div class="step_item <?= ($step >= 2 ? 'active' : '') ?>">
            <a href="?step=2">2. <?= lang('downloading') ?></a>
        </div>
        <div class="step_item <?= ($step >= 3 ? 'active' : '') ?>">
            <a href="?step=3">3. <?= lang('unpacking') ?></a>
        </div>
        <div class="step_item <?= ($step >= 4 ? 'active' : '') ?>">
            <a href="?step=4">4. <?= lang('installing') ?></a>
        </div>
        <div class="step_item <?= ($step >= 5 ? 'active' : '') ?>">
            <a href="?step=5">5. <?= lang('ending') ?></a>
        </div>
        <div style="clear: both;"></div>
    </div>
    <div class="content">
        <?
        switch ($step) {

            case 1:
                $checks = $j->serverCheck();
                ?>
                <h1><?= lang('step1title') ?></h1>

                <div class="list">
                    <? foreach ($checks as $name => $arr_check): ?>
                        <div class="item">
                            <div class="item_name"><?= $arr_check['name'] ?></div>
                            <div class="item_cur">
                                <?= lang('current_value') ?>:
                                    <span class="<?= ($arr_check['error'] ? 'error' : 'success') ?>">
                                        <?= $arr_check['current'] ?>
                                    </span>
                            </div>
                            <div class="item_req">
                                <?= lang('req_value') ?>: <b><?= $arr_check['req'] ?></b>
                            </div>
                            <div class="item_help"><?= $arr_check['help'] ?></div>
                        </div>
                        <? if ($arr_check['error']) {
                            $have_error = true;
                        } ?>
                    <? endforeach; ?>
                </div>
                <?
                break;

            case 2:
                $version = file_get_contents('http://johnmod.symbos.su/getcms.php');
                if (!empty($version)):

                    $arr = json_decode($version);
                    ?>
                    <h1><?= lang('step2_title') ?></h1>
                    <p>
                        <?= lang('version') ?>: <?= $arr->version ?> <br>
                        <?
                        if (copy($arr->url, $_SERVER['DOCUMENT_ROOT'] . '/install.zip')) {
                            echo lang('download_success');
                        } else {
                            echo lang('download_error');
                            $have_error = true;
                        }
                        ?>
                    </p>
                <? else: ?>
                    <? $have_error = true; ?>
                    Ошибочный ответ сервера. Обратитесь на <a href="http://johnmod.symbos.su/forum/">форум
                        поддержки</a> для уточнения деталей.
                <? endif; ?>

                <?
                break;

            case 3:
                ?>
                <h1><?= lang('step3_title') ?></h1>
                <?
                $zip = new ZipArchive;
                if ($zip->open('install.zip') === TRUE) {
                    $zip->extractTo($_SERVER['DOCUMENT_ROOT'] . '/');
                    $zip->close();
                    echo lang('unpack_completed');
                } else {
                    echo lang('error_open_archive');
                    $have_error = true;
                }
                break;
            case 4:

                $db_host = isset($_POST['db_host']) ? htmlentities(trim($_POST['db_host'])) : 'localhost';
                $db_name = isset($_POST['db_name']) ? htmlentities(trim($_POST['db_name'])) : 'johncms';
                $db_user = isset($_POST['db_user']) ? htmlentities(trim($_POST['db_user'])) : 'root';
                $db_pass = isset($_POST['db_pass']) ? htmlentities(trim($_POST['db_pass'])) : '';
                $site_url = isset($_POST['siteurl']) ? preg_replace("#/$#", '', htmlentities(trim($_POST['siteurl']), ENT_QUOTES, 'UTF-8')) : 'http://' . $_SERVER["SERVER_NAME"];
                $site_mail = isset($_POST['sitemail']) ? htmlentities(trim($_POST['sitemail']), ENT_QUOTES, 'UTF-8') : '@';
                $admin_user = isset($_POST['admin']) ? trim($_POST['admin']) : 'admin';
                $admin_pass = isset($_POST['password']) ? trim($_POST['password']) : '';

                // Проверяем заполнение реквизитов базы данных
                if (isset($_POST['check'])) {
                    $error = '';
                    if (empty($db_host) || empty($db_name) || empty($db_user)) {
                        $error = lang('empty_fields');
                    }

                    // Проверяем подключение к серверу базы данных
                    if (empty($error)) {
                        $con_err = false;
                        $connect = new mysqli($db_host, $db_user, $db_pass, $db_name);
                        if ($connect->connect_errno) {
                            $error = "Error: cannot connect to database server: " . $connect->connect_error;
                        }
                    }

                    if (empty($error)) {
                        $connect->query("SET NAMES 'utf8'");
                    }

                    $dbfile = "<?php\r\n\r\n" .
                        "defined('_IN_JOHNCMS') or die ('Error: restricted access');\r\n\r\n" .
                        "return array(
                            'HOST'     => '$db_host',
                            'USER'     => '$db_user',
                            'PASSWORD' => '$db_pass',
                            'DATABASE' => '$db_name',
                        );";
                    if (!file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/incfiles/configs/db.php', $dbfile)) {
                        $error = 'ERROR: Can not write db.php';
                    }

                    if (empty($error)) {
                        CMSSetup::parse_sql($_SERVER['DOCUMENT_ROOT'] . '/install.sql');

                        // Записываем системные настройки
                        $connect->query("UPDATE `cms_settings` SET `val`='" . $_SESSION['lang'] . "' WHERE `key`='lng'");
                        $connect->query("UPDATE `cms_settings` SET `val`='" . $connect->real_escape_string($site_url) . "' WHERE `key`='homeurl'");
                        $connect->query("UPDATE `cms_settings` SET `val`='" . $connect->real_escape_string($site_mail) . "' WHERE `key`='email'");

                        // Создаем Администратора
                        $connect->query("INSERT INTO `users` SET
                            `name` = '" . $connect->real_escape_string($admin_user) . "',
                            `name_lat` = '" . $connect->real_escape_string(mb_strtolower($admin_user)) . "',
                            `password` = '" . md5(md5($admin_pass)) . "',
                            `sex` = 'm',
                            `datereg` = '" . time() . "',
                            `lastdate` = '" . time() . "',
                            `mail` = '" . $connect->real_escape_string($site_mail) . "',
                            `www` = '" . $connect->real_escape_string($site_url) . "',
                            `about` = '',
                            `set_user` = '',
                            `set_forum` = '',
                            `set_mail` = '',
                            `smileys` = '',
                            `rights` = '9',
                            `ip` = '" . ip2long($_SERVER["REMOTE_ADDR"]) . "',
                            `browser` = '" . $connect->real_escape_string(htmlentities($_SERVER["HTTP_USER_AGENT"])) . "',
                            `preg` = '1'
                        ");
                        $user_id = $connect->insert_id;

                        // Устанавливаем сессию и COOKIE c данными администратора
                        $_SESSION['uid'] = $user_id;
                        $_SESSION['ups'] = md5(md5($admin_pass));
                        @setcookie("cuid", base64_encode($user_id), time() + 3600 * 24 * 365);
                        @setcookie("cups", md5($admin_pass), time() + 3600 * 24 * 365);

                        $db_completed = true;
                    }
                }


                ?>
                <h1><?= lang('step4_title') ?></h1>
                <? if (isset($error) && !empty($error)): ?>
                    <div class="error_text"><?= $error ?></div>
                <? endif; ?>
                <? if(!isset($db_completed) || $db_completed !== true): ?>
                <form action="?step=4" method="post">
                    <div class="input_group">
                        <h4><?= lang('db_params') ?></h4>
                        <label for="host"><?= lang('db_host') ?></label>
                        <input type="text" name="db_host" placeholder="localhost" value="<?= $db_host ?>" id="host"
                               required>

                        <label for="user"><?= lang('db_user') ?></label>
                        <input type="text" name="db_user" placeholder="db_user" value="<?= $db_user ?>" id="user"
                               required>

                        <label for="password"><?= lang('db_pass') ?></label>
                        <input type="password" name="db_pass" placeholder="password" value="<?= $db_pass ?>"
                               id="password">

                        <label for="db_name"><?= lang('db_name') ?></label>
                        <input type="text" name="db_name" placeholder="db_name" value="<?= $db_name ?>" id="db_name"
                               required>
                    </div>

                    <div class="input_group">
                        <h4><?= lang('site_params') ?></h4>
                        <label for="siteurl"><?= lang('siteurl') ?></label>
                        <input type="text" name="siteurl" placeholder="" value="<?= $site_url ?>" id="siteurl" required>

                        <label for="sitemail"><?= lang('sitemail') ?></label>
                        <input type="email" name="sitemail" placeholder="" value="<?= $site_mail ?>" id="sitemail"
                               required>

                        <label for="admin"><?= lang('admin') ?></label>
                        <input type="text" name="admin" placeholder="" value="<?= $admin_user ?>" id="admin" required>
                        <label for="password"><?= lang('password') ?></label>
                        <input type="password" name="password" placeholder="" value="<?= $admin_pass ?>" id="password"
                               required>
                    </div>
                    <button type="submit" name="check" value="submit"><?= lang('next') ?></button>
                </form>
                <? else: ?>

                <div class="input_group">
                    <?= lang('install_completed') ?>
                </div>

                <div class="error_recheck">
                    <a href="?step=5"><?= lang('next') ?></a>
                </div>

                <? endif; ?>

                <?
                break;

            case 5:
                unlink($_SERVER['DOCUMENT_ROOT'].'/install.sql');
                unlink($_SERVER['DOCUMENT_ROOT'].'/install.zip');
                unlink(__FILE__);
                ?>
                <h1><?= lang('step5_title') ?></h1>
                <p>
                    <?= lang('script_deleted') ?>
                </p>
                <div class="error_recheck">
                    <a href="/"><?= lang('to_site') ?></a>
                </div>

                <?
                break;

            default:
                ?>

                <h1><?= lang('hello') ?></h1>
                <p>
                    <?= lang('first_text') ?>
                </p>
                <!--p>
                    <?= lang('language') ?>:
                    <? if ($_SESSION['lang'] == 'ru'): ?>
                        <a href="?lang=en">English</a>
                    <? else: ?>
                        <a href="?lang=ru">Russian</a>
                    <? endif; ?>
                </p-->
                <?
        }
        ?>
        <? if ($have_error): ?>
            <div class="error_recheck">
                <a href="?step=<?= $step ?>"><?= lang('recheck') ?></a>
            </div>
        <? endif; ?>
    </div>
    <div class="buttons">
        <? if (!empty($step)): ?>
            <div class="back">
                <a href="?step=<?= ($step - 1) ?>"><?= lang('back') ?></a>
            </div>
        <? endif; ?>
        <? if ($step < 5 && $have_error === false && $step != 4): ?>
            <div class="next">
                <a href="?step=<?= ($step + 1) ?>"><?= lang('next') ?></a>
            </div>
        <? endif; ?>
        <div style="clear: both;"></div>
    </div>

    <div style="clear: both;"></div>
</div>
</body>
</html>





