<?php

function uploadImage($dir, $image, $size = 500) {
    $time = time();
    
    if(!is_dir($dir)) {
        mkdir($dir, 0777, 1);
        mkdir($dir . 'small/', 0777, 1);
        mkdir($dir . 'big/', 0777, 1);
    } 
    if ($image) {
        $newname = $_FILES['image']['name'];    
        move_uploaded_file($image, 'tmp' . DS . $newname);
        $info = @getimagesize('tmp' . DS . $newname);
        if ($info) {
            if ($info[2] > 3) {
                echo '<div>Не верный тип файла</div>';
            } else {                       
                switch ($info[2]) {
                    case 1:
                        $function = 'imagecreatefromgif';
                        break;
                    case 2:
                        $function = 'imagecreatefromjpeg';
                        break;
                    case 3:
                        $function = 'imagecreatefrompng';
                        break;
                }
                $image = $function('tmp' . DS . $newname);
            }
            $x = imagesx($image);
            $y = imagesy($image);

        } else {
            echo '<div>Ошибка загрузки файла</div>';
        }

        $big = $dir . DS . 'big' . DS . $time . '.jpg';
        $small = $dir . DS . 'small' . DS . $time . '.jpg';

        $newimg = imagecreatetruecolor($x, $y);

        if ($info[2] == 3) {
            // прозрачность для png
            imagefill($newimg, 0, 0, imagecolorallocate($newimg, 255, 255, 255));
        } elseif ($info[2] == 1) {
            // прозрачность для gif    
            imagecolortransparent($image, imagecolorallocate($image, 255, 255, 255));    
        }

        imagecopyresampled($newimg, $image, 0, 0, 0, 0, $x, $y, $x, $y);   
        @imagejpeg($newimg, $big, 100);
        
        // пропорционально уменьшить по ширине до 500
        if ($y > $size) {
            $newx = $size;
            $newy = $y * ($size / $x);
        } else {
            $newx = $x;
            $newy = $y;
        }

        $newimg = imagecreatetruecolor($newx, $newy);

        if ($info[2] == 3) {
            // прозрачность для png
            imagefill($newimg, 0, 0, imagecolorallocate($newimg, 255, 255, 255));
        } elseif ($info[2] == 1) {
            // прозрачность для gif    
            imagecolortransparent($image, imagecolorallocate($image, 255, 255, 255));    
        }

        imagecopyresampled($newimg, $image, 0, 0, 0, 0, $newx, $newy, $x, $y);   
        @imagejpeg($newimg, $small, 100);
        
        @unlink('tmp' . DS . $newname);

    } else {
        return false;
    }
}


function escape($var) {
    return !empty($var) ? htmlentities($var, ENT_QUOTES | ENT_IGNORE, 'UTF-8') : '';
}

function location($url) {
    ob_end_clean(); 
    ob_start();  
    header('Location: ' . $url);
    exit;
}

function isAdmin() {
    return (isset($_SESSION['admin']) && $_SESSION['admin'] == 1);
}

function setAdmin() {
    $_SESSION['admin'] = 1;
}

function unsetAdmin() {
    unset($_SESSION['admin']);
}

function getData($file) {
    if (!file_exists($file)) {
        return false;
    } else {
        $data = json_decode(file_get_contents($file), 1);
        return is_array($data) ? $data : false;
    }
}

function setData($file, $array) {
    $data = file_put_contents($file, json_encode($array));
    return $data ? true : false;
}

function getItem($file, $item) {
    $data = getData($file);
    
    return is_array($data[$item]) ? $data[$item] : false;
}

function deleteDir($dir) {
    $delete = array_diff(scandir($dir), array('.', '..'));
    
    foreach ($delete as $value) {
        if (is_dir($dir . DS . $value)) {
            deleteDir($dir . DS . $value);
        } else {
            unlink($dir . DS . $value);
        }
    }
    rmdir($dir);
}

function addItem($file, $item) {
    $data = getData($file);
    $data = is_array($data) ? $data : array();
    $data = array_merge($data, $item);
    $return = setData($file, $data);
    
    return $return ? true : false;
}

function deleteItem($file, $item) {
    $data = getData($file);
    unset($data[$item]);
    $data = setData($file, $data);
    deleteDir('static/images/' . $item);
    
    return $data ? true : false;
}

function images($dir) {
    $path = 'static/images';
    $diff = array('.', '..');
    
    $imagesSmall = array_diff(scandir($path . DS . $dir . DS . 'small/'), $diff);
    $imagesBig = array_diff(scandir($path . DS . $dir . DS . 'big/'), $diff);
    
    return ($imagesSmall && $imagesBig) ? array('small' => $imagesSmall, 'big' => $imagesBig) : false;
}

function generateUniqId() {
    return substr(md5(uniqid(time())), 0, 8);
}