<?php
/*
 * Copyright (C) 31.01.2013 Jahak
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
header('Content-Type: text/html; charset=UTF-8');

$url = isset($_GET['url']) ? trim($_GET['url']) : null;

/**
 * specialChars
 * @param string $string
 * @return string
 */
function specialChars($string)
{
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}
?>
<!doctype html>
<html lang="ru">
    <head>
        <meta charset="UTF-8">
        <title>Сканнер сайтов</title>
    </head>
    <body>
        <!--Author: Jahak-->
        <form action="?" method="GET" accept-charset="UTF-8">
            <label for="url">URL:</label>
            <input type="search" name="url" value="<?php echo specialChars($url); ?>" placeholder="http://" id="url" required><br>
            <input type="submit" value="Сканировать">
        </form>
        <?php
        if (isset($url)) {
            if (empty($url)) {
                echo 'Пожалуйста, заполните поле URL';
            } else {
                echo '<u><i>URL:</i></u> <code>' . specialChars($url) . '</code><br>';
                $getHeaders = @get_headers($url, 1);
                if (false === $getHeaders) {
                    echo 'Заголовки недоступны';
                } else {
                    foreach ($getHeaders as $key => $value) {
                        if (!is_int($key)) {
                            echo '<b>' . $key . ':</b>';
                        }
                        if (is_array($value)) {
                            $unique = array_unique($value);
                            if (1 == count($unique)) {
                                echo ' ' . $unique[0] . '<br>';
                            } else {
                                echo '<br>';
                                natcasesort($unique);
                                foreach ($unique as $v) {
                                    echo '&nbsp;&nbsp;&nbsp;&nbsp;' . $v . '<br>';
                                }
                                unset($v);
                            }
                            unset($unique);
                        } else {
                            if (is_int($key)) {
                                echo '<u><i>Код состояния:</i></u> <span style="color: #';
                                if (false === strpos($value, '200')) {
                                    echo 'D97E00;">▲';
                                } else {
                                    echo '2CBB0F;"><b>•</b>';
                                }
                                echo '</span> <code>' . substr($value, 9) . '</code>';
                            } else {
                                echo ' ' . $value;
                            }
                            echo '<br>';
                        }
                    }
                    unset($value, $key);
                }
                unset($getHeaders);
                echo '<hr size="1" noshade>';
                $fileGetContents = @file_get_contents($url);
                if (false === $fileGetContents) {
                    echo 'HTML недоступен';
                } else {
                    echo nl2br(str_replace(' ', '&nbsp;', specialChars($fileGetContents)), false);
                }
                unset($fileGetContents);
            }
        }
        unset($url);
        ?>
    </body>
</html>
