<?php
$arr = array(
    array(
        'login' => 'Admin',
        'password' => '%$T$rweva%TY^Y%V',
        'year' => '1967',
        'sex' => 'm',
        'country' => 'Russia',
        'city' => 'Moscow'
    ),
    array(
        'login' => 'Simon',
        'password' => '^%YDfvsdbT^YEWH',
        'year' => '1986',
        'sex' => 'm',
        'country' => 'Ukraine',
        'city' => 'Dnepropetrovsk'
    ),
    array(
        'login' => 'ValeriYA',
        'password' => '%f6Y%$GH$N^#%B^&*Y^Y%V',
        'year' => '1999',
        'sex' => 'w',
        'country' => 'Russia',
        'city' => 'Moscow'
    ),
    array(
        'login' => 'Rakovskiy',
        'password' => '^YN^J&^$%#$GB#^&J*%^$%#B$$%^',
        'year' => '1995',
        'sex' => 'm',
        'country' => 'Ukraine',
        'city' => 'Novoazovsk'
    ),
);

trait RakovskiyTrait 
{
    protected $array;
    protected $condition = array();
    protected $conditionTypes = array('<', '>', '==', '!==', '<=', '>=');
   
    public function getResult() {
        return $this->array;
    }
    
    public function getCond() {
        return $this->condition;
    }
    
    public function setCond($key, $type, $value) {
        /*
        if (!in_array($type, $this->conditionTypes)) {
            throw new Exception('Передан неподдерживаемый тип');
        }
        // прочие проверки
        */
        $this->condition[] = array($key, $type, $value); 
        return $this;       
    }
/*  
    // на самом деле можно сюда абстракцию лепить  
    abstract public function run();
    abstract public function proccess($cond);
*/    
}
     

abstract class RakovskiyAbstract {
    abstract public function run();
    abstract public function proccess($cond);
}

class RakovskiySort extends RakovskiyAbstract { 
    use RakovskiyTrait;

    public function __construct($array) {
        $this->array = $array;
    }

    public function run() {
        foreach($this->getCond() as $cond) {
            $this->proccess($cond);
        }
        $this->condition = array();
        return $this;
    }
    
    public function proccess($cond) {
        $true = array();
        $false = array();
        foreach ($this->getResult() as $k => $val) {
            $conditions = $val[$cond[0]] . $cond[1] . $cond[2];
            if (eval('return (' . $conditions . ');')) {
                $true[] = $this->array[$k];
            } else {
                $false[] = $this->array[$k];
            }
        }
        $this->array = array_merge($true, $false);
    }
}

class RakovskiyWhere extends RakovskiyAbstract { 
    use RakovskiyTrait;

    public function __construct($array) {
        $this->array = $array;
    }

    public function run() {
        foreach($this->getCond() as $cond) {
            $this->proccess($cond);
        }
        $this->condition = array();
        return $this;
    }
    
    public function proccess($cond) {
        $array = array();
        foreach ($this->getResult() as $k => $val) {
            $conditions = $val[$cond[0]] . $cond[1] . $cond[2];
            if (eval('return (' . $conditions . ');')) {
                $array[] = $this->array[$k];
            }
        }
        $this->array = $array;
    }
}

$a = new RakovskiySort($arr);
$b = new RakovskiyWhere($arr);

$a->setCond('sex', '==', 'm')->setCond('year', '<', 1995);
$a->run();
echo '<h1>SORT sex == m and year < 1995</h1>';
echo '<pre>' . print_r($a->getResult(), 1) . '</pre>';

$a->setCond('country', '==', 'Russia');
$a->run();
echo '<h1>SORT country == Russia</h1>';
echo '<pre>' . print_r($a->getResult(), 1) . '</pre>';

$b->setCond('sex', '==', 'm')->setCond('year', '<', 1995)->setCond('country', '==', 'Russia');
$b->run();
echo '<h1>WHERE sex == m and year < 1995 and country == Russia</h1>';
echo '<pre>' . print_r($b->getResult(), 1) . '</pre>';