<?php
mb_internal_encoding('UTF-8');
session_start();
ob_start();
$time = time() + 86400 * 10;
$tsstring = gmdate('D, d M Y H:i:s ', $time) . ' GMT';
header('Expires: ' . $tsstring);
header('Last-Modified: ' . $tsstring);

$id = isset($_GET['id']) ? $_GET['id'] : false;
$act = isset($_GET['act']) ? htmlentities($_GET['act']) : 'default';

function count_results($array) {
$new = array();
foreach($array as $k => $v) {
    $new['count' . $v][] = $k;
}
return array_map('sizeof', $new);
}

echo '<?xml version="1.0" encoding="UTF-8"?>';
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ru" lang="ru">
<head>
<link rel="shortcut icon" href="/static/favicon.ico" type="image/x-icon" />
<meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
<meta http-equiv="lang" content="ru-RU" />
<meta http-equiv="content-style-type" content="text/css" />
<meta http-equiv="cache-control" content="public" />
<meta http-equiv="reply-to" content="compolom@gmail.com" />
<meta name="copyright" content="&copy; 2015" />
<meta name="viewport" content="width=device-width; initial-scale=1.0; maximum-scale=1.0; user-scalable=0;" />
<meta name="author" content="Koenig" />
<meta name="generator" content="PhpED 7.0" />
<meta name="revisit-after" content="5 days" />
<meta name="robots" content="all" />
<meta name="document-state" content="dynamic" />
<meta name="description" content="" />
<meta name="keywords" content="" />
<title>Test vote</title>
<link rel="stylesheet" href="static/css/style.css" type="text/css" />
<script type="text/javascript" src="static/js/jquery.min.js"></script>
<script type="text/javascript">
/* <![CDATA[ */
$(document).ready(function(){
    $('.add-input').click(function(){
        $('<h4>Вариант</h4><div><input type="text" name="options[]" value="" /></div>').prependTo('div.options');
    });
    $('#result').click(function(){
    var res = $('input[name="select"]:checked').val();
    var id = $('input[name="pid"]').val();
        $.ajax({
            url: 'index.php?act=process',
            data: {res:res,id:id},
            success: true,
            dataType: 'html'
            });
        $('#result').hide();
        });
});
/* ]]> */
</script>
<script type="text/javascript">
/* <![CDATA[ */
/* ]]> */
</script>
</head>
<body>
<?php
define('ADM', 1);
define('USER', 1);

if (ADM) {
    echo '<div><a href="?">Опросы</a>' 
    . ' | <a href="?act=add">Добавить опрос</a>'
    . ' | <a href="?act=all">Все опросы</a>';
    
}   
echo '</div>'; 
$obj = array();                        
$dir = new DirectoryIterator('data/votes');
            
foreach ($dir as $fileinfo) {
    if (!$fileinfo->isDot()) {
        $obj[] = json_decode(file_get_contents($fileinfo->getPathname()), 1);
    }
}

switch ($act) {
    default:
    if (is_array($obj)) {
        $current = end($obj);
    } else {
        $current = false;
    }
    
    if (file_exists('data/process/' . $current['id'] . '.json')) {
        $file = json_decode(file_get_contents('data/process/' . $current['id'] . '.json'), 1);
        $rcount = count_results($file);
    } else {
        $rcount = false;
        $file = array();
    }
   
    if ($current) {
        if (!array_key_exists(USER, $file)) {    
            echo '<div id="form"><h1>' . htmlentities($current['text'], ENT_QUOTES, 'UTF-8') . '</h1>'
            . '<div>Ваш выбор?</div>';
    
            foreach($current['options'] as $key => $val) {
                echo '<div>' 
                . '<h3><input type="radio" class="select" name="select" value="' . $key . '" />'
                . '<input type="hidden" name="pid" value="' . $current['id'] . '" />'
                . htmlentities($val, ENT_QUOTES, 'UTF-8') . '</h3></div>';
            }
            echo '<div><input type="submit" name="submit" value="Выбрать" id="result" /></div>' 
            . '</form>'
            . '</div>'; 
        } else {
            echo '<div>';
            foreach($current['options'] as $key => $val) {
                echo '<h3>' . (isset($rcount['count' . $key]) ? $rcount['count' . $key] : 0) . ' - ' . htmlentities($val, ENT_QUOTES, 'UTF-8') . '</h3></div>';
            }
        }   
   }     
    break;
    
    case 'process' :

        $res = (file_exists('data/process/' . $id . '.json') ? json_decode(file_get_contents('data/process/' . $id . '.json'), 1) : false);
        if (!$res) {
            $res = array(USER => intval($_GET['res']));
        } else {
            if (!array_key_exists(USER, $vote)) {
                $res[USER] = intval($_GET['res']);
            } 
        }
        file_put_contents('data/process/' . $id . '.json', json_encode($res));
            
    break;
    
    case 'add' :
    case 'edit' :
    
    if (!ADM) {
        echo '<div>Только админы</div>';    
    } else {
        echo '<div><b>Опросы</b> | ' . (($act == 'add') ? 'Добавить' : 'Редактировать') . ' опрос</div>';
        if ($act == 'edit' && isset($id)) {            
            $data = (file_exists('data/votes/' . $id . '.json') ? json_decode(file_get_contents('data/votes/' . $id . '.json'), 1) : 0);
        }            
        if (isset($_POST['submit'])) {
            $res = array();
            if ($act == 'add') {
                $rid = substr(md5(uniqid(time())), 0, 8);
            } else {
                $rid = $_POST['rid'];
            }
               
            foreach ($_POST['options'] as $key => $val) {
                $res['options'][] = $val;            
            }
            $res['id'] = $rid; 
            $res['text'] = $_POST['text'];
      
            file_put_contents('data/votes/' . $rid . '.json', json_encode($res));
            if ($act == 'edit') {
                if(file_exists('data/process/' . $id . '.json')) {
                    unlink('data/process/' . $id . '.json');
                }
            }
            
            echo '<div>Опрос ' . $rid . ' был ' . (($act == 'add') ? 'добавлен' : 'изменен') . '</div>';                
            echo '<div><a href="?">Назад</a></div>';
            
        } else {
            echo '<form action="?act=' . $act . ($act == 'edit' ? '&amp;id=' . $id : '') . '" method="post">' 
            . '<div>'
            . '<h3>Вопрос опроса</h3>'
            . '<div><textarea rows="5" cols="20" name="text">' . ($act == 'edit' ? htmlentities($data['text'], ENT_QUOTES, 'UTF-8') : '') . '</textarea></div>' 
            . '<h3>Ответы</h3>'
            . '<div class="options">';
            if (isset($data['options'])) {
                foreach($data['options'] as $key => $val) {
                    echo '<h4>Вариант</h4><div><input type="text" name="options[]" value="' . htmlentities($val, ENT_QUOTES, 'UTF-8') . '" /></div>';
                }
            } else {
                echo '<h4>Вариант</h4><div><input type="text" name="options[]" value="" /></div>';
            }
            echo '</div>'; 
            echo '<input type="hidden" name="rid" value="' . $data['id'] . '" />';   
            echo '<div><input type="submit" name="submit" value="Отправить" /></div>' 
            . '</div>'
            . '</form>';
            echo '<button class="add-input">Добавить ответ</button>';
            echo '<div><a href="?">Назад</a></div>';
        }
    }
    break;  
        
    case 'del' :
        
    if (!ADM) {
        echo '<div>Только админы</div>';    
    } else {
        if (isset($_GET['yes'])) {
            unlink('data/votes/' . $id . '.json');

            echo '<div>Опрос был удален</div>';
            echo '<div><a href="?">Назад</a></div>';
        } else {
            echo '<div><div>Действительно удалить вопрос?</div><div><a href="?act=del&amp;id=' . $id . '&amp;yes">Удалить</a> | <a href="?">Отмена</a></div></div>';
        }
    }
    break;
        
    case 'all' : 
            
    if (!ADM) {
        echo '<div>Только админы</div>';    
    } else {
        echo '<div><b>Опросы</b> | Все опросы</div>';
            echo '<div>';
            foreach ($obj as $key => $val) {
                echo '<div>' 
                . '<div>Опрос № ' . $val['id'] . '</div>'
                . '<div><a href="?act=edit&amp;id=' . $val['id'] . '">Редактировать</a> | <a href="?act=del&amp;id=' . $val['id'] . '">Удалить</a></div>'
                . '</div><hr />';
            }
    }
    break;
}


?>

</body>
</html>