/****************************************************************************\
* Dracon AJAX Poll                                                           *
******************************************************************************
* Version: 1.6                                                               *
* Author: Searcher <searcher@dracon.biz>                                     *
* License: http://www.dracon.biz/license.php                                 *
\****************************************************************************/

/* jQuery onReady */
$(document).ready(function () {

  /* Default Functions */
  function gE(Id) {
    return document.getElementById(Id);
  }

  function OkCancel() {
    Msg = (arguments[0]) ? arguments[0] : 'Are you sure?';
    this.blur();
    if (confirm(Msg)) return true;
    return false;
  }

  function compareNumbers(a,b) {  // sort numerical array - descending
     return b-a;
  }

  function strReplace(source,input,output) {
    var temp = source.split(input);
    return temp.join(output);
  }
    
  /* jQuery Plugin - Delay */
  jQuery.fn.delay = function(time,fx) {
    this.each(function() {
      setTimeout(fx,time);
    });
    return this;
  };

  /* jQuery Plugin - Tooltip */
  jQuery.fn.tooltip = function(top,left) {
    this.hover(function(e) {     
      this.xtitle = this.title; this.title = '';
      $(this).parent().append('<div id="tooltip">'+ this.xtitle +'</div>');
      //$('#tooltip').css({opacity:0.8, display:"none"}).fadeIn(400);
      $('#tooltip').css("top",(e.pageY + top) + "px").css("left",(e.pageX + left) + "px");    
    }, function(){
      this.title = this.xtitle;
      $("#tooltip").remove();
    });  
    this.mousemove(function(e){
      $("#tooltip")
        .css("top",(e.pageY + top) + "px")
        .css("left",(e.pageX + left) + "px");
    });    
  };
  
  /* jQuery Plugin - Key Press */
  jQuery.fn.key = function(key,func) {
    $(this).keypress(function(event) {
      if (event.keyCode == key) {
        eval(func);
      }
    });
  };  

  /* Poll Voting Effects */ 
  function dracon_pollVote(pollId,optionId,voted,fadeSpeed,animFx) {
    var divOptions = $('#dracon_poll_'+pollId+' .dracon_poll_options');
    var divAnswers = $('#dracon_poll_'+pollId+' .dracon_poll_answers');
    var divLoader = $('#dracon_poll_'+pollId+' .dracon_poll_loading');
    divOptions.fadeOut(fadeSpeed, function() {
      divLoader.fadeIn(fadeSpeed, function() {
        // change total vote count
        if (voted === false) {
          var totalVotes = $('#dracon_poll_'+pollId+' .dracon_poll_votes');
          var newVotes = parseInt(totalVotes.html()) + optionId.length;
          totalVotes.fadeOut(fadeSpeed, function() {
            totalVotes.html(newVotes);
            totalVotes.fadeIn(fadeSpeed);
          });
        }
        divAnswers.load(webRoot+'?results='+pollId+'&optionId='+optionId+'&voted='+voted, function() {
			    // disable show results click
			    $('#dracon_poll_'+pollId+' .dracon_poll_show_votes').removeClass('dracon_poll_show_votes').unbind();    
  				// do not display results
					var pollVoteArr = $('#dracon_poll_show_votes_'+pollId).html().split(',');
			    if (pollVoteArr[2] == 'no_results') {
						dracon_pollNoVote(pollVoteArr[0],pollVoteArr[1]);
						return false;
			    }
          divLoader.fadeOut(fadeSpeed, function() {
            // find max vote(s)
            var divBarsText = $('#dracon_poll_'+pollId+' .dracon_poll_bars_text');
            var divBars = $('#dracon_poll_'+pollId+' .dracon_poll_bars');
            var barArray = new Array();
            divBarsText.each(function(barCount) {
              barArray[barCount] = this.innerHTML;
            });
            barArray.sort(compareNumbers);
            // change classes for max vote
            divBarsText.each(function() {
              if (this.innerHTML == barArray[0]) {
                $('#dracon_poll_'+pollId+' .dracon_poll_title').addClass('dracon_poll_answers_title');
                $(this).addClass('dracon_poll_answers_max');
                $(this).parent().addClass('dracon_poll_answers_max');
                $(this).next().addClass('dracon_poll_bars_o');
              }
              $(this).append('%');
            });
            // add vote numbers mouseover
            $('#dracon_poll_'+pollId+' li').each(function() {
              $(this).mouseover(function() {
                var voteNum = $(this).children('span').eq(0).html();
                $(this).children('div').eq(0).html(voteNum);
              });
              $(this).mouseout(function() {
                var voteRatio = $(this).children('span').eq(1).html();
                $(this).children('div').eq(0).html(voteRatio+'%');
              });
            });
            // animation style
            if (fadeSpeed > 0) {
              switch (animFx) {
                case 'slide': 
                  divBars.css('display', 'none');
                  divBarsText.css('display', 'none');
                  break;
                case 'fade': 
                  divBars.css('opacity', 0);
                  divBarsText.css('opacity', 0);
                  break;
                case 'full': 
                  var barArray = new Array();
                  divBars.each(function(barCount) {
                    barArray[barCount] = $(this).css('width');
                  });
                  divBars.css('width', '0px');
                  var barTextArray = new Array();
                  var barCount = 0;
                  divBarsText.each(function(barCount) {
                    barTextArray[barCount] = $(this).html();
                  });
                  divBarsText.html('0%');
                  break;
              }
              // fade in results
              divAnswers.fadeIn(fadeSpeed, function() {   
                // animate bars
                switch (animFx) {
                  case 'slide': 
                    divBars.show(fadeSpeed);
                    divBarsText.show(fadeSpeed);
                    break;
                  case 'fade': 
                    divBars.each(function(delayCount) {
                      $(this).animate({ opacity:1 }, fadeSpeed*delayCount);
                    });
                    divBarsText.each(function(delayCount) {
                      $(this).animate({ opacity:1 }, fadeSpeed*delayCount);
                    });
                    break;
                  case 'full': 
                    var barCount = 0;
                    divBars.each(function(barCount) {
                      $(this).animate({ width:barArray[barCount] }, fadeSpeed);
                    });
                    // calculate percentage
                    divBarsText.each(function(barCount) {
                      function textCalc(textObj,value) {
                        var txtCount = 0;
                        function textDraw() {
                          txtCount++;
                          if (txtCount > parseInt(value)) {
                            clearInterval(textInt);
                            txtCount--;
                          }
                          textObj.html(txtCount+'%'); 
                        }
                        var textInt = setInterval(textDraw, 1);
                      }
                      textCalc($(this),barTextArray[barCount]);
                    });
                    break;
                }   
              });
            }
            else divAnswers.fadeIn(fadeSpeed);
          });
        });
      });  
    });
  }
  // poll voting options click
  $('div.dracon_poll_options ul li').each(function() {
    $(this).click(function() {
      // multiple choices
      var multi = $(this).parent().children(0).html();
      var choices = $(this).parent().parent().children('div').children('b');
      if (multi > 1) {
        if ($(this).attr('class').indexOf('dracon_poll_options_active') == -1) {
          if (choices.html() > 0) { 
            choices.html(parseInt(choices.html())-1); 
            $(this).addClass('dracon_poll_options_active'); 
          }
        }
        else {
          choices.html(parseInt(choices.html())+1);
          $(this).removeClass('dracon_poll_options_active'); 
        }
        return false;
      }
      // single choice submission
      //eval($(this).children(0).html())
      var actVal = $(this).children(0).html().split(',');
      dracon_pollVote(actVal[0],actVal[1],false,actVal[3],actVal[4]);
    });
  });
  // multiple choices submit button
  $('.dracon_poll_vote_button').click(function() {
    this.blur();
    var multi = $(this).parent().parent().children(0).children(0).html();
    var choices = $(this).parent().children('b').html();
    if (choices < multi) {
      var pollId = $(this).parent().parent().parent().parent().parent().parent().attr('id').substr(12);
      var optionIds = [];
      var fadeSpeed = animFx = '';
      $('div.dracon_poll_options ul li').each(function() {
        if ($(this).attr('class').indexOf('dracon_poll_options_active') != -1) {
          var optionArray = $(this).children(0).html().split(',');
          optionIds.push(optionArray[1]);
          fadeSpeed = optionArray[3];
          animFx = optionArray[4];
        }
      });
      // multiple choices submission
      dracon_pollVote(pollId,optionIds,false,fadeSpeed,animFx);
    }
  });
  
  // do not display results
  function dracon_pollNoVote(pollId,fadeSpeed) {
    var divOptions = $('#dracon_poll_'+pollId+' .dracon_poll_options');
    var divLoader = $('#dracon_poll_'+pollId+' .dracon_poll_loading');
    divOptions.fadeOut(fadeSpeed, function() {
      divLoader.fadeIn(fadeSpeed, function() {
        divOptions.load(webRoot+'?noresults=true', function() {
          divLoader.fadeOut(fadeSpeed, function() {
            divOptions.fadeIn(fadeSpeed);
          });
        });
      });
    });
  }
  
  // admin loading icon
  function dpa_lg() {
    if ($('#dracon_poll_admin_loading').css('visibility') == 'hidden') {
      $('#dracon_poll_admin_loading').css('visibility','visible');
    }
    else $('#dracon_poll_admin_loading').css('visibility','hidden');
  }

  // admin area reload
  function dpa_area(page) {
    $('#dracon_poll_admin_area').fadeIn(300, function() {
      switch (page) {
        case 1 : 
          dracon_poll_admin_buttons();
          break;
        case 2 : 
          dracon_poll_admin_buttons();
          dracon_poll_admin_option_buttons();
          break;
      }
      dracon_poll_tooltips();
      dpa_lg();
    });
  }
  
  // input onclick select
  /*
  $('input').click(function() { 
    this.select();
  });
  */
  
  // tooltips
  function dracon_poll_tooltips() {
    $("img.dracon_poll_admin_info").tooltip(-20,15);
    $("span.dracon_poll_admin_info_obj").tooltip(-20,15);
  }

  // admin login init
  $('#dracon_poll_admin_user').focus();
  
  // login function
  function dracon_poll_admin_login() {
    if (!$('#dracon_poll_admin_user').attr('value')) {
      $('#dracon_poll_admin_user').attr('value', 'enter login');
      $('#dracon_poll_admin_user').addClass($('#dracon_poll_admin_user').attr('class')+'_on');
      $('#dracon_poll_admin_user').focus().select();
      return false;
    }
    if (!$('#dracon_poll_admin_pass').attr('value')) {
      $('#dracon_poll_admin_pass').attr('value', 'xxx');
      $('#dracon_poll_admin_pass').addClass($('#dracon_poll_admin_pass').attr('class')+'_on');
      $('#dracon_poll_admin_pass').focus().select();
      return false;
    }
    oldHtml = $('#dracon_poll_admin_login_btn').html();
    $('#dracon_poll_admin_login_btn').html('Loading...');
    dpa_lg();
    $('#dracon_poll_admin_login_btn').load('?login', { login:$('#dracon_poll_admin_user').attr('value'), password:$('#dracon_poll_admin_pass').attr('value') }, function(jsCode) {
      $(this).html(oldHtml);
      switch (jsCode) {
        case 'login' :
          $('#dracon_poll_admin_user').addClass($('#dracon_poll_admin_user').attr('class')+'_err');
          $('#dracon_poll_admin_user').attr('value', 'incorrect login');
          $('#dracon_poll_admin_user').focus();
          dpa_lg();
          break;
        case 'password' :
          $('#dracon_poll_admin_pass').attr('value', 'xxxxx');
          $('#dracon_poll_admin_pass').addClass($('#dracon_poll_admin_pass').attr('class')+'_err');
          $('#dracon_poll_admin_pass').focus();
          dpa_lg();
          break;
        case 'ok' :
          $('#dracon_poll_admin_area').fadeOut(500, function() {
            $('#dracon_poll_admin_logout_btn').css('opacity', '0').css('visibility', 'visible');
            $('#dracon_poll_admin_logout_btn').animate({ opacity:1 }, 300);
            $('#dracon_poll_admin_area').load('?admin', function() {
              dpa_area(1);
            })
          })
          break;
      }
    });
  }
  
  // flexible admin button actions
  function dracon_poll_admin_buttons() {

    // login input enter
    $("#dracon_poll_admin_user").key(13,'dracon_poll_admin_login()');
    $("#dracon_poll_admin_pass").key(13,'dracon_poll_admin_login()');
    
    // login button
    $('#dracon_poll_admin_login_btn').click(function() {
      this.blur();
      dracon_poll_admin_login();
    });
    
    // admin input control
    var dracon_poll_admin_inputs = new Array('40','120','200');
    for (i=0; i<dracon_poll_admin_inputs.length; i++) {
      $('input.dracon_poll_admin_input_'+dracon_poll_admin_inputs[i]).click(function() {
        if (this.className.indexOf('_on') == -1) this.className = this.className+'_on';
      });
      $('input.dracon_poll_admin_input_'+dracon_poll_admin_inputs[i]).focus(function() {
        if (this.className.indexOf('_on') == -1) this.className = this.className+'_on';
      });
      $('input.dracon_poll_admin_input_'+dracon_poll_admin_inputs[i]).blur(function() {
        this.className = this.className.replace('_on', '');
      });
    }

    // admin checkbox control
    var dracon_poll_admin_checkboxes = new Array('1','2','3');
    for (i=0; i<dracon_poll_admin_checkboxes.length; i++) {
      $('img.dracon_poll_admin_checkbox_'+dracon_poll_admin_checkboxes[i]).click(function() {
        if (this.className.indexOf('_on') == -1) this.className = this.className+'_on';
        else this.className = this.className.replace('_on', '');
      });
      $('img.dracon_poll_admin_checkbox_'+dracon_poll_admin_checkboxes[i]+'_on').click(function() {
        if (this.className.indexOf('_on') == -1) this.className = this.className+'_on';
        else this.className = this.className.replace('_on', '');
      });
    }
    
    // save all
    $('#dracon_poll_admin_save_all').click(function() {
      $('img.dracon_poll_admin_checkbox_1').each(function() {
        this.className = 'dracon_poll_admin_checkbox_1_on';
      });
    });
    
    // add new poll
    $('#dracon_poll_admin_add_new').click(function() {
      this.blur();
      $(this).html('Adding...');
      dpa_lg();
      $('#dracon_poll_admin_area').fadeOut(300, function() {
        $('#dracon_poll_admin_area').load('?addNewPoll', function() {
          dpa_area(1);
        });
      });
    });
    
    // delete poll
    $('img.dracon_poll_admin_del').click(function() {
      this.blur();
      var pollId = this.alt;
      if (OkCancel('Are you sure? Poll #'+pollId+' will be removed and all related options and votes destroyed!') === false) return false;
      dpa_lg();
      $('#dracon_poll_admin_area').fadeOut(300, function() {
        $('#dracon_poll_admin_area').load('?delPoll', { pollId:pollId }, function() {
          dpa_area(1);
        });
      });
    });
    
    // save poll details
    var dracon_poll_admin_save_data = new Array('count','pollId','title','multiline','width','height','skin','effect','fxspeed','multichoice','status');
    $('#dracon_poll_admin_poll_save').click(function() {
      this.blur();
      $(this).html('Saving...');
      dpa_lg();
      $('#dracon_poll_admin_area').fadeOut(300, function() {
        var fullData = '';
        var pollData = new Array();
        var dataCounter = 0;
        $('tr.dracon_poll_admin_tr').each(function() {
          var pollCounter = 0;  // within poll
          dataCounter++;  // global array
          $(this).children('td').each(function() {
            var newData = '';
            // input values
            if ($(this).children().attr('value')) pollData[pollCounter] = $(this).children().attr('value');
            // checkboxes & non-inputs
            else {
              var checkBox = $(this).children().attr('class');
              pollData[pollCounter] = (checkBox && checkBox.indexOf('_on') != -1) ? 1 : 0;
            }
            // save checked
            if (pollCounter == 12 && pollData[12] == 1) {
              for (i=1; i<11; i++) {
                //pollData[i] = strReplace(pollData[i].toString(), '&', '%26');
                fullData += '&'+dracon_poll_admin_save_data[i]+'[]='+encodeURIComponent(pollData[i]);
              }
            }
            pollCounter++;
          });
        });
        $('#dracon_poll_admin_area').load('?savePollData', { data:fullData }, function() {
          dpa_area(1);
        });
      });
    });


    // load options
    $('.dracon_poll_text_link').click(function() {
      this.blur();
      var pollId = this.value;
      dpa_lg();
      $('#dracon_poll_admin_area').fadeOut(300, function() {
        $('#dracon_poll_admin_area').load('?loadOptions', { pollId:pollId }, function() {
          dpa_area(2);
        });
      });
    });
    // load options double click on title
    $('.dracon_poll_admin_input_200').dblclick(function() {
      this.blur();
      var pollId = $(this).parent().prev().children('input:first').attr('value');
      dpa_lg();
      $('#dracon_poll_admin_area').fadeOut(300, function() {
        $('#dracon_poll_admin_area').fadeOut(300).load('?loadOptions', { pollId:pollId }, function() {
          dpa_area(2);
        });
      });
    });

    // go back to polls
    $('.dracon_poll_admin_options_link').click(function() {
      this.blur();
      dpa_lg();
      $('#dracon_poll_admin_area').fadeOut(300, function() {
        $('#dracon_poll_admin_area').load('?admin', function() {
          dpa_area(1);
        });
      });
    });
  
  }
  
  // flexible admin button actions - options only
  function dracon_poll_admin_option_buttons() {
    // remove interference
    $('.dracon_poll_admin_input_200').unbind('dblclick');
    
    // add new option
    $('#dracon_poll_admin_add_new').unbind('click').click(function() {
      this.blur();
      var pollId = $(this).parent().children('input:first').val();
      $(this).html('Adding...');
      dpa_lg();
      $('#dracon_poll_admin_area').fadeOut(300, function() {
        $('#dracon_poll_admin_area').load('?addNewOption', { pollId:pollId }, function() {
          dpa_area(2);
        });
      });
    });
    
    // delete option
    $('img.dracon_poll_admin_del').unbind('click').click(function() {
      this.blur();
      var idList = this.alt.split(',');
      if (OkCancel('Are you sure? Option #'+idList[0]+' will be removed from Poll #'+idList[1]+' and all related votes destroyed!') === false) return false;
      dpa_lg();
      $('#dracon_poll_admin_area').fadeOut(300, function() {
        $('#dracon_poll_admin_area').load('?delOption', { optionId:idList[0], pollId:idList[1] }, function() {
          dpa_area(2);
        });
      });
    });
    
    // save option details
    var dracon_poll_admin_save_data = new Array('count','optionId','title','bullet','position','status','votes');
    $('#dracon_poll_admin_poll_save').unbind('click').click(function() {
      this.blur();
      var pollId = $(this).parent().children('input:first').val();
      $(this).html('Saving...');
      dpa_lg();

      $('#dracon_poll_admin_area').fadeOut(300, function() {

        var fullData = '';
        var optionData = new Array();
        var dataCounter = 0;
        $('tr.dracon_poll_admin_tr').each(function() {
          var optionCounter = 0;  // within poll
          dataCounter++;  // global array
          $(this).children('td').each(function() {
            var newData = '';
            // input values
            if ($(this).children().attr('value')) optionData[optionCounter] = $(this).children().attr('value');
            // checkboxes & non-inputs
            else {
              var checkBox = $(this).children().attr('class');
              optionData[optionCounter] = (checkBox && checkBox.indexOf('_on') != -1) ? 1 : 0;
            }
            // save checked
            var optionLength = dracon_poll_admin_save_data.length;
            if (optionCounter == optionLength && optionData[optionLength] == 1) {
              for (i=1; i<optionLength; i++) {
                fullData += '&'+dracon_poll_admin_save_data[i]+'[]='+encodeURIComponent(optionData[i]);
              }
            }
            optionCounter++;
          });
        });
        $('#dracon_poll_admin_area').load('?saveOptionData', { pollId:pollId, data:fullData }, function() {
          dpa_area(2);
        });

      });
    });
    
  }
  
  // admin button actions - logout
  $('#dracon_poll_admin_logout_btn').click(function() {
    this.blur();
    oldHtml = $(this).html();
    $(this).html('Closing...');
    dpa_lg();
    $(this).load('?logout', function() {
      $(this).html(oldHtml);
      $(this).animate({ opacity:0 }, 500)
      $('#dracon_poll_admin_area').fadeOut(300, function() {
        $('#dracon_poll_admin_area').load('?relogin', function() {
          dpa_area(1);
        });
      });
    });
  });
  
  // initialize buttons
  dracon_poll_admin_buttons();
  // initialize tooltips
  dracon_poll_tooltips();
  
  
  /* Poll Installation Effects */ 
  function dracon_poll_install_btn(page) {
    this.blur();
    $('#dracon_poll_install_div').animate({ opacity:0.1 }, 300, function() {
      $('#dracon_poll_install_loading').show();
      $('#dracon_poll_install_div').load('?'+page, function() {
        $('#dracon_poll_install_loading').hide();
        $('#dracon_poll_install_div').animate({ opacity:1 }, 300);
        dracon_poll_admin_buttons();
        dracon_poll_install_buttons();
      });
    });
  }
  // all installation buttons ~ code optimization planned  
  function dracon_poll_install_buttons() {
    $('#dracon_poll_install_inst').unbind('click').click(function() { dracon_poll_install_btn('inst'); });
    $('#dracon_poll_install_begin').unbind('click').click(function() { dracon_poll_install_btn('check'); });
    $('#dracon_poll_install_check').unbind('click').click(function() { dracon_poll_install_btn('check'); });
    $('#dracon_poll_install_read').unbind('click').click(function() { dracon_poll_install_btn('readme'); });
    $('#dracon_poll_install_chlog').unbind('click').click(function() { dracon_poll_install_btn('chlog'); });
    $('#dracon_poll_install_lic').unbind('click').click(function() { dracon_poll_install_btn('lic'); });
    $('#dracon_poll_install_conf').unbind('click').click(function() { dracon_poll_install_btn('conf'); });
    // save config file
    $('#dracon_poll_install_save').unbind('click').click(function() { 
      this.blur();
      var cfgInfo = new Array();
      var fullData = '';
      $(this).html('saving...');
      $('#dracon_poll_install_info').html($('#dracon_poll_install_loading').html());
      $('#dracon_poll_install_div input').each(function(cfgCount) { cfgInfo[cfgCount] = $(this).val(); });
      for (i=0; i<cfgInfo.length; i++) { fullData += '&'+i+'='+encodeURIComponent(cfgInfo[i]); }
      // add data select
      fullData += '&'+i+'='+$('#dracon_poll_data').val();
      // add checkbox
      var checkBox = $('#dracon_poll_install_voted_skip img').attr('class');
      fullData += (checkBox && checkBox.indexOf('_on') != -1) ? '&'+(i+1)+'='+true : '&'+(i+1)+'='+false;
      var checkBox2 = $('#dracon_poll_install_voted_once img').attr('class');
      fullData += (checkBox2 && checkBox2.indexOf('_on') != -1) ? '&'+(i+2)+'='+true : '&'+(i+2)+'='+false;
      var checkBox3 = $('#dracon_poll_install_no_results img').attr('class');
      fullData += (checkBox3 && checkBox3.indexOf('_on') != -1) ? '&'+(i+3)+'='+true : '&'+(i+3)+'='+false;
      $('#dracon_poll_install_div').animate({ opacity:0.1 }, 300, function() {
        $('#dracon_poll_install_loading').show();
        $('#dracon_poll_install_div').load('?save', { data:fullData }, function() {
          $('#dracon_poll_install_loading').hide();
          $('#dracon_poll_install_div').animate({ opacity:1 }, 300);
          dracon_poll_admin_buttons();
          dracon_poll_install_buttons();
        });
      });
    });
    // install db
    $('#dracon_poll_install_db').unbind('click').click(function() { 
      this.blur();
      var oldHtml = $(this).html();
      var dbInfo = new Array();
      var fullData = '';
      $(this).html('installing...');
      $('#dracon_poll_install_info').html($('#dracon_poll_install_loading').html());
      $('#poll_mysql_details input').each(function(dbCount) { dbInfo[dbCount] = $(this).val(); });
      for (i=0; i<dbInfo.length; i++) { fullData += '&'+i+'='+encodeURIComponent(dbInfo[i]); }
      $('#dracon_poll_install_db').load('?db', { data:fullData }, function(jsCode) {
        $(this).html(oldHtml);
        $('#dracon_poll_install_info').css('color', 'green').html(jsCode);
        $('#dracon_poll_install_drop').show();
      });
    });
    // upgrade db
    $('#dracon_poll_upgrade_db').unbind('click').click(function() { 
      this.blur();
      var oldHtml = $(this).html();
      var dbInfo = new Array();
      var fullData = '';
      $(this).html('upgrading...');
      $('#dracon_poll_install_info').html($('#dracon_poll_install_loading').html());
      $('#poll_mysql_details input').each(function(dbCount) { dbInfo[dbCount] = $(this).val(); });
      for (i=0; i<dbInfo.length; i++) { fullData += '&'+i+'='+encodeURIComponent(dbInfo[i]); }
      $('#dracon_poll_upgrade_db').load('?db', { upg:true, data:fullData }, function(jsCode) {
        $(this).html(oldHtml);
        $('#dracon_poll_install_info').css('color', 'green').html(jsCode);
      });
    });
    // drop tables
    $('#dracon_poll_install_drop').unbind('click').click(function() { 
      this.blur();
      var oldHtml = $(this).html();
      var dbInfo = new Array();
      var fullData = '';
      $(this).html('removing...');
      $('#dracon_poll_install_info').html($('#dracon_poll_install_loading').html());
      $('#poll_mysql_details input').each(function(dbCount) { dbInfo[dbCount] = $(this).val(); });
      for (i=0; i<dbInfo.length; i++) { fullData += '&'+i+'='+encodeURIComponent(dbInfo[i]); }
      $('#dracon_poll_install_drop').load('?db', { drop:true, data:fullData }, function(jsCode) {
        $(this).html(oldHtml).hide();
        $('#dracon_poll_install_info').css('color', 'red').html(jsCode);
      });
    });
    // show & hide mysql fields
    $('#dracon_poll_data').unbind('change').change(function() { 
      this.blur();
      if ($('#poll_mysql_details').css('display') == 'none') $('#poll_mysql_details').show();
      else $('#poll_mysql_details').hide();
    });
    // password generator
    $('#dracon_poll_install_genpass').unbind('click').click(function() { 
      this.blur();
      window.open('http://www.dracon.biz/password_generator.php');
      return false;
    });
  }
  
  // init all buttons
  dracon_poll_install_buttons();

  // already voted polls
  $('div.dracon_poll_voted').each(function() { 
    var pollVoteArr = $(this).html().split(',');
    // disable show results click
    $('#dracon_poll_'+pollVoteArr[0]+' .dracon_poll_show_votes').removeClass('dracon_poll_show_votes').unbind();    
    // do not display results
    if (pollVoteArr[2] == 'no_results') dracon_pollNoVote(pollVoteArr[0],pollVoteArr[1]);
    else dracon_pollVote(pollVoteArr[0],pollVoteArr[1],pollVoteArr[2],pollVoteArr[3],pollVoteArr[4]);
  });
  
  // display already voted polls on click
  $('span.dracon_poll_show_votes').click(function() {
    var pollVoteArr = $(this).children('div').html().split(',');
    // disable show results click
    $(this).removeClass('dracon_poll_show_votes').unbind();
    // do not display results
    if (pollVoteArr[2] == 'no_results') dracon_pollNoVote(pollVoteArr[0],pollVoteArr[1]);
    else dracon_pollVote(pollVoteArr[0],pollVoteArr[1],pollVoteArr[2],pollVoteArr[3],pollVoteArr[4]);
  });
  
  /* Automatic Height */
  $('.dracon_poll_body').each(function() {
    var cssheight = $(this).css('height');
    var height = $(this).parent().height();
    if (cssheight == 'auto') $(this).height(height-20);
  });
  
});