<?php
# Disable direct access
if (!defined('POLL_ADMIN_SECURE')) exit('<span style="font:11px calibri; color:#990000">no access</span>');
?>

<table id="dracon_poll_admin_polls" align="center" cellpadding="5" cellspacing="1" style="color:#000; background:#ccc; border:1px solid #990000">
<tr>
  <td colspan="14" class="dracon_poll_admin_header">
    <img class="dracon_poll_admin_info" title="<span style='color:orange'>Control Panel - Polls</span><hr size='1' style='color:#777'>List of all polls in your system. <span style='color:yellow'>Double click</span> on poll <span style='color:yellow'>title</span> to edit the options. Hover for tips." src="../skins/default/gfx/spacer.gif" /> 
    <strong><em>Управление голосованиями</em></strong>
  </td>
</tr>
<tr class="dracon_poll_admin_tr_hr">
	<td></td>
	<td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Poll ID</span><hr size='1' style='color:#777'>This is the <span style='color:yellow'>Id</span> you need to use to display the poll on your website.<br /> Example: <span style='color:yellow'>$pollId = 1;</span>">#</span></td>
	<td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Poll Title</span><hr size='1' style='color:#777'>The current CSS skins allow maximum of <span style='color:yellow'>two lines</span> per title. Note the Multiline option.">Title</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Poll Title Length</span><hr size='1' style='color:#777'>CSS design fix, if your title is <span style='color:yellow'>longer</span> than 1 line this setting changes the <span style='color:yellow'>text padding</span>.">Multi</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Poll Width</span><hr size='1' style='color:#777'>Width of your poll, fully flexible. <br />Default: <span style='color:yellow'>150px</span>">Width</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Poll Height</span><hr size='1' style='color:#777'>Height of your poll, required for CSS shadows. <br />For automatic height enter: <span style='color:yellow'>0</span>">Height</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Poll Skin</span><hr size='1' style='color:#777'>List of available skins. New skins are automatically <span style='color:yellow'>detected</span> when placed into the skins folder.">Skin</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Poll Display Effect</span><hr size='1' style='color:#777'>Display and voting effects: <span style='color:yellow'>full, fade, slide, none</span><br />Select 'none' for fastest responsiveness.">Effect</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Poll Effect Speed</span><hr size='1' style='color:#777'>Speed of the selected display effect in milliseconds. Set to <span style='color:yellow'>0</span> for <span style='color:yellow'>maximum</span> speed.">Speed</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Multiple Choices</span><hr size='1' style='color:#777'>By default a visitor can select only one option. A number higher than <span style='color:yellow'>1</span> will allow multiple choices.">Choices</span></td>
  <td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Poll Status</span><hr size='1' style='color:#777'>To <span style='color:yellow'>disable</span> the poll and disallow further voting deactivate it with this switch.">Active</span></td>
	<td align="center"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Poll Votes</span><hr size='1' style='color:#777'>Number of votes the poll has received. This field is only <span style='color:yellow'>informative</span>. Initial votes in <span style='color:yellow'>future versions</span>.">Votes</span></td>
	<td align="center" style="color:blue"><span id="dracon_poll_admin_save_all" class="dracon_poll_admin_info_obj" onmouseover="this.style.cursor='pointer'" title="<span style='color:orange'>Save Poll</span><br />Any changes you make will be saved when you hit the <span style='color:yellow'>Save button</span> only to polls with this box <span style='color:yellow'>checked</span>.<br /><span style='color:lime'>Click to select all.</span>">Save</span></td>
	<td align="center" style="color:blue"><span class="dracon_poll_admin_info_obj" title="<span style='color:orange'>Delete Poll</span><hr size='1' style='color:#777'>If you no longer want to keep your poll, you can <span style='color:yellow'>remove</span> it with this button. Irreversible.">Del</span></td>
</tr>
<?php
# Define classes
$pollClass = POLL_DATA.'Poll';
$optionClass = POLL_DATA.'Options';
$voteClass = POLL_DATA.'Votes';

# Load poll details
$poll = new $pollClass();
$poll->loadList();
if (isset($poll->objList) && is_array($poll->objList)) {
  $pollCounter = 0;
	foreach($poll->objList as $pollId) {
		$poll->loadDetails($pollId);
		$pollCounter++;
?>
<tr class="dracon_poll_admin_tr">
	<td style="font-size:10px; color:#999" title="Double-click on title to edit options" onmouseover="this.style.cursor='help'"><?php echo $pollCounter; ?>.</td>
	<td><input id="dracon_poll_admin_poll_id[<?php echo $pollCounter; ?>]" class="dracon_poll_text_center dracon_poll_text_link" readonly value="<?php echo $poll->pollId; ?>" style="width:22px" /></td>
	<td><input id="dracon_poll_admin_poll_title[<?php echo $pollCounter; ?>]" class="dracon_poll_admin_input_200" value="<?php echo $poll->title; ?>" style="width:200px" /></td>
  <td style="padding-left:10px"><img id="dracon_poll_admin_poll_multi[<?php echo $pollCounter; ?>]" class="dracon_poll_admin_checkbox_2<?php if ($poll->multiline == 1) echo '_on'; ?>" src="../skins/default/gfx/spacer.gif" /></td>
  <td><input id="dracon_poll_admin_poll_width[<?php echo $pollCounter; ?>]" class="dracon_poll_admin_input_40" maxlength="4" value="<?php echo $poll->width; ?>" style="width:40px" /></td>
  <td><input id="dracon_poll_admin_poll_width[<?php echo $pollCounter; ?>]" class="dracon_poll_admin_input_40" maxlength="4" value="<?php echo $poll->height; ?>" style="width:40px" /></td>
  <td>
      <select class="dracon_poll_admin_sel" id="dracon_poll_admin_poll_skin[<?php echo $pollCounter; ?>]" style="width:60px" onchange="this.blur()">   
      <?php
      # List available skins
      $skinList = srcDirList(POLL_ROOT.'skins/', '*', GLOB_ONLYDIR);
      if (is_array($skinList)) {
        for ($i=0; $i < count($skinList); $i++) {
          echo '<option value="'.$skinList[$i].'"';
          if ($poll->skin == $skinList[$i]) echo ' selected';
          echo '>'.$skinList[$i].'</option>';
        }
      }
      ?>
    </select>
  <td>
    <select class="dracon_poll_admin_sel" id="dracon_poll_admin_poll_effect[<?php echo $pollCounter; ?>]" style="width:60px" onchange="this.blur()">
      <option value="full"<?php if ($poll->effect == 'full') echo ' selected'; ?>>full</option>
      <option value="fade"<?php if ($poll->effect == 'fade') echo ' selected'; ?>>fade</option>
      <option value="slide"<?php if ($poll->effect == 'slide') echo ' selected'; ?>>slide</option>
      <option value="none"<?php if ($poll->effect == 'none') echo ' selected'; ?>>none</option>
    </select>
  </td>
	<td><input id="dracon_poll_admin_poll_padding[<?php echo $pollCounter; ?>]" class="dracon_poll_admin_input_40" value="<?php echo $poll->fxspeed; ?>" style="width:40px" /></td>
  <td><input id="dracon_poll_admin_poll_multichoice[<?php echo $pollCounter; ?>]" class="dracon_poll_admin_input_40" maxlength="2" value="<?php echo $poll->multichoice; ?>" style="width:40px" /></td>
	<td style="padding-left:12px"><img id="dracon_poll_admin_poll_status[<?php echo $pollCounter; ?>]" class="dracon_poll_admin_checkbox_3<?php if ($poll->status == 1) echo '_on'; ?>" src="../skins/default/gfx/spacer.gif" /></td>
  <td style="border-right:1px solid #9999FF"><input id="dracon_poll_admin_poll_votes[<?php echo $pollCounter; ?>]" class="dracon_poll_text_right" readonly value="<?php echo $poll->votes; ?>" style="width:35px; font:normal 11px tahoma" /></td>
  <td style="padding-left:7px"><img id="dracon_poll_admin_poll_save[<?php echo $pollCounter; ?>]" class="dracon_poll_admin_checkbox_1" src="../skins/default/gfx/spacer.gif" /></td>
	<td align="center"><img class="dracon_poll_admin_del" src="../skins/default/gfx/spacer.gif" alt="<?php echo $poll->pollId; ?>" /></td>
</tr>

<?php } } ?>

<tr><td colspan="14" style="padding:0px">&nbsp;</td></tr>
</table>

<div style="padding-top:10px">
<button id="dracon_poll_admin_add_new" class="dracon_poll_admin_button dracon_poll_admin_button_1">Создать новое</button>&nbsp;
<button id="dracon_poll_admin_poll_save" class="dracon_poll_admin_button dracon_poll_admin_button_3">Сохранить</button>
</div>
