<?php
/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */
 
 
defined('_IN_JOHNCMS') or die('Error: restricted access');

if ($rights < 7) {
echo '<div>' . $lng['access_forbidden'] . '</div>';
  require_once ('../incfiles/end.php');
  exit;
}
else {
    switch($do) {
        default:
            $spobj = array();                        
            $dir = new DirectoryIterator('files/data');
            
            foreach ($dir as $fileinfo) {
                if (!$fileinfo->isDot()) {
                    $spobj[] = json_decode(file_get_contents($fileinfo->getPathname()), 1);
                }
            }
            // сортировка в порядке убывания суммы взноса
            usort($spobj, 'cmp');
            
            $total = sizeof($spobj);          
            
            echo '<div class="phdr"><b>Новогодняя лотерея</b> | Спонсоры ' . ($page > 1 ? '| ' . $page . ' страница' : '') . '</div>';            
            
            if ($total) {
                $nav = ($total > $kmess) ? '<div class="topmenu">' . functions::display_pagination('?act=sponsor&amp;', $start, $total, $kmess) . '</div>' : '';
                echo $nav;
                foreach (new LimitIterator(new ArrayIterator($spobj), $start, $kmess) as $res) {
                    echo '<div class="list' . (++$i % 2 ? 2 : 1) . '">'
                    . '<div><a href="../users/profile.php?user=' . $res['spid'] . '">Спонсор ' . $res['spid'] . '</a> вклад (' . $res['spnal'] . ')</div>'
                    . '<div class="sub"><small><a href="?act=sponsor&amp;do=edit&amp;id=' . $res['spid'] . '">Редактировать</a> | <a href="?act=sponsor&amp;do=del&amp;id=' . $res['spid'] . '">Удалить</a></small></div>'
                    . '</div>';
                }
                echo $nav;
                
                echo '<div class="phdr">Всего: ' . $total . '</div>';
            } else {
                echo '<div class="menu">' . $lng['list_empty'] . '</div>';
            }
            
            echo '<div><a href="?act=sponsor&amp;do=add">Добавить спонсора</a></div>';
            echo '<div class="phdr"><a href="?">' . $lng['back'] . '</a></div>';
            
        break;
        
        case 'add' :
        case 'edit' :
            echo '<div class="phdr"><b>Новогодняя лотерея</b> | Спонсоры | ' . (($do == 'add') ? 'Добавить' : 'Редактировать') . ' спонсора</div>';
            
            $data = (file_exists('files/data/' . $id . '.json')) ? json_decode(file_get_contents('files/data/' . $id . '.json'), 1) : '';
            
            if (isset($_POST['submit'])) {
                $spid = ($do == 'add' ? intval($_POST['spid']) : $data['spid']);
                
                $res = array(
                'spnal' => intval($_POST['spnal']), 
                'spid' => $spid, 
                // запрет редактировать ID спонсора
                'sptext' => (isset($_POST['sptext']) ? functions::checkout($_POST['sptext']) : null) 
                );
       
                file_put_contents('files/data/' . $spid . '.json', json_encode($res));
                
                $image = isset($_FILES['image']['tmp_name']) ? $_FILES['image']['tmp_name'] : false;
                
                if ($image) {
                    require('../incfiles/lib/class.upload.php');
      
                    $handle = new upload($image);
                    if ($handle->uploaded) {
                    // Обрабатываем фото
                    $handle->file_new_name_body = $id;
                    $handle->allowed = array(
                                'image/jpeg',
                                'image/gif',
                                'image/png'
                                );
                    $handle->file_max_size = 1024 * $set['flsz'];
                    $handle->file_overwrite = true;
                    $handle->image_resize = true;
                    $handle->image_x = 48;
                    $handle->image_y = 48;
                    $handle->image_convert = 'png';
                    $handle->process('files/images/');  
                    echo $handle->error ? '<div class="alarm">Ошибка загрузки иконки</div>' : '<div class="menu">Иконка была загружена</div>';  
                    }
                    $handle->clean();
                    }
                    echo '<div class="menu">Спонсор был ' . (($do == 'add') ? 'добавлен' : 'изменен') . '</div>';                
                    echo '<div class="phdr"><a href="?act=sponsor">' . $lng['back'] . '</a></div>';
            } else {
                echo '<form name="form" enctype="multipart/form-data" action="?act=sponsor&amp;do=' . $do . ($do == 'edit' ? '&amp;id=' . $id : '') . '" method="post">' 
                . '<div class="menu">'
                // запрет редактировать ID спонсора
                . ($do == 'add' ? '<h3>ID спонсора</h3><div><input type="text" name="spid" value="" /></div>' : '') 
                . '<h3>Сумма поступлений от спонсора</h3>'
                . '<div><input type="text" name="spnal" value="' . ($do == 'edit' ? $data['spnal'] : '') . '" /></div>'         
                . '<h3>Рекламный текст</h3>'
                . '<div>' . bbcode::auto_bb('form', 'sptext') . '<textarea rows="5" name="sptext">' . ($do == 'edit' ? $data['sptext'] : '') . '</textarea></div>'
                . '<div class="sub"><small>Пустое описание спонсор(Anonymous)</small></div>' 
                . '<h3>Загрузить иконку рекламы</h3>'
                . '<div><input type="file" name="image" /></div>'     
                . '<div class="sub"><small>Заменит существующую иконку</small></div>' 
                . '<div class="bmenu"><input type="submit" name="submit" value="' . $lng['save'] . '" /></div>' 
                . '</div>'
                . '</form>';
                echo '<div class="phdr"><a href="?act=sponsor">' . $lng['back'] . '</a></div>';
            }
        break;  
        
        case 'del' :
        
        if (isset($_GET['yes'])) {
            file_exists('files/images/' . $id . '.png') ? unlink('files/images/' . $id . '.png') : '';
            unlink('files/data/' . $id . '.json');
                        
            echo '<div>Спонсор был удален</div>';
            echo '<div class="phdr"><a href="?act=sponsor">' . $lng['back'] . '</a></div>';
        } else {
            echo '<div class="alarm"><div>' . $lng['delete_confirmation'] . '</div><div><a href="?act=sponsor&amp;do=del&amp;id=' . $id . '&amp;yes">' . $lng['delete'] . '</a> | <a href="?act=sponsor' . ($page > 0 ? '&amp;page=' . $page : '') . '">' . $lng['cancel'] . '</a></div></div>';
        }
        break;  
    }
}