<?php

defined('_IN_JOHNCMS') or die('Error: restricted access');
require('../incfiles/head.php');
require('../incfiles/lib/class.upload.php');
/*
  -----------------------------------------------------------------
  Проверяем права доступа
  -----------------------------------------------------------------
 */
if ($user['id'] != $user_id) {
    echo functions::display_error($lng['access_forbidden']);
    require('../incfiles/end.php');
    exit;
}
$lng_smile = core::load_lng('smile');
$settings_personalsmile = parse_ini_file('./includes/profile/settings_personalsmile.ini');

$listSmile = array_diff(scandir('../images/smileys/user/personal/' . $user_id . '/'), array('.', '..', 'index.php','cache.dat'));
$count = count($listSmile);

if ($count > (int) $settings_personalsmile["total"]) { 
// если текущее количество смайлов больше максимального
    echo '<div class="menu">' . $lng_smile["count_error"] . ' ' . $settings_personalsmile["total"] . '</div>';
} else {

    if (isset($_POST['submit'])) {
        $handle = new upload($_FILES['imagefile']);
        if ($handle->uploaded) {
            $nameSmile = strtolower($_FILES['imagefile']['name']);
            $nameSmilename = explode('.', $nameSmile);
            if (strlen($nameSmilename[0]) > 3){
                $nameSmile = substr($nameSmilename[0], 0, 3);
            }else{
                $nameSmile = $nameSmilename[0];
            }
            $handle->file_new_name_body = $nameSmile;
            $handle->allowed = array(
                'image/jpeg',
                'image/gif',
                'image/png'
            );
            $handle->file_max_size = 1024 * (int) $settings_personalsmile["amount"];
            // максимальный размер из конфигов
            $handle->file_overwrite = true; // перезапись вкл.
            $size = getimagesize($_FILES['imagefile']['tmp_name']);
            //проверка размеров
            if (($size[0] <= (int) $settings_personalsmile["height"]) and ( $size[0] <= (int) $settings_personalsmile["width"])) {
                $handle->process('../images/smileys/user/personal/' . $user_id . '/');
                if ($handle->processed) {
                    // определение расширения
                    $type = glob('../images/smileys/user/personal/' . $user_id . '/' . $nameSmile . '*');
                    $type = explode('.', array_pop($type));
                    $type = array_pop($type);
                    
                    echo '<div class="gmenu">' . $lng_smile["down_succ"] . '<br /><a href="profile.php?act=addpersonalsmile">' . $lng_smile["down_more"] . '</a></div>';
                    echo '' . $lng_smile["preview"] . '<br /><img src="../images/smileys/user/personal/' . $user_id . '/' . $nameSmile . '.' . $type . '"/>';
                    
                } else {
                    //слишком большой вес
                    echo '<div class="rmenu">' . $lng_smile["down_error_amount"] . '(' . $lng_smile["down_error_not"] . ' ' . $settings_personalsmile["amount"] . ')' .
                    '<br /><a href="profile.php?act=addpersonalsmile">' . $lng_smile["repeat"] . '</a></div>';
                }
            } else {
                //слишком большие размеры
                echo '<div class="rmenu">' . $lng_smile["down_error_size"] . '(' . $lng_smile["down_error_not"] . ' ' . $settings_personalsmile["height"] . 'x' . $settings_personalsmile["width"] . ')' .
                '<br /><a href="profile.php?act=addpersonalsmile">' . $lng_smile["repeat"] . '</a></div>';
            }
            $handle->clean();
            functions::update_personal_smileys(); // обновление кеша личных смайлов
        }
    } else {
        echo'<form enctype="multipart/form-data" method="post" action="profile.php?act=addpersonalsmile">' .
        '<div class="menu"><p>' . $lng_smile["select"] . ':<br />' .
        '<input type="file" name="imagefile" value="" />' .
        '<input type="hidden" name="MAX_FILE_SIZE" value="' . (int) $settings_personalsmile["amount"] . '" /></p>' .
        '<p><input type="submit" name="submit" value="' . $lng_smile["upload"] . '" />' .
        '</p></div></form>' .
        '<div class="phdr"><small>' . $lng_smile["max_size"] . ' ' . (int) $settings_personalsmile["amount"] . ' kb.</small></div>';
    }
}
echo '<div><a href="profile.php?act=personalsmile">' . $lng_smile["personalsmile"] . '</a></div>';
