/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class OSCPacketDispatcher {
    private Hashtable addressToClassTable = new Hashtable();

    public void addListener(String address, OSCListener listener) {
        this.addressToClassTable.put(address, listener);
    }

    public void dispatchPacket(OSCPacket packet) {
        if (packet instanceof OSCBundle) {
            this.dispatchBundle((OSCBundle)packet);
        } else {
            this.dispatchMessage((OSCMessage)packet);
        }
    }

    public void dispatchPacket(OSCPacket packet, Date timestamp) {
        if (packet instanceof OSCBundle) {
            this.dispatchBundle((OSCBundle)packet);
        } else {
            this.dispatchMessage((OSCMessage)packet, timestamp);
        }
    }

    private void dispatchBundle(OSCBundle bundle) {
        Date timestamp = bundle.getTimestamp();
        OSCPacket[] packets = bundle.getPackets();
        int i = 0;
        while (i < packets.length) {
            this.dispatchPacket(packets[i], timestamp);
            ++i;
        }
    }

    private void dispatchMessage(OSCMessage message) {
        this.dispatchMessage(message, null);
    }

    private void dispatchMessage(OSCMessage message, Date time) {
        Enumeration keys = this.addressToClassTable.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!key.equals(message.getAddress())) continue;
            OSCListener listener = (OSCListener)this.addressToClassTable.get(key);
            listener.acceptMessage(time, message);
        }
    }
}

