/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCListener;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCPort;
import com.illposed.osc.utility.OSCByteArrayToJavaConverter;
import com.illposed.osc.utility.OSCPacketDispatcher;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class OSCPortIn
extends OSCPort
implements Runnable {
    protected boolean isListening;
    protected OSCByteArrayToJavaConverter converter = new OSCByteArrayToJavaConverter();
    protected OSCPacketDispatcher dispatcher = new OSCPacketDispatcher();

    public OSCPortIn(int port) throws SocketException {
        this.socket = new DatagramSocket(port);
        this.port = port;
    }

    public OSCPortIn(int port, InetAddress addr) throws SocketException {
        this.socket = new DatagramSocket(port, addr);
        this.port = port;
    }

    public void run() {
        byte[] buffer = new byte[1536];
        DatagramPacket packet = new DatagramPacket(buffer, 1536);
        while (this.isListening) {
            try {
                this.socket.receive(packet);
                OSCPacket oscPacket = this.converter.convert(buffer, packet.getLength());
                this.dispatcher.dispatchPacket(oscPacket);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void startListening() {
        this.isListening = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stopListening() {
        this.isListening = false;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void addListener(String anAddress, OSCListener listener) {
        this.dispatcher.addListener(anAddress, listener);
    }

    public void close() {
        this.socket.close();
    }
}

