/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCJavaToByteArrayConverter;
import java.util.Enumeration;
import java.util.Vector;

public class OSCMessage
extends OSCPacket {
    protected String address;
    protected Vector arguments;

    public OSCMessage() {
        this.arguments = new Vector();
    }

    public OSCMessage(String newAddress) {
        this(newAddress, null);
    }

    public OSCMessage(String newAddress, Object[] newArguments) {
        this.address = newAddress;
        if (newArguments != null) {
            this.arguments = new Vector(newArguments.length);
            int i = 0;
            while (i < newArguments.length) {
                this.arguments.add(newArguments[i]);
                ++i;
            }
        } else {
            this.arguments = new Vector();
        }
        this.init();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String anAddress) {
        this.address = anAddress;
    }

    public void addArgument(Object argument) {
        this.arguments.add(argument);
    }

    public Object[] getArguments() {
        return this.arguments.toArray();
    }

    protected void computeAddressByteArray(OSCJavaToByteArrayConverter stream) {
        stream.write(this.address);
    }

    protected void computeArgumentsByteArray(OSCJavaToByteArrayConverter stream) {
        stream.write(',');
        if (this.arguments == null) {
            return;
        }
        stream.writeTypes(this.arguments);
        Enumeration en = this.arguments.elements();
        while (en.hasMoreElements()) {
            stream.write(en.nextElement());
        }
    }

    protected void computeByteArray(OSCJavaToByteArrayConverter stream) {
        this.computeAddressByteArray(stream);
        this.computeArgumentsByteArray(stream);
        this.byteArray = stream.toByteArray();
    }
}

