<?
/*
+--------------------------------------------------------
| Class For Sending Mail With Atachments
|================================
| Author: tRiNEX (c) 2005
| Web: http://trinex.ru
| E-mail: admin@trinex.ru, trin@phpinfo.ru
| Date: 03.04.2005
| FileName: email.class.php
| Version: 1.1
+---------------------------------------------------------

>  Класс для отправки писем с вложениями.


*/


Class Email
{
        //Кодировка:
        //var $EmailCharset = 'windows-1251';
var $EmailCharset = 'utf-8';
        //Массив получателей письма:
        var $Emails;

        //Отправитель:
        var $EmailFrom = 'no_reply@waplend.org';

        //Тип письма:
        var $EmailType = 'text/plain';

        //Дополнительный заголовок:
        var $EmailXmailer = 'TRX Mailer';

        //Тема письма:
        var $EmailSubject = 'Mail from waplend.org';

        //E-mail для ошибок
        var $EmailErrorTo = 'no_reply@waplend.org';

        //Дополнительные получатели:
        var $EmailReplyTo;

        // Текст письма:
        var $EmailMessage = 'Прочтите сообщение и проверьте файл!';

        //Это Вам не нужно:
        var $EmailBody;
        var $EmailTo;

        //Массив файлов:
        var $EmailFiles;

        //Заголовки, вам это тоже не нужно:
        var $Headers;

        //Ошибки:
        var $EmailError = 0;
        var $EmailErrors = '';



        //Метод для построения тела письма
        function BuildMessage()
        {
                //Уникальная метка:
                $un_bound = "TRX".time();

                //Заголовок, определяющий адрес отправителя:
                $this->Headers .= "From: ".$this->EmailFrom."\n";

                //Заголовок, определающий тему письма:
                $this->Headers .= "Subject: ".$this->EmailSubject."\n";

                //Проверка переменной EmailErrorTo и добавление заголовка Errors-To:
                if($this->EmailErrorTo != ''){
                        $this->Headers .= "Errors-To: ".$this->EmailErrorTo."\n";
                }

                //Еще несколько заголовков:
                $this->Headers .= "X-Mailer: ".$this->EmailXmailer."\n";
                 //MIME 1.0:
                $this->Headers .= "MIME-Version: 1.0\n";
                //Смешанный тип письма:
                $this->Headers .= "Content-Type: multipart/mixed; boundary=".$un_bound."\n\n";

                //Собираем текст письма:
                $this->EmailBody  = "--".$un_bound."\n";
                //Определаяем тип/подтип письма и его кодировку:
                $this->EmailBody .= "Content-Type: ".$this->EmailType."; charset=".$this->EmailCharset."\n";
                //А также вид кодирования:
                $this->EmailBody .= "Content-Transfer-Encoding: 8bit\n\n";
                //Присоединяем само письмо:
                $this->EmailBody .= $this->EmailMessage;

                //Делаем аттачи:
                if(count($this->EmailFiles) > 0){
                    //Перебираем массив:
                        for($i=0;$i<count($this->EmailFiles);$i++){
                                $rfile = $this->EmailFiles[$i];
                                //Попытка открыть файл:
                                if(!($fd = fopen($rfile, "r"))){

                                    //Ошибка открытия (Файл не найден? Недоступен для чтения?):
                                    $this->EmailErrors .= "Failed to open ".$this->EmailFiles[$i]."!\n";
                                    $this->EmailError = 1;
                                    //Пропускаем остаток цикла:
                                    continue(1);
                                 }

                                //Читаем файл, перекодируем в BASE64 и делим строку на куски:
                                $text = chunk_split(base64_encode(fread($fd, filesize($rfile))));
                                //Уникальная метка:
                                $this->EmailBody .= "\n--".$un_bound."\n";
                                //Заголовок о том, что дальше идет файл:
                                $this->EmailBody .= "Content-Type: application/octet-stream;\n";
                                //И он кодирован в кодировке BASE64:
                                $this->EmailBody .= "Content-Transfer-Encoding: base64\n";
                                $this->EmailBody .= "Content-Type: application/zip; name=\"".basename($rfile)."\"\n";
                                //А также то, что он - аттач и его имя:
                                $this->EmailBody .= "Content-Disposition: attachment; filename = ".basename($rfile)."\n\n";
                                //Ну и сам файл:
                               
                                $this->EmailBody .= $text;
                        }
                }


                //Закрываем тело письма уникальной меткой:
                $this->EmailBody .= "\n--".$un_bound."--\n";

        }

        //Метод отправки письма:
        function SendEmail()
        {
                //Прохдимс циклом по адресатам :) и отправляем каждому письмо. В случае ошибки возращаем FALSE:
                for($i=0; $i < count($this->Emails);$i++){
                        $this->EmailTo = $this->Emails[$i];
                        if(!mail($this->EmailTo, $this->EmailSubject, $this->EmailBody, $this->Headers)){
                                $sent = FALSE;
                                $this->EmailErrors .='Failed to send mail to '.$this->EmailTo.'\n';
                                $this->EmailError = 1;
                        }else{
                                $sent = TRUE;
                        }
                }
                return $sent;
        }

}
// Просьба не использовать класс для распространения нежелательной почты (SPAM)
?>