<?php

ini_set('display_errors', 'On');
error_reporting(E_ALL & ~E_NOTICE);

class md5Decrypt
{
    // Хэш мд5
    private $hash;

    // Результаты поиска
    public  $result = array();

    // Искать ли на всех сайтах
    private $fullSearch = false;

    // Конструируем объект
    function __construct($hash, $fullSearch = false)
    {
        $this->fullSearch = $fullSearch;
        $this->hash = trim($hash);
        set_time_limit(120);
    }

    // Получаем хеш из Баз
    public function decrypt()
    {
        // Прогонка по базам
        $this->baseLOCAL();
        $this->baseRainbow();
        $this->baseMD5HASH();
        $this->baseDECODER();
        $this->baseNOISETTE();
        $this->baseGromweb();
    }

    // Получает контент
    private function getResponse($url, $POSTquery = '')
    {
        if (!($ch = curl_init($url)))
        {
            $context = stream_context_create(array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-Type: application/x-www-form-urlencoded' . PHP_EOL,
                    'content' => $POSTquery,
                ),
            ));
            $response = file_get_contents($url, false, $context);
            return $response;
        }

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 5.1; ru; rv:1.9.0.8) Gecko/2009032609 Firefox/3.0.8");
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $POSTquery);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    // Парсеры разных баз
    private function baseGromweb()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://md5.gromweb.com/?md5=' . $this->hash);
        preg_match('/name="string" value="(.+?)"/i', $response, $matches);
        if ($matches[1] && $matches[1] != '" id=')
            $this->result += array('md5.gromweb.com: <b>' . $matches[1] . '</b>');
    }

    private function baseRainbow()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://www.md5rainbow.com/' . $this->hash);
        preg_match('/(.+?)<br\/><p style="font-size: 9pt;/i', $response, $matches);
        if ($matches[1])
            $this->result += array('md5rainbow.com: <b>' . $matches[1] . '</b>');
    }

    private function baseMD5HASH()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://www.md5-hash.com/md5-hashing-decrypt/' . $this->hash);
        preg_match('/<strong class="result">(.+?)<\/strong>/i', $response, $matches);
        if ($matches[1])
            $this->result += array('md5-hash.com: <b>' . $matches[1] . '</b>');
    }

    private function baseDECODER()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://md5decoder.com/' . $this->hash . '/');
        preg_match('/r>(.+?)</i', $response, $matches);
        if ($matches[1] && !strstr($matches[1], 'type="text/javascript'))
            $this->result += array('md5decoder.com: <b>' . $matches[1] . '</b>');
    }

    private function baseNOISETTE()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = $this->getResponse('http://md5.noisette.ch/?hash=' . $this->hash);
        preg_match('/name="text" value="(.+?)"/i', $response, $matches);
        if ($matches[1])
            $this->result += array('md5.noisette.ch: <b>' . $matches[1] . '</b>');
    }

    private function baseLOCAL()
    {
        if (!$this->fullSearch && $this->result)
            return true;
        $response = parse_ini_file('base.ini');
        if ($response[$this->hash])
            $this->result += array($_SERVER['HTTP_HOST'] . ': <b>' . base64_decode(str_replace('+', '=', $response[$this->hash])) . '</b>');
    }
}

if (isset($_GET['val']))
{
    switch ($_GET['operation'])
    {
        // Шифровка
        case 'encrypt':
            $hash = md5($_GET['val']);
            $value = base64_encode($_GET['val']);
            echo $hash;
            // Кешируем локально
            $baseFile = file_get_contents('base.ini');
            $base = parse_ini_string($baseFile);
            if (!$base[$hash])
                file_put_contents('base.ini', $baseFile . PHP_EOL . $hash . '=' . str_replace('=', '+', $value));
            die;
            break;

        // Расшифровка
        default:
            $decrypt = new md5Decrypt($_GET['val']);
            $decrypt->decrypt();
            if (reset($decrypt->result))
                echo reset($decrypt->result);
            else
                echo 'Ни одна из баз не хранит исходную строку данного хэша';
            die;
    }
}