<?php

/**
 * Conference for JohnCMS
 * Control panel
 * @author Screamer
 * @copyright 2013
 */

/**
 * Control panel
 * @return (string|void)
 */
function action_manage($sys) {
    if ($sys->jl->get_data('user_data', 'rights') != 9) {
        jl_redirect();
    }
    $error = array();
    $settings = $sys->jl->model('settings')->get();
    if (!empty($_POST)) {
    	// Deal of Conferences for user
        if (isset($_POST['cpu'])) {
            $settings['cpu'] = $_POST['cpu'];
        }
        $settings['cpu'] = intval($settings['cpu']);
        if ($settings['cpu'] < 0 || $settings['cpu'] > 999) {
            $error['cpu'] = $sys->lng->wrong_cpu_value;
        }
		// Autoclean time
        if (isset($_POST['autoclean'])) {
            $settings['autoclean'] = $_POST['autoclean'];
        }
        $settings['autoclean'] = intval($settings['autoclean']);
        if ($settings['autoclean'] < 1 || $settings['autoclean'] > 100) {
            $error['autoclean'] = sprintf($sys->lng->wrong_autoclean_value, 1, 100);
        }
        if (empty($error)) {
            if (isset($_POST['clear_logs'])) {
            	// Clear logs
                $sys->jl->model('messages')->remove();
                $sys->jl->model('conference')->clean_update();
            }
            $sys->jl->model('settings')->save($settings);
            jl_redirect('conference');
        }
    }
    $sys->tpl->set_title($sys->lng->control_panel);
    return $sys->tpl->load('manage', array(
	    'error'    => $error,
	    'settings' => $settings,
	    'lang'     => $sys->lng,
    ));
}