<?php

/**
 * Conference for JohnCMS
 * List of conferences
 * @author Screamer
 * @copyright 2013
 */

/**
 * List of conferences
 * @param (int) $user ID of user
 * @param (int) $page Number of page
 * @return (string)
 */
function action_index($sys, $user = 0, $page = 0) {
	$page = intval($page);
	$user = intval($user);
	$usid = null;
	// Get user data
	if ($user != 0) {
		$user = functions::get_user($user);
		if (!$user) {
			jl_redirect();
		}
		$usid = $user['id'];
	}
	// Get list
	$total = $sys->jl->model('conference')->count($usid);
	$list = '';
	$pagination = new JL_Pagination(
		jl_anchor('conference/index/' . (is_null($usid) ? 0 : $usid) . '/'),
		$total,
		$page,
		$sys->jl->get_data('user_settings', 'kmess')
	);
	if ($total > 0) {
		$access_types = array($sys->lng->conf_type_free, $sys->lng->conf_type_friends, $sys->lng->conf_type_private);
		$limit = $pagination->get_position();
		$get_list = $sys->jl->model('conference')->get_list($limit['start'], $limit['end'], $usid);
		$i = 0;
		foreach ($get_list as $item) {
			$list .= $sys->tpl->load('index_list_item', array(
				'i'           => !($i % 2) ? 1 : 2,
				'conf_name'   => htmlspecialchars($item['name'], ENT_QUOTES, 'UTF-8'),
				'conf_id'     => intval($item['id']),
				'access_type' => $access_types[intval($item['type'])],
				'lang'        => $sys->lng,
				'owner'       => is_null($usid) ? jl_anchor('conference/index/' . $item['owner_id'], htmlspecialchars($item['owner_name'])) : '',
			));
			$i++;
		}
	}
	// Top menu
	$top_menu = array(jl_anchor('conference/form', $sys->lng->create_conference));
	if (is_null($usid)) {
		$top_menu[] = jl_anchor('conference/index/' . $sys->jl->get_data('user_data', 'id'), $sys->lng->my_conferences);
	} else {
		$top_menu[] = jl_anchor('conference/', $sys->lng->all_conferences);
	}
	if ($sys->jl->get_data('user_data', 'rights') == 9) {
		$top_menu[] = jl_anchor('conference/manage', $sys->lng->control_panel);
	}
	$sys->tpl->set_title($sys->lng->conferences);
	return $sys->tpl->load('index', array(
		'title'      => $sys->lng->conferences . (!is_null($usid) ? ': ' . htmlspecialchars($user['name']) : ''),
		'list'       => !empty($list) ? $list : jl_message($sys->lng->list_empty),
		'total'      => sprintf($sys->lng->total, $total),
		'pagination' => $pagination->create_links(),
		'top_menu'   => $top_menu,
	));
}