<?php
    
/**
 * @package     JohnCMS
 * @link        http://johncms.com
 * @copyright   Copyright (C) 2008-2011 JohnCMS Community
 * @license     LICENSE.txt (see attached file)
 * @version     VERSION.txt (see attached file)
 * @author      http://johncms.com/about
 */

function act_name($element) {
return substr($element, 0, -4);
}

function mail_utf8($to, $subject = '(No subject)', $message = '', $header = ''){ 
$header_ = 'MIME-Version: 1.0' . PHP_EOL;
mail($to, '=?UTF-8?B?' . base64_encode($subject) . '?=', $message, $header_ . $header); 
}

function get_query_element($element) {
$res = explode('=', $element);    
return array($res[0] => $res[1]);
}    

function get_query() {
$array = array();
foreach (array_values(array_map('get_query_element', explode(';', $_SERVER['QUERY_STRING']))) as $key => $val) {
foreach ($val as $k => $v) {    
$array[$k] = $v;    
}
}
return $array;
}

function compare_fields($array_fields, $array_search) {
$return_array = array();    
foreach ($array_search as $k => $v) {
if (in_array($v, $array_fields)) {
$return_array[] = $v;    
}    
}
return $return_array;    
}

function array_to_xml($array, $xml) {
foreach($array as $key => $value) {
if(is_array($value)) {
$subnode = $xml->addChild('element-' . $key);
array_to_xml($value, $subnode);
} else {
$xml->addChild($key, $value);
}
}
return $xml->asXML(); 
}

function api_out($sql, $type = 'json') {
$array = array();

while($row = mysql_fetch_assoc($sql)) {
$array[] = $row;
}

$types_array = array('json', 'xml');
$type = in_array($type, $types_array) ? $type : 'default';

switch ($type) {
case 'xml' :
$xml = new SimpleXMLElement('<?xml version="1.0"?><data />');
header('Content-type: text/xml');
return array_to_xml($array, $xml);
break;
default :
return json_encode($array, JSON_FORCE_OBJECT); 
}    
}
?>