<?php
namespace jl {
	use jl\exception\Exception;

	/**
	 * JLayer
	 *
	 * Languages handler
	 *
	 * @package JohnCMS
	 * @subpackage JLayer
	 * @author Screamer
	 * @copyright 2013
	 */
	class Language {

		/**
		 * @var \stdClass Storage for phrases
		 */
		protected $storage;

		/**
		 * Constructor
		 *
		 * @param string $path Path to language file
		 *
		 * @throws \jl\exception\Exception
		 * @return \jl\Language
		 */
		public function __construct($path) {
			if (is_file($path)) {
				$file = file_get_contents($path);
				$data = json_decode($file);
				if (!($data instanceof \stdClass)) {
					throw new Exception('Wrong format of language file: ' . $file);
				}
			} else {
				throw new Exception('Language file "' . $path . '" is not exists');
			}
			$this->storage = $data;
		}

		/**
		 * Get phrase
		 *
		 * @param $name
		 *
		 * @return string
		 */
		public function __get($name) {
			if (isset($this->storage->$name)) {
				return $this->storage->$name;
			} else {
				return '#' . $name . '#';
			}
		}

		/**
		 * Cap
		 * @param string $name
		 * @param mixed $value
		 */
		public function __set($name, $value) {
			return;
		}

	}
}